#pragma once

#include <memory>

#include <QDataStream>

#include "pappsomspp/export-import-config.h"
#include "massspectrumcombiner.h"

namespace pappso
{

class MassSpectrumPlusCombiner;

typedef std::shared_ptr<const MassSpectrumPlusCombiner>
  MassSpectrumPlusCombinerCstSPtr;

typedef std::shared_ptr<MassSpectrumPlusCombiner> MassSpectrumPlusCombinerSPtr;

class PMSPP_LIB_DECL MassSpectrumPlusCombiner: public MassSpectrumCombiner
{
  Q_OBJECT

  public:
  Q_INVOKABLE MassSpectrumPlusCombiner(QObject *parent_p = nullptr);
  Q_INVOKABLE MassSpectrumPlusCombiner(int decimal_places,
                                       QObject *parent_p = nullptr);
  MassSpectrumPlusCombiner(const MassSpectrumPlusCombiner &other,
                           QObject *parent_p = nullptr);
  MassSpectrumPlusCombiner(MassSpectrumPlusCombinerCstSPtr other,
                           QObject *parent_p = nullptr);

  virtual ~MassSpectrumPlusCombiner();

  MassSpectrumPlusCombiner &operator=(const MassSpectrumPlusCombiner &other);

  Q_INVOKABLE virtual MapTrace &combine(MapTrace &map_trace,
                                        const Trace &trace) const override;
  Q_INVOKABLE virtual MapTrace &
  combine(MapTrace &map_trace_out, const MapTrace &map_trace_in) const override;

  // # pragma message "This pragma is inside"
  static void registerJsConstructor(QJSEngine *engine);
};

PAPPSO_REGISTER_JS_CLASS(pappso, MassSpectrumPlusCombiner)

} // namespace pappso
