
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaRecorderControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaRecorderControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaRecorderControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaRecorderControl::staticMetaObject);
}


// void QMediaRecorderControl::applySettings()


static void _init_f_applySettings_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_applySettings_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl *)cls)->applySettings ();
}


// qint64 QMediaRecorderControl::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaRecorderControl *)cls)->duration ());
}


// bool QMediaRecorderControl::isMuted()


static void _init_f_isMuted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMuted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorderControl *)cls)->isMuted ());
}


// QUrl QMediaRecorderControl::outputLocation()


static void _init_f_outputLocation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_outputLocation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorderControl *)cls)->outputLocation ());
}


// void QMediaRecorderControl::setMuted(bool muted)


static void _init_f_setMuted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMuted_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl *)cls)->setMuted (arg1);
}


// bool QMediaRecorderControl::setOutputLocation(const QUrl &location)


static void _init_f_setOutputLocation_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setOutputLocation_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<bool > ((bool)((QMediaRecorderControl *)cls)->setOutputLocation (arg1));
}


// void QMediaRecorderControl::setState(QMediaRecorder::State state)


static void _init_f_setState_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setState_2448 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl *)cls)->setState (qt_gsi::QtToCppAdaptor<QMediaRecorder::State>(arg1).cref());
}


// void QMediaRecorderControl::setVolume(double volume)


static void _init_f_setVolume_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl *)cls)->setVolume (arg1);
}


// QMediaRecorder::State QMediaRecorderControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::State>::target_type > ((qt_gsi::Converter<QMediaRecorder::State>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::State>(((QMediaRecorderControl *)cls)->state ()));
}


// QMediaRecorder::Status QMediaRecorderControl::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ((qt_gsi::Converter<QMediaRecorder::Status>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::Status>(((QMediaRecorderControl *)cls)->status ()));
}


// double QMediaRecorderControl::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaRecorderControl *)cls)->volume ());
}


// static QString QMediaRecorderControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaRecorderControl::tr (arg1, arg2, arg3));
}


// static QString QMediaRecorderControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaRecorderControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaRecorderControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("applySettings", "@brief Method void QMediaRecorderControl::applySettings()\n", false, &_init_f_applySettings_0, &_call_f_applySettings_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Method qint64 QMediaRecorderControl::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod ("isMuted?|:muted", "@brief Method bool QMediaRecorderControl::isMuted()\n", true, &_init_f_isMuted_c0, &_call_f_isMuted_c0);
  methods += new qt_gsi::GenericMethod ("outputLocation", "@brief Method QUrl QMediaRecorderControl::outputLocation()\n", true, &_init_f_outputLocation_c0, &_call_f_outputLocation_c0);
  methods += new qt_gsi::GenericMethod ("setMuted|muted=", "@brief Method void QMediaRecorderControl::setMuted(bool muted)\n", false, &_init_f_setMuted_864, &_call_f_setMuted_864);
  methods += new qt_gsi::GenericMethod ("setOutputLocation", "@brief Method bool QMediaRecorderControl::setOutputLocation(const QUrl &location)\n", false, &_init_f_setOutputLocation_1701, &_call_f_setOutputLocation_1701);
  methods += new qt_gsi::GenericMethod ("setState|state=", "@brief Method void QMediaRecorderControl::setState(QMediaRecorder::State state)\n", false, &_init_f_setState_2448, &_call_f_setState_2448);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QMediaRecorderControl::setVolume(double volume)\n", false, &_init_f_setVolume_1071, &_call_f_setVolume_1071);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QMediaRecorder::State QMediaRecorderControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("status", "@brief Method QMediaRecorder::Status QMediaRecorderControl::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method double QMediaRecorderControl::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += gsi::qt_signal<const QUrl & > ("actualLocationChanged(const QUrl &)", "actualLocationChanged", gsi::arg("location"), "@brief Signal declaration for QMediaRecorderControl::actualLocationChanged(const QUrl &location)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMediaRecorderControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("position"), "@brief Signal declaration for QMediaRecorderControl::durationChanged(qint64 position)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("error(int, const QString &)", "error", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QMediaRecorderControl::error(int error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("mutedChanged(bool)", "mutedChanged", gsi::arg("muted"), "@brief Signal declaration for QMediaRecorderControl::mutedChanged(bool muted)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMediaRecorderControl::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > ("stateChanged(QMediaRecorder::State)", "stateChanged", gsi::arg("state"), "@brief Signal declaration for QMediaRecorderControl::stateChanged(QMediaRecorder::State state)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaRecorder::Status>::target_type & > ("statusChanged(QMediaRecorder::Status)", "statusChanged", gsi::arg("status"), "@brief Signal declaration for QMediaRecorderControl::statusChanged(QMediaRecorder::Status status)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("volumeChanged(double)", "volumeChanged", gsi::arg("volume"), "@brief Signal declaration for QMediaRecorderControl::volumeChanged(double volume)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaRecorderControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMediaRecorderControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QMediaRecorderControl> decl_QMediaRecorderControl (qtdecl_QMediaControl (), "QtMultimedia", "QMediaRecorderControl_Native",
  methods_QMediaRecorderControl (),
  "@hide\n@alias QMediaRecorderControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaRecorderControl> &qtdecl_QMediaRecorderControl () { return decl_QMediaRecorderControl; }

}


class QMediaRecorderControl_Adaptor : public QMediaRecorderControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaRecorderControl_Adaptor();

  //  [adaptor ctor] QMediaRecorderControl::QMediaRecorderControl()
  QMediaRecorderControl_Adaptor() : QMediaRecorderControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaRecorderControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaRecorderControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaRecorderControl::isSignalConnected(signal);
  }

  //  [expose] int QMediaRecorderControl::receivers(const char *signal)
  int fp_QMediaRecorderControl_receivers_c1731 (const char *signal) const {
    return QMediaRecorderControl::receivers(signal);
  }

  //  [expose] QObject *QMediaRecorderControl::sender()
  QObject * fp_QMediaRecorderControl_sender_c0 () const {
    return QMediaRecorderControl::sender();
  }

  //  [expose] int QMediaRecorderControl::senderSignalIndex()
  int fp_QMediaRecorderControl_senderSignalIndex_c0 () const {
    return QMediaRecorderControl::senderSignalIndex();
  }

  //  [emitter impl] void QMediaRecorderControl::actualLocationChanged(const QUrl &location)
  void emitter_QMediaRecorderControl_actualLocationChanged_1701(const QUrl &location)
  {
    emit QMediaRecorderControl::actualLocationChanged(location);
  }

  //  [adaptor impl] void QMediaRecorderControl::applySettings()
  void cbs_applySettings_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("applySettings");
  }

  virtual void applySettings()
  {
    if (cb_applySettings_0_0.can_issue()) {
      cb_applySettings_0_0.issue<QMediaRecorderControl_Adaptor>(&QMediaRecorderControl_Adaptor::cbs_applySettings_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("applySettings");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::destroyed(QObject *)
  void emitter_QMediaRecorderControl_destroyed_1302(QObject *arg1)
  {
    emit QMediaRecorderControl::destroyed(arg1);
  }

  //  [adaptor impl] qint64 QMediaRecorderControl::duration()
  qint64 cbs_duration_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("duration");
  }

  virtual qint64 duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QMediaRecorderControl_Adaptor, qint64>(&QMediaRecorderControl_Adaptor::cbs_duration_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("duration");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::durationChanged(qint64 position)
  void emitter_QMediaRecorderControl_durationChanged_986(qint64 position)
  {
    emit QMediaRecorderControl::durationChanged(position);
  }

  //  [emitter impl] void QMediaRecorderControl::error(int error, const QString &errorString)
  void emitter_QMediaRecorderControl_error_2684(int _error, const QString &errorString)
  {
    emit QMediaRecorderControl::error(_error, errorString);
  }

  //  [adaptor impl] bool QMediaRecorderControl::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaRecorderControl::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaRecorderControl_Adaptor, bool, QEvent *>(&QMediaRecorderControl_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaRecorderControl::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaRecorderControl::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaRecorderControl::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaRecorderControl_Adaptor, bool, QObject *, QEvent *>(&QMediaRecorderControl_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaRecorderControl::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QMediaRecorderControl::isMuted()
  bool cbs_isMuted_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isMuted");
  }

  virtual bool isMuted() const
  {
    if (cb_isMuted_c0_0.can_issue()) {
      return cb_isMuted_c0_0.issue<QMediaRecorderControl_Adaptor, bool>(&QMediaRecorderControl_Adaptor::cbs_isMuted_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isMuted");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::mutedChanged(bool muted)
  void emitter_QMediaRecorderControl_mutedChanged_864(bool muted)
  {
    emit QMediaRecorderControl::mutedChanged(muted);
  }

  //  [emitter impl] void QMediaRecorderControl::objectNameChanged(const QString &objectName)
  void emitter_QMediaRecorderControl_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMediaRecorderControl::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QUrl QMediaRecorderControl::outputLocation()
  QUrl cbs_outputLocation_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("outputLocation");
  }

  virtual QUrl outputLocation() const
  {
    if (cb_outputLocation_c0_0.can_issue()) {
      return cb_outputLocation_c0_0.issue<QMediaRecorderControl_Adaptor, QUrl>(&QMediaRecorderControl_Adaptor::cbs_outputLocation_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("outputLocation");
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::setMuted(bool muted)
  void cbs_setMuted_864_0(bool muted)
  {
    __SUPPRESS_UNUSED_WARNING (muted);
    throw qt_gsi::AbstractMethodCalledException("setMuted");
  }

  virtual void setMuted(bool muted)
  {
    if (cb_setMuted_864_0.can_issue()) {
      cb_setMuted_864_0.issue<QMediaRecorderControl_Adaptor, bool>(&QMediaRecorderControl_Adaptor::cbs_setMuted_864_0, muted);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setMuted");
    }
  }

  //  [adaptor impl] bool QMediaRecorderControl::setOutputLocation(const QUrl &location)
  bool cbs_setOutputLocation_1701_0(const QUrl &location)
  {
    __SUPPRESS_UNUSED_WARNING (location);
    throw qt_gsi::AbstractMethodCalledException("setOutputLocation");
  }

  virtual bool setOutputLocation(const QUrl &location)
  {
    if (cb_setOutputLocation_1701_0.can_issue()) {
      return cb_setOutputLocation_1701_0.issue<QMediaRecorderControl_Adaptor, bool, const QUrl &>(&QMediaRecorderControl_Adaptor::cbs_setOutputLocation_1701_0, location);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setOutputLocation");
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::setState(QMediaRecorder::State state)
  void cbs_setState_2448_0(const qt_gsi::Converter<QMediaRecorder::State>::target_type & state)
  {
    __SUPPRESS_UNUSED_WARNING (state);
    throw qt_gsi::AbstractMethodCalledException("setState");
  }

  virtual void setState(QMediaRecorder::State state)
  {
    if (cb_setState_2448_0.can_issue()) {
      cb_setState_2448_0.issue<QMediaRecorderControl_Adaptor, const qt_gsi::Converter<QMediaRecorder::State>::target_type &>(&QMediaRecorderControl_Adaptor::cbs_setState_2448_0, qt_gsi::CppToQtAdaptor<QMediaRecorder::State>(state));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setState");
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::setVolume(double volume)
  void cbs_setVolume_1071_0(double volume)
  {
    __SUPPRESS_UNUSED_WARNING (volume);
    throw qt_gsi::AbstractMethodCalledException("setVolume");
  }

  virtual void setVolume(double volume)
  {
    if (cb_setVolume_1071_0.can_issue()) {
      cb_setVolume_1071_0.issue<QMediaRecorderControl_Adaptor, double>(&QMediaRecorderControl_Adaptor::cbs_setVolume_1071_0, volume);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVolume");
    }
  }

  //  [adaptor impl] QMediaRecorder::State QMediaRecorderControl::state()
  qt_gsi::Converter<QMediaRecorder::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QMediaRecorder::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaRecorder::State>(cb_state_c0_0.issue<QMediaRecorderControl_Adaptor, qt_gsi::Converter<QMediaRecorder::State>::target_type>(&QMediaRecorderControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::stateChanged(QMediaRecorder::State state)
  void emitter_QMediaRecorderControl_stateChanged_2448(QMediaRecorder::State state)
  {
    emit QMediaRecorderControl::stateChanged(state);
  }

  //  [adaptor impl] QMediaRecorder::Status QMediaRecorderControl::status()
  qt_gsi::Converter<QMediaRecorder::Status>::target_type cbs_status_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("status");
  }

  virtual QMediaRecorder::Status status() const
  {
    if (cb_status_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QMediaRecorder::Status>(cb_status_c0_0.issue<QMediaRecorderControl_Adaptor, qt_gsi::Converter<QMediaRecorder::Status>::target_type>(&QMediaRecorderControl_Adaptor::cbs_status_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("status");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::statusChanged(QMediaRecorder::Status status)
  void emitter_QMediaRecorderControl_statusChanged_2579(QMediaRecorder::Status status)
  {
    emit QMediaRecorderControl::statusChanged(status);
  }

  //  [adaptor impl] double QMediaRecorderControl::volume()
  double cbs_volume_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("volume");
  }

  virtual double volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QMediaRecorderControl_Adaptor, double>(&QMediaRecorderControl_Adaptor::cbs_volume_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("volume");
    }
  }

  //  [emitter impl] void QMediaRecorderControl::volumeChanged(double volume)
  void emitter_QMediaRecorderControl_volumeChanged_1071(double volume)
  {
    emit QMediaRecorderControl::volumeChanged(volume);
  }

  //  [adaptor impl] void QMediaRecorderControl::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaRecorderControl::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaRecorderControl_Adaptor, QChildEvent *>(&QMediaRecorderControl_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaRecorderControl::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaRecorderControl::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaRecorderControl_Adaptor, QEvent *>(&QMediaRecorderControl_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaRecorderControl::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaRecorderControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaRecorderControl_Adaptor, const QMetaMethod &>(&QMediaRecorderControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaRecorderControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaRecorderControl::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaRecorderControl::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaRecorderControl_Adaptor, QTimerEvent *>(&QMediaRecorderControl_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaRecorderControl::timerEvent(event);
    }
  }

  gsi::Callback cb_applySettings_0_0;
  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isMuted_c0_0;
  gsi::Callback cb_outputLocation_c0_0;
  gsi::Callback cb_setMuted_864_0;
  gsi::Callback cb_setOutputLocation_1701_0;
  gsi::Callback cb_setState_2448_0;
  gsi::Callback cb_setVolume_1071_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_status_c0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaRecorderControl_Adaptor::~QMediaRecorderControl_Adaptor() { }

//  Constructor QMediaRecorderControl::QMediaRecorderControl() (adaptor class)

static void _init_ctor_QMediaRecorderControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMediaRecorderControl_Adaptor> ();
}

static void _call_ctor_QMediaRecorderControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaRecorderControl_Adaptor *> (new QMediaRecorderControl_Adaptor ());
}


// emitter void QMediaRecorderControl::actualLocationChanged(const QUrl &location)

static void _init_emitter_actualLocationChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_actualLocationChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_actualLocationChanged_1701 (arg1);
}


// void QMediaRecorderControl::applySettings()

static void _init_cbs_applySettings_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_applySettings_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_applySettings_0_0 ();
}

static void _set_callback_cbs_applySettings_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_applySettings_0_0 = cb;
}


// void QMediaRecorderControl::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaRecorderControl::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMediaRecorderControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_destroyed_1302 (arg1);
}


// void QMediaRecorderControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QMediaRecorderControl::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaRecorderControl_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// emitter void QMediaRecorderControl::durationChanged(qint64 position)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_durationChanged_986 (arg1);
}


// emitter void QMediaRecorderControl::error(int error, const QString &errorString)

static void _init_emitter_error_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_error_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_error_2684 (arg1, arg2);
}


// bool QMediaRecorderControl::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorderControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaRecorderControl::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorderControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QMediaRecorderControl::isMuted()

static void _init_cbs_isMuted_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isMuted_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorderControl_Adaptor *)cls)->cbs_isMuted_c0_0 ());
}

static void _set_callback_cbs_isMuted_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_isMuted_c0_0 = cb;
}


// exposed bool QMediaRecorderControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaRecorderControl_Adaptor *)cls)->fp_QMediaRecorderControl_isSignalConnected_c2394 (arg1));
}


// emitter void QMediaRecorderControl::mutedChanged(bool muted)

static void _init_emitter_mutedChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_mutedChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_mutedChanged_864 (arg1);
}


// emitter void QMediaRecorderControl::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_objectNameChanged_4567 (arg1);
}


// QUrl QMediaRecorderControl::outputLocation()

static void _init_cbs_outputLocation_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_cbs_outputLocation_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorderControl_Adaptor *)cls)->cbs_outputLocation_c0_0 ());
}

static void _set_callback_cbs_outputLocation_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_outputLocation_c0_0 = cb;
}


// exposed int QMediaRecorderControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaRecorderControl_Adaptor *)cls)->fp_QMediaRecorderControl_receivers_c1731 (arg1));
}


// exposed QObject *QMediaRecorderControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaRecorderControl_Adaptor *)cls)->fp_QMediaRecorderControl_sender_c0 ());
}


// exposed int QMediaRecorderControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorderControl_Adaptor *)cls)->fp_QMediaRecorderControl_senderSignalIndex_c0 ());
}


// void QMediaRecorderControl::setMuted(bool muted)

static void _init_cbs_setMuted_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("muted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMuted_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_setMuted_864_0 (arg1);
}

static void _set_callback_cbs_setMuted_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_setMuted_864_0 = cb;
}


// bool QMediaRecorderControl::setOutputLocation(const QUrl &location)

static void _init_cbs_setOutputLocation_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setOutputLocation_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QMediaRecorderControl_Adaptor *)cls)->cbs_setOutputLocation_1701_0 (arg1));
}

static void _set_callback_cbs_setOutputLocation_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_setOutputLocation_1701_0 = cb;
}


// void QMediaRecorderControl::setState(QMediaRecorder::State state)

static void _init_cbs_setState_2448_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setState_2448_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_setState_2448_0 (arg1);
}

static void _set_callback_cbs_setState_2448_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_setState_2448_0 = cb;
}


// void QMediaRecorderControl::setVolume(double volume)

static void _init_cbs_setVolume_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_setVolume_1071_0 (arg1);
}

static void _set_callback_cbs_setVolume_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_setVolume_1071_0 = cb;
}


// QMediaRecorder::State QMediaRecorderControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::State>::target_type > ((qt_gsi::Converter<QMediaRecorder::State>::target_type)((QMediaRecorderControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// emitter void QMediaRecorderControl::stateChanged(QMediaRecorder::State state)

static void _init_emitter_stateChanged_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_2448 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::State>::target_type & >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_stateChanged_2448 (arg1);
}


// QMediaRecorder::Status QMediaRecorderControl::status()

static void _init_cbs_status_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ();
}

static void _call_cbs_status_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Status>::target_type > ((qt_gsi::Converter<QMediaRecorder::Status>::target_type)((QMediaRecorderControl_Adaptor *)cls)->cbs_status_c0_0 ());
}

static void _set_callback_cbs_status_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_status_c0_0 = cb;
}


// emitter void QMediaRecorderControl::statusChanged(QMediaRecorder::Status status)

static void _init_emitter_statusChanged_2579 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_statusChanged_2579 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::Status>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::Status>::target_type & >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_statusChanged_2579 (arg1);
}


// void QMediaRecorderControl::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorderControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// double QMediaRecorderControl::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaRecorderControl_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorderControl_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


// emitter void QMediaRecorderControl::volumeChanged(double volume)

static void _init_emitter_volumeChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("volume");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_volumeChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QMediaRecorderControl_Adaptor *)cls)->emitter_QMediaRecorderControl_volumeChanged_1071 (arg1);
}


namespace gsi
{

gsi::Class<QMediaRecorderControl> &qtdecl_QMediaRecorderControl ();

static gsi::Methods methods_QMediaRecorderControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaRecorderControl::QMediaRecorderControl()\nThis method creates an object of class QMediaRecorderControl.", &_init_ctor_QMediaRecorderControl_Adaptor_0, &_call_ctor_QMediaRecorderControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("emit_actualLocationChanged", "@brief Emitter for signal void QMediaRecorderControl::actualLocationChanged(const QUrl &location)\nCall this method to emit this signal.", false, &_init_emitter_actualLocationChanged_1701, &_call_emitter_actualLocationChanged_1701);
  methods += new qt_gsi::GenericMethod ("applySettings", "@brief Virtual method void QMediaRecorderControl::applySettings()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_applySettings_0_0, &_call_cbs_applySettings_0_0);
  methods += new qt_gsi::GenericMethod ("applySettings", "@hide", false, &_init_cbs_applySettings_0_0, &_call_cbs_applySettings_0_0, &_set_callback_cbs_applySettings_0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaRecorderControl::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaRecorderControl::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMediaRecorderControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaRecorderControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method qint64 QMediaRecorderControl::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QMediaRecorderControl::durationChanged(qint64 position)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_error", "@brief Emitter for signal void QMediaRecorderControl::error(int error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_error_2684, &_call_emitter_error_2684);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaRecorderControl::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaRecorderControl::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@brief Virtual method bool QMediaRecorderControl::isMuted()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("isMuted", "@hide", true, &_init_cbs_isMuted_c0_0, &_call_cbs_isMuted_c0_0, &_set_callback_cbs_isMuted_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaRecorderControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_mutedChanged", "@brief Emitter for signal void QMediaRecorderControl::mutedChanged(bool muted)\nCall this method to emit this signal.", false, &_init_emitter_mutedChanged_864, &_call_emitter_mutedChanged_864);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMediaRecorderControl::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("outputLocation", "@brief Virtual method QUrl QMediaRecorderControl::outputLocation()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_outputLocation_c0_0, &_call_cbs_outputLocation_c0_0);
  methods += new qt_gsi::GenericMethod ("outputLocation", "@hide", true, &_init_cbs_outputLocation_c0_0, &_call_cbs_outputLocation_c0_0, &_set_callback_cbs_outputLocation_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaRecorderControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaRecorderControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaRecorderControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@brief Virtual method void QMediaRecorderControl::setMuted(bool muted)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setMuted", "@hide", false, &_init_cbs_setMuted_864_0, &_call_cbs_setMuted_864_0, &_set_callback_cbs_setMuted_864_0);
  methods += new qt_gsi::GenericMethod ("setOutputLocation", "@brief Virtual method bool QMediaRecorderControl::setOutputLocation(const QUrl &location)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOutputLocation_1701_0, &_call_cbs_setOutputLocation_1701_0);
  methods += new qt_gsi::GenericMethod ("setOutputLocation", "@hide", false, &_init_cbs_setOutputLocation_1701_0, &_call_cbs_setOutputLocation_1701_0, &_set_callback_cbs_setOutputLocation_1701_0);
  methods += new qt_gsi::GenericMethod ("setState", "@brief Virtual method void QMediaRecorderControl::setState(QMediaRecorder::State state)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setState_2448_0, &_call_cbs_setState_2448_0);
  methods += new qt_gsi::GenericMethod ("setState", "@hide", false, &_init_cbs_setState_2448_0, &_call_cbs_setState_2448_0, &_set_callback_cbs_setState_2448_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QMediaRecorderControl::setVolume(double volume)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0, &_set_callback_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QMediaRecorder::State QMediaRecorderControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QMediaRecorderControl::stateChanged(QMediaRecorder::State state)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_2448, &_call_emitter_stateChanged_2448);
  methods += new qt_gsi::GenericMethod ("status", "@brief Virtual method QMediaRecorder::Status QMediaRecorderControl::status()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_status_c0_0, &_call_cbs_status_c0_0);
  methods += new qt_gsi::GenericMethod ("status", "@hide", true, &_init_cbs_status_c0_0, &_call_cbs_status_c0_0, &_set_callback_cbs_status_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_statusChanged", "@brief Emitter for signal void QMediaRecorderControl::statusChanged(QMediaRecorder::Status status)\nCall this method to emit this signal.", false, &_init_emitter_statusChanged_2579, &_call_emitter_statusChanged_2579);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaRecorderControl::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method double QMediaRecorderControl::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_volumeChanged", "@brief Emitter for signal void QMediaRecorderControl::volumeChanged(double volume)\nCall this method to emit this signal.", false, &_init_emitter_volumeChanged_1071, &_call_emitter_volumeChanged_1071);
  return methods;
}

gsi::Class<QMediaRecorderControl_Adaptor> decl_QMediaRecorderControl_Adaptor (qtdecl_QMediaRecorderControl (), "QtMultimedia", "QMediaRecorderControl",
  methods_QMediaRecorderControl_Adaptor (),
  "@qt\n@brief Binding of QMediaRecorderControl");

}

