% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_stepconfint.r
\name{geom_stepconfint}
\alias{geom_stepconfint}
\title{Step function confidence intervals for ggplot2}
\usage{
geom_stepconfint(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Aesthetic mappings with aes() function. Like geom_ribbon(), you must provide
columns for x, ymin (lower limit), ymax (upper limit).}

\item{data}{The data to be displayed in this layer. Can inherit from ggplot parent.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string.
Defaults to 'identity'.}

\item{position}{Position adjustment, either as a string, or the result of a call to a
position adjustment function.}

\item{na.rm}{If FALSE, the default, missing values are removed with a warning. If TRUE,
missing values are silently removed.}

\item{...}{Optional. Any other ggplot geom_ribbon() arguments.}
}
\description{
Produces a step function confidence interval for survival curves.  This function is taken from
the \code{utile.visuals} package by Eric Finnesgard.  That package is not used because of its
strong dependencies.
}
\note{
Originally adapted from the survminer package <https://github.com/kassambara/survminer>.
}
\examples{
require(survival)
require(ggplot2)

f <- survfit(Surv(time, status) ~ trt, data = diabetic)
d <- with(f, data.frame(time, surv, lower, upper, trt=rep(names(f$strata), f$strata)))
ggplot(d, aes(x = time, y=surv)) +
  geom_step(aes(color = trt)) +
  geom_stepconfint(aes(ymin = lower, ymax = upper, fill = trt), alpha = 0.3) +
  coord_cartesian(c(0, 50)) +
  scale_x_continuous(expand = c(0.02,0)) +
  labs(x = 'Time', y = 'Freedom From Event') +
  scale_color_manual(
    values = c('#d83641', '#1A45A7'),
    name = 'Treatment',
    labels = c('None', 'Laser'),
    aesthetics = c('colour', 'fill'))
}
\author{
Eric Finnesgard
}
