# Upgrading to 1.4

## Introduction

The 1.4 release includes a migration that adds and populates the `prefix` and `hashed_key` fields to API keys.

This document lists the steps necessary to upgrade from 1.3.x to 1.4.

## Steps

### 1. Migrate the built-in API key model

The `APIKey` model can be migrated using the migration shipped with this package:

```bash
python manage.py migrate rest_framework_api_key
```

### 2. Migrate custom API key models (if applicable)

If you have a custom API key model deriving from `AbstractAPIKey`, you need to **manually add the migration** to your application.

- Copy the migration script below to your app's `migrations/` directory. Be sure to modify `APP_NAME`, `MODEL_NAME` and `DEPENDENCIES` as seems fit. You can name the migration script `xxxx_prefix_hashed_key.py` (replace `xxxx` with the next available migration ID).

```python
--8<-- "src/rest_framework_api_key/migrations/0004_prefix_hashed_key.py"
```

- Apply the migration:

```bash
python manage.py migrate <my_app>
```
