#include <iostream>
using namespace std;
//code
#include <vector>
#include <string>

template <auto val> class Adder
{
    using Type = decltype(val);

    Type d_sum = Type();            // initialize d_sum

    public:
        Adder()
        {
            cout << "adding " << val << "\n\n";
        }
                                    // append 'val' to vect's elements
        void append(std::vector<Type> &vect)
        {
            for (auto &elem: vect)
            {
                d_sum += elem;
                elem += val;
            }
        }
                                    // show vect's elements
        void show(std::vector<Type> const &vect) const
        {
            for (auto &elem: vect)
                cout << elem << '\n';
            cout.put('\n');
        }

        Type const &total() const   // show vect elements' original sum
        {
            return d_sum;
        }
};

template <auto val>
void process(vector<decltype(val)> &vect)
{
    Adder<val> adder;
    adder.show(vect);
    adder.append(vect);
    adder.show(vect);
    cout << "original sum: " << adder.total() << "\n\n";
}

int main()
{
    vector<int> vi{1, 2, 3, 4};
    process<3>(vi);                     // add 3 to the vi's elements

    vector<double> vd{1.1, 2.2, 3.3, 4.4};
    process<3.5>(vd);                   // add 3.5 to the vd's elements
}
//=
