+++
title = "Icosahedron"
+++

### Icosahedron

A regular icosahedron.


<img src="/img/draw/ff/3d/Icosahedron.png" width="30%">
<!--
<img src="../cut/Icosahedron_xy.svg" width="30%">
<img src="../cut/Icosahedron_xz.svg" width="30%">
-->

#### Constructor

```python
Icosahedron(a)
```

Parameters:
- a, length of the edge

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [Icosahedron]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron with inversion symmetry provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V= \dfrac{5}{12}(3+\sqrt{5})a^3 \approx 2.182 \space a^3. $$

#### Related shapes

- [Dodecahedron](/ref/sample/particle/ff/hard/dodecahedron), a regular dodecahedron. 

#### Example

Scattering by uncorrelated, oriented truncated icosahedra for horizontal incidence:

<img src="/img/auto/ff/Icosahedron.png">

Generated by {{% ref-ex "ff/Icosahedron.py" %}}.

#### History

Introduced in BornAgain 1.6.
