/* rygel-media-export-media-cache.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <rygel-server.h>
#include <glib/gi18n-lib.h>
#include <sqlite3.h>
#include <uuid/uuid.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER (rygel_media_export_sqlite_wrapper_get_type ())
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapper))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_IS_SQLITE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER))
#define RYGEL_MEDIA_EXPORT_SQLITE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQLITE_WRAPPER, RygelMediaExportSqliteWrapperClass))

typedef struct _RygelMediaExportSqliteWrapper RygelMediaExportSqliteWrapper;
typedef struct _RygelMediaExportSqliteWrapperClass RygelMediaExportSqliteWrapperClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR (rygel_media_export_database_cursor_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursor))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE_CURSOR, RygelMediaExportDatabaseCursorClass))

typedef struct _RygelMediaExportDatabaseCursor RygelMediaExportDatabaseCursor;
typedef struct _RygelMediaExportDatabaseCursorClass RygelMediaExportDatabaseCursorClass;

#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR (rygel_media_export_database_cursor_iterator_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIterator))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR))
#define RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_DATABASE_CURSOR_TYPE_ITERATOR, RygelMediaExportDatabaseCursorIteratorClass))

typedef struct _RygelMediaExportDatabaseCursorIterator RygelMediaExportDatabaseCursorIterator;
typedef struct _RygelMediaExportDatabaseCursorIteratorClass RygelMediaExportDatabaseCursorIteratorClass;
#define _rygel_media_export_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_database_cursor_iterator_unref (var), NULL)))
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM (rygel_media_export_video_item_get_type ())
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItem))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM))
#define RYGEL_MEDIA_EXPORT_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM, RygelMediaExportVideoItemClass))

typedef struct _RygelMediaExportVideoItem RygelMediaExportVideoItem;
typedef struct _RygelMediaExportVideoItemClass RygelMediaExportVideoItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM (rygel_media_export_playlist_item_get_type ())
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItem))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM))
#define RYGEL_MEDIA_EXPORT_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM, RygelMediaExportPlaylistItemClass))

typedef struct _RygelMediaExportPlaylistItem RygelMediaExportPlaylistItem;
typedef struct _RygelMediaExportPlaylistItemClass RygelMediaExportPlaylistItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED,
	RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE
} RygelMediaExportSQLString;

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DISC,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID
} RygelMediaExportDetailColumn;

struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sqlite_wrapper_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_media_cache_ensure_exists (GError** error);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error);
static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_database_cursor_get_type (void) G_GNUC_CONST;
static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
gpointer rygel_media_export_database_cursor_iterator_ref (gpointer instance);
void rygel_media_export_database_cursor_iterator_unref (gpointer instance);
GParamSpec* rygel_media_export_database_cursor_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_database_cursor_value_set_iterator (GValue* value, gpointer v_object);
void rygel_media_export_database_cursor_value_take_iterator (GValue* value, gpointer v_object);
gpointer rygel_media_export_database_cursor_value_get_iterator (const GValue* value);
GType rygel_media_export_database_cursor_iterator_get_type (void) G_GNUC_CONST;
RygelMediaExportDatabaseCursorIterator* rygel_media_export_database_cursor_iterator (RygelMediaExportDatabaseCursor* self);
gboolean rygel_media_export_database_cursor_iterator_next (RygelMediaExportDatabaseCursorIterator* self, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_iterator_get (RygelMediaExportDatabaseCursorIterator* self, GError** error);
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error);
guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count);
RygelMediaExportDatabaseCursor* rygel_media_export_database_exec_cursor (RygelMediaExportDatabase* self, const gchar* sql, GValue* arguments, int arguments_length1, GError** error);
sqlite3_stmt* rygel_media_export_database_cursor_next (RygelMediaExportDatabaseCursor* self, GError** error);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
gint rygel_media_export_database_query_value (RygelMediaExportDatabase* self, const gchar* sql, GValue* args, int args_length1, GError** error);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new_root (void);
RygelNullContainer* rygel_null_container_construct_root (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelNullContainer* rygel_null_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title);
RygelNullContainer* rygel_null_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error);
gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token);
void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self);
void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded);
gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error);
static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id);
void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION "16"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
GType rygel_media_export_video_item_get_type (void) G_GNUC_CONST;
GType rygel_media_export_playlist_item_get_type (void) G_GNUC_CONST;
static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
static void rygel_media_export_media_cache_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
	return dup;
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
	g_free (self);
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	gchar* _tmp0_;
	gchar* db_name;
	RygelMediaExportSQLFactory* _tmp5_;
	const gchar* _tmp6_;
	RygelMediaExportObjectFactory* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("media-export");
	db_name = _tmp0_;
	{
		RygelMetaConfig* _tmp1_ = NULL;
		RygelMetaConfig* config;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp1_ = rygel_meta_config_get_default ();
		config = _tmp1_;
		_tmp2_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "use-temp-db", &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch5_g_error;
		}
		if (_tmp3_) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (":memory:");
			_g_free0 (db_name);
			db_name = _tmp4_;
		}
		_g_object_unref0 (config);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = rygel_media_export_sql_factory_new ();
	_g_object_unref0 (self->priv->sql);
	self->priv->sql = _tmp5_;
	_tmp6_ = db_name;
	rygel_media_export_media_cache_open_db (self, _tmp6_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (db_name);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp7_ = rygel_media_export_object_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp7_;
	_g_free0 (db_name);
	return self;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


void rygel_media_export_media_cache_ensure_exists (GError** error) {
	RygelMediaExportMediaCache* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_instance;
	if (_tmp0_ == NULL) {
		RygelMediaExportMediaCache* _tmp1_;
		RygelMediaExportMediaCache* _tmp2_;
		_tmp1_ = rygel_media_export_media_cache_new (&_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_g_object_unref0 (rygel_media_export_media_cache_instance);
		rygel_media_export_media_cache_instance = _tmp2_;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	RygelMediaExportMediaCache* _tmp1_;
	_tmp0_ = rygel_media_export_media_cache_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp3_;
	RygelMediaExportSQLFactory* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp3_ = self->priv->db;
	_tmp4_ = self->priv->sql;
	_tmp5_ = rygel_media_export_sql_factory_make (_tmp4_, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
	rygel_media_export_database_exec (_tmp3_, _tmp5_, values, values_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	rygel_media_export_media_cache_remove_by_id (self, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Add the container to the cache, in a database transcation,
     * rolling back the transaction if necessary.
     */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaContainer* _tmp1_;
		RygelMediaContainer* _tmp2_;
		RygelMediaExportDatabase* _tmp3_;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = container;
		rygel_media_export_media_cache_save_container_metadata (self, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
		_tmp2_ = container;
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			goto __finally6;
		}
		_tmp3_ = self->priv->db;
		rygel_media_export_database_commit (_tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch6_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaExportDatabase* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp4_);
		_tmp5_ = _error_;
		_tmp6_ = _g_error_copy0 (_tmp5_);
		_inner_error_ = _tmp6_;
		_g_error_free0 (_error_);
		goto __finally6;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Add the item to the cache.
     */
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, gboolean override_guarded, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaItem* _tmp1_;
		RygelMediaItem* _tmp2_;
		gboolean _tmp3_;
		RygelMediaExportDatabase* _tmp4_;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp1_ = item;
		rygel_media_export_media_cache_save_item_metadata (self, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
		_tmp2_ = item;
		_tmp3_ = override_guarded;
		rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) _tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			goto __finally7;
		}
		_tmp4_ = self->priv->db;
		rygel_media_export_database_commit (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch7_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		RygelMediaItem* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		RygelMediaExportDatabase* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _ ("Failed to add item with ID %s: %s");
		_tmp6_ = item;
		_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _error_;
		_tmp10_ = _tmp9_->message;
		g_warning (_tmp5_, _tmp8_, _tmp10_);
		_tmp11_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp11_);
		_tmp12_ = _error_;
		_tmp13_ = _g_error_copy0 (_tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (_error_);
		goto __finally7;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/**
     * Create a new container or item instance based on the ID.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     */
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* parent;
	GValue* _tmp3_;
	gint _tmp3__length1;
	RygelMediaExportDatabaseCursor* _tmp4_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	_tmp0_ = object_id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	parent = NULL;
	_tmp3_ = values;
	_tmp3__length1 = values_length1;
	_tmp4_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT, _tmp3_, _tmp3__length1, &_inner_error_);
	cursor = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return NULL;
		} else {
			_g_object_unref0 (parent);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp5_;
		RygelMediaExportDatabaseCursorIterator* _tmp6_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp5_ = cursor;
		_tmp6_ = rygel_media_export_database_cursor_iterator (_tmp5_);
		_statement_it = _tmp6_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_;
			RygelMediaExportDatabaseCursorIterator* _tmp10_;
			sqlite3_stmt* _tmp11_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObject* _tmp12_;
			RygelMediaContainer* _tmp13_;
			RygelMediaContainer* parent_container;
			RygelMediaContainer* _tmp14_;
			sqlite3_stmt* _tmp15_;
			RygelMediaObject* _tmp16_ = NULL;
			RygelMediaObject* object;
			RygelMediaObject* _tmp17_;
			RygelMediaContainer* _tmp18_;
			RygelMediaObject* _tmp19_;
			RygelMediaObject* _tmp20_;
			_tmp7_ = _statement_it;
			_tmp8_ = rygel_media_export_database_cursor_iterator_next (_tmp7_, &_inner_error_);
			_tmp9_ = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _statement_it;
			_tmp11_ = rygel_media_export_database_cursor_iterator_get (_tmp10_, &_inner_error_);
			statement = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					_g_object_unref0 (parent);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp12_ = parent;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp12_) : NULL);
			parent_container = _tmp13_;
			_tmp14_ = parent_container;
			_tmp15_ = statement;
			_tmp16_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp14_, _tmp15_);
			object = _tmp16_;
			_tmp17_ = object;
			_tmp18_ = parent_container;
			rygel_media_object_set_parent_ref (_tmp17_, _tmp18_);
			_tmp19_ = object;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (parent);
			parent = _tmp20_;
			_g_object_unref0 (object);
			_g_object_unref0 (parent_container);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = parent;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_ = NULL;
	RygelMediaObject* object;
	gboolean _tmp2_ = FALSE;
	RygelMediaObject* _tmp3_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp8_;
	RygelMediaContainer* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = container_id;
	_tmp1_ = rygel_media_export_media_cache_get_object (self, _tmp0_, &_inner_error_);
	object = _tmp1_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = object;
	if (_tmp3_ != NULL) {
		RygelMediaObject* _tmp4_;
		_tmp4_ = object;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_CONTAINER);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		GError* _tmp7_;
		_tmp6_ = container_id;
		_tmp7_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", _tmp6_);
		_inner_error_ = _tmp7_;
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = object;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp8_) : NULL);
	result = _tmp9_;
	_g_object_unref0 (object);
	return result;
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	_tmp0_ = container_id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT, values, values_length1, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp4_;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


guint32 rygel_media_export_media_cache_get_update_id (RygelMediaExportMediaCache* self) {
	guint32 result = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	{
		gint _tmp0_ = 0;
		gint _tmp1_;
		_tmp0_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_MAX_UPDATE_ID, NULL, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		result = (guint32) _tmp1_;
		return result;
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	result = (guint32) 0;
	return result;
}


void rygel_media_export_media_cache_get_track_properties (RygelMediaExportMediaCache* self, const gchar* id, guint32* object_update_id, guint32* container_update_id, guint32* total_deleted_child_count) {
	guint32 _vala_object_update_id = 0U;
	guint32 _vala_container_update_id = 0U;
	guint32 _vala_total_deleted_child_count = 0U;
	const gchar* _tmp0_;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = id;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, _tmp0_);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_vala_object_update_id = (guint32) 0;
	_vala_container_update_id = (guint32) 0;
	_vala_total_deleted_child_count = (guint32) 0;
	{
		RygelMediaExportDatabase* _tmp3_;
		GValue* _tmp4_;
		gint _tmp4__length1;
		RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
		RygelMediaExportDatabaseCursor* cursor;
		RygelMediaExportDatabaseCursor* _tmp6_;
		sqlite3_stmt* _tmp7_ = NULL;
		sqlite3_stmt* statement;
		sqlite3_stmt* _tmp8_;
		gint64 _tmp9_ = 0LL;
		sqlite3_stmt* _tmp10_;
		gint64 _tmp11_ = 0LL;
		sqlite3_stmt* _tmp12_;
		gint64 _tmp13_ = 0LL;
		_tmp3_ = self->priv->db;
		_tmp4_ = values;
		_tmp4__length1 = values_length1;
		_tmp5_ = rygel_media_export_database_exec_cursor (_tmp3_, "SELECT object_update_id, " "container_update_id, " "deleted_child_count " "FROM Object WHERE upnp_id = ?", _tmp4_, _tmp4__length1, &_inner_error_);
		cursor = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp6_ = cursor;
		_tmp7_ = rygel_media_export_database_cursor_next (_tmp6_, &_inner_error_);
		statement = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cursor);
			goto __catch9_g_error;
		}
		_tmp8_ = statement;
		_tmp9_ = sqlite3_column_int64 (_tmp8_, 0);
		_vala_object_update_id = (guint32) _tmp9_;
		_tmp10_ = statement;
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 1);
		_vala_container_update_id = (guint32) _tmp11_;
		_tmp12_ = statement;
		_tmp13_ = sqlite3_column_int64 (_tmp12_, 2);
		_vala_total_deleted_child_count = (guint32) _tmp13_;
		_g_object_unref0 (cursor);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		if (object_update_id) {
			*object_update_id = _vala_object_update_id;
		}
		if (container_update_id) {
			*container_update_id = _vala_container_update_id;
		}
		if (total_deleted_child_count) {
			*total_deleted_child_count = _vala_total_deleted_child_count;
		}
		return;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = _error_;
		_tmp15_ = _tmp14_->message;
		g_warning ("rygel-media-export-media-cache.vala:214: Failed to get update ids: %s", _tmp15_);
		_g_error_free0 (_error_);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	if (object_update_id) {
		*object_update_id = _vala_object_update_id;
	}
	if (container_update_id) {
		*container_update_id = _vala_container_update_id;
	}
	if (total_deleted_child_count) {
		*total_deleted_child_count = _vala_total_deleted_child_count;
	}
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _vala_timestamp = 0LL;
	gint64 _vala_size = 0LL;
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	const gchar* _tmp2_;
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GValue* _tmp17_;
	gint _tmp17__length1;
	RygelMediaExportDatabaseCursor* _tmp18_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	RygelMediaExportDatabaseCursor* _tmp19_;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp21_;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_;
	gint64 _tmp24_;
	sqlite3_stmt* _tmp25_;
	gint64 _tmp26_ = 0LL;
	sqlite3_stmt* _tmp27_;
	gint _tmp28_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_set_string (&_tmp3_, _tmp2_);
	_tmp4_ = g_new0 (GValue, 1);
	_tmp4_[0] = _tmp3_;
	values = _tmp4_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp5_ = self->priv->exists_cache;
	_tmp6_ = uri;
	_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, _tmp6_);
	if (_tmp7_) {
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		gpointer _tmp10_ = NULL;
		RygelMediaExportExistsCacheEntry* entry;
		GeeHashMap* _tmp11_;
		const gchar* _tmp12_;
		RygelMediaExportExistsCacheEntry* _tmp13_;
		gint64 _tmp14_;
		RygelMediaExportExistsCacheEntry* _tmp15_;
		gint64 _tmp16_;
		_tmp8_ = self->priv->exists_cache;
		_tmp9_ = uri;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _tmp9_);
		entry = (RygelMediaExportExistsCacheEntry*) _tmp10_;
		_tmp11_ = self->priv->exists_cache;
		_tmp12_ = uri;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
		_tmp13_ = entry;
		_tmp14_ = (*_tmp13_).mtime;
		_vala_timestamp = _tmp14_;
		_tmp15_ = entry;
		_tmp16_ = (*_tmp15_).size;
		_vala_size = _tmp16_;
		result = TRUE;
		_rygel_media_export_exists_cache_entry_free0 (entry);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (uri);
		if (timestamp) {
			*timestamp = _vala_timestamp;
		}
		if (size) {
			*size = _vala_size;
		}
		return result;
	}
	_tmp17_ = values;
	_tmp17__length1 = values_length1;
	_tmp18_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS, _tmp17_, _tmp17__length1, &_inner_error_);
	cursor = _tmp18_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp19_ = cursor;
	_tmp20_ = rygel_media_export_database_cursor_next (_tmp19_, &_inner_error_);
	statement = _tmp20_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			return FALSE;
		} else {
			_g_object_unref0 (cursor);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp21_ = statement;
	_tmp22_ = sqlite3_column_int64 (_tmp21_, 1);
	_vala_timestamp = _tmp22_;
	_tmp23_ = _vala_timestamp;
	_tmp24_ = G_MAXINT64;
	if (_tmp23_ == _tmp24_) {
		_vala_timestamp = (gint64) 0;
	}
	_tmp25_ = statement;
	_tmp26_ = sqlite3_column_int64 (_tmp25_, 2);
	_vala_size = _tmp26_;
	_tmp27_ = statement;
	_tmp28_ = sqlite3_column_int (_tmp27_, 0);
	result = _tmp28_ == 1;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (uri);
	if (timestamp) {
		*timestamp = _vala_timestamp;
	}
	if (size) {
		*size = _vala_size;
	}
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GValue _tmp4_ = {0};
	glong _tmp5_;
	GValue _tmp6_ = {0};
	glong _tmp7_;
	GValue _tmp8_ = {0};
	GValue* _tmp9_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportSQLFactory* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* sql;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* sort_order;
	RygelMediaExportDatabase* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	GValue* _tmp20_;
	gint _tmp20__length1;
	RygelMediaExportDatabaseCursor* _tmp21_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp22_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_value_init (&_tmp4_, G_TYPE_STRING);
	g_value_set_string (&_tmp4_, _tmp3_);
	_tmp5_ = offset;
	g_value_init (&_tmp6_, G_TYPE_LONG);
	g_value_set_long (&_tmp6_, _tmp5_);
	_tmp7_ = max_count;
	g_value_init (&_tmp8_, G_TYPE_LONG);
	g_value_set_long (&_tmp8_, _tmp7_);
	_tmp9_ = g_new0 (GValue, 3);
	_tmp9_[0] = _tmp4_;
	_tmp9_[1] = _tmp6_;
	_tmp9_[2] = _tmp8_;
	values = _tmp9_;
	values_length1 = 3;
	_values_size_ = values_length1;
	_tmp10_ = self->priv->sql;
	_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
	_tmp12_ = g_strdup (_tmp11_);
	sql = _tmp12_;
	_tmp13_ = sort_criteria;
	_tmp14_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp13_, NULL, NULL);
	sort_order = _tmp14_;
	_tmp15_ = self->priv->db;
	_tmp16_ = sql;
	_tmp17_ = sort_order;
	_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = values;
	_tmp20__length1 = values_length1;
	_tmp21_ = rygel_media_export_database_exec_cursor (_tmp15_, _tmp19_, _tmp20_, _tmp20__length1, &_inner_error_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp19_);
	cursor = _tmp22_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_free0 (sql);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursor* _tmp23_;
		RygelMediaExportDatabaseCursorIterator* _tmp24_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp23_ = cursor;
		_tmp24_ = rygel_media_export_database_cursor_iterator (_tmp23_);
		_statement_it = _tmp24_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_;
			RygelMediaExportDatabaseCursorIterator* _tmp28_;
			sqlite3_stmt* _tmp29_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaObjects* _tmp30_;
			RygelMediaContainer* _tmp31_;
			sqlite3_stmt* _tmp32_;
			RygelMediaObject* _tmp33_ = NULL;
			RygelMediaObject* _tmp34_;
			RygelMediaObjects* _tmp35_;
			gpointer _tmp36_ = NULL;
			RygelMediaObject* _tmp37_;
			RygelMediaContainer* _tmp38_;
			_tmp25_ = _statement_it;
			_tmp26_ = rygel_media_export_database_cursor_iterator_next (_tmp25_, &_inner_error_);
			_tmp27_ = _tmp26_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _statement_it;
			_tmp29_ = rygel_media_export_database_cursor_iterator_get (_tmp28_, &_inner_error_);
			statement = _tmp29_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_free0 (sql);
				values = (_vala_GValue_array_free (values, values_length1), NULL);
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp30_ = children;
			_tmp31_ = container;
			_tmp32_ = statement;
			_tmp33_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp31_, _tmp32_);
			_tmp34_ = _tmp33_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp34_);
			_g_object_unref0 (_tmp34_);
			_tmp35_ = children;
			_tmp36_ = gee_list_last ((GeeList*) _tmp35_);
			_tmp37_ = (RygelMediaObject*) _tmp36_;
			_tmp38_ = container;
			rygel_media_object_set_parent_ref (_tmp37_, _tmp38_);
			_g_object_unref0 (_tmp37_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_free0 (sql);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, const gchar* sort_criteria, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _vala_total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	guint _tmp9_;
	guint _tmp10_ = 0U;
	guint max_objects;
	const gchar* _tmp11_;
	GValueArray* _tmp12_;
	const gchar* _tmp13_;
	glong _tmp14_ = 0L;
	glong _tmp15_;
	const gchar* _tmp16_;
	GValueArray* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	RygelMediaObjects* _tmp22_ = NULL;
	RygelMediaObjects* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp4_ = expression;
	if (_tmp4_ != NULL) {
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = expression;
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		g_debug ("rygel-media-export-media-cache.vala:283: Original search: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:284: Parsed search expression: %s", _tmp8_);
	}
	_tmp9_ = max_count;
	_tmp10_ = rygel_media_export_media_cache_modify_limit (self, _tmp9_);
	max_objects = _tmp10_;
	_tmp11_ = filter;
	_tmp12_ = args;
	_tmp13_ = container_id;
	_tmp14_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp11_, _tmp12_, _tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_vala_total_matches = (guint) _tmp15_;
	_tmp16_ = filter;
	_tmp17_ = args;
	_tmp18_ = container_id;
	_tmp19_ = sort_criteria;
	_tmp20_ = offset;
	_tmp21_ = max_objects;
	_tmp22_ = rygel_media_export_media_cache_get_objects_by_filter (self, _tmp16_, _tmp17_, _tmp18_, _tmp19_, (glong) _tmp20_, (glong) _tmp21_, &_inner_error_);
	_tmp23_ = _tmp22_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp23_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	if (total_matches) {
		*total_matches = _vala_total_matches;
	}
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	RygelSearchExpression* _tmp4_;
	const gchar* _tmp29_;
	GValueArray* _tmp30_;
	const gchar* _tmp31_;
	glong _tmp32_ = 0L;
	glong _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "WHERE", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return 0L;
	}
	_tmp4_ = expression;
	if (_tmp4_ != NULL) {
		RygelSearchExpression* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = expression;
		_tmp6_ = rygel_search_expression_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		g_debug ("rygel-media-export-media-cache.vala:308: Original search: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = filter;
		g_debug ("rygel-media-export-media-cache.vala:309: Parsed search expression: %s", _tmp8_);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				GValueArray* _tmp13_;
				guint _tmp14_;
				GValueArray* _tmp15_;
				gint _tmp16_;
				GValue* _tmp17_ = NULL;
				GValue* _tmp18_;
				GValue* arg;
				gchar* _tmp19_ = NULL;
				GValue* _tmp20_;
				gboolean _tmp21_ = FALSE;
				gint _tmp27_;
				const gchar* _tmp28_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = args;
				_tmp14_ = _tmp13_->n_values;
				if (!(((guint) _tmp12_) < _tmp14_)) {
					break;
				}
				_tmp15_ = args;
				_tmp16_ = i;
				_tmp17_ = g_value_array_get_nth (_tmp15_, (guint) _tmp16_);
				_tmp18_ = __g_value_dup0 (_tmp17_);
				arg = _tmp18_;
				_tmp20_ = arg;
				_tmp21_ = G_VALUE_HOLDS (_tmp20_, G_TYPE_STRING);
				if (_tmp21_) {
					GValue* _tmp22_;
					const gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					_tmp22_ = arg;
					_tmp23_ = g_value_get_string (_tmp22_);
					_tmp24_ = g_strdup (_tmp23_);
					_g_free0 (_tmp19_);
					_tmp19_ = _tmp24_;
				} else {
					GValue* _tmp25_;
					gchar* _tmp26_ = NULL;
					_tmp25_ = arg;
					_tmp26_ = g_strdup_value_contents (_tmp25_);
					_g_free0 (_tmp19_);
					_tmp19_ = _tmp26_;
				}
				_tmp27_ = i;
				_tmp28_ = _tmp19_;
				g_debug ("rygel-media-export-media-cache.vala:314: Arg %d: %s", _tmp27_, _tmp28_);
				_g_free0 (_tmp19_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp29_ = filter;
	_tmp30_ = args;
	_tmp31_ = container_id;
	_tmp32_ = rygel_media_export_media_cache_get_object_count_by_filter (self, _tmp29_, _tmp30_, _tmp31_, &_inner_error_);
	_tmp33_ = _tmp32_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return 0L;
	}
	result = _tmp33_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	const gchar* _tmp0_;
	GValueArray* _tmp5_;
	guint _tmp6_;
	const gchar* pattern = NULL;
	RygelMediaExportSQLString string_id = 0;
	const gchar* _tmp7_;
	RygelMediaExportSQLFactory* _tmp8_;
	RygelMediaExportSQLString _tmp9_;
	const gchar* _tmp10_ = NULL;
	RygelMediaExportDatabase* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	GValueArray* _tmp15_;
	GValue* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_ = 0;
	gint _tmp18_;
	gint _tmp19_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (filter != NULL, 0L);
	g_return_val_if_fail (args != NULL, 0L);
	_tmp0_ = container_id;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		GValue _tmp2_ = {0};
		GValue v;
		GValueArray* _tmp3_;
		GValue _tmp4_;
		_tmp1_ = container_id;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		g_value_set_string (&_tmp2_, _tmp1_);
		v = _tmp2_;
		_tmp3_ = args;
		_tmp4_ = v;
		g_value_array_prepend (_tmp3_, &_tmp4_);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp5_ = args;
	_tmp6_ = _tmp5_->n_values;
	g_debug ("rygel-media-export-media-cache.vala:334: Parameters to bind: %u", _tmp6_);
	_tmp7_ = container_id;
	if (_tmp7_ != NULL) {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER_WITH_ANCESTOR;
	} else {
		string_id = RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER;
	}
	_tmp8_ = self->priv->sql;
	_tmp9_ = string_id;
	_tmp10_ = rygel_media_export_sql_factory_make (_tmp8_, _tmp9_);
	pattern = _tmp10_;
	_tmp11_ = self->priv->db;
	_tmp12_ = filter;
	_tmp13_ = g_strdup_printf (pattern, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = args;
	_tmp16_ = _tmp15_->values;
	_tmp16__length1 = (gint) _tmp15_->n_values;
	_tmp17_ = rygel_media_export_database_query_value (_tmp11_, _tmp14_, _tmp16_, _tmp16__length1, &_inner_error_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp14_);
	_tmp19_ = _tmp18_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0L;
	}
	result = (glong) _tmp19_;
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, const gchar* sort_criteria, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	RygelMediaObjects* _tmp0_;
	RygelMediaObjects* children;
	glong _tmp1_;
	GValue _tmp2_ = {0};
	GValue v;
	GValueArray* _tmp3_;
	GValue _tmp4_;
	glong _tmp5_;
	GValue _tmp6_ = {0};
	GValueArray* _tmp7_;
	GValue _tmp8_;
	RygelMediaContainer* parent;
	GValueArray* _tmp9_;
	guint _tmp10_;
	const gchar* sql = NULL;
	const gchar* _tmp31_;
	const gchar* _tmp36_;
	gchar* _tmp37_ = NULL;
	gchar* sort_order;
	RygelMediaExportDatabase* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	GValueArray* _tmp44_;
	GValue* _tmp45_;
	gint _tmp45__length1;
	RygelMediaExportDatabaseCursor* _tmp46_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp47_;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = rygel_media_objects_new ();
	children = _tmp0_;
	_tmp1_ = offset;
	g_value_init (&_tmp2_, G_TYPE_LONG);
	g_value_set_long (&_tmp2_, _tmp1_);
	v = _tmp2_;
	_tmp3_ = args;
	_tmp4_ = v;
	g_value_array_append (_tmp3_, &_tmp4_);
	_tmp5_ = max_count;
	g_value_init (&_tmp6_, G_TYPE_LONG);
	g_value_set_long (&_tmp6_, _tmp5_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp6_;
	_tmp7_ = args;
	_tmp8_ = v;
	g_value_array_append (_tmp7_, &_tmp8_);
	parent = NULL;
	_tmp9_ = args;
	_tmp10_ = _tmp9_->n_values;
	g_debug ("rygel-media-export-media-cache.vala:361: Parameters to bind: %u", _tmp10_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				GValueArray* _tmp15_;
				guint _tmp16_;
				GValueArray* _tmp17_;
				gint _tmp18_;
				GValue* _tmp19_ = NULL;
				GValue* _tmp20_;
				GValue* arg;
				gchar* _tmp21_ = NULL;
				GValue* _tmp22_;
				gboolean _tmp23_ = FALSE;
				gint _tmp29_;
				const gchar* _tmp30_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = args;
				_tmp16_ = _tmp15_->n_values;
				if (!(((guint) _tmp14_) < _tmp16_)) {
					break;
				}
				_tmp17_ = args;
				_tmp18_ = i;
				_tmp19_ = g_value_array_get_nth (_tmp17_, (guint) _tmp18_);
				_tmp20_ = __g_value_dup0 (_tmp19_);
				arg = _tmp20_;
				_tmp22_ = arg;
				_tmp23_ = G_VALUE_HOLDS (_tmp22_, G_TYPE_STRING);
				if (_tmp23_) {
					GValue* _tmp24_;
					const gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					_tmp24_ = arg;
					_tmp25_ = g_value_get_string (_tmp24_);
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (_tmp21_);
					_tmp21_ = _tmp26_;
				} else {
					GValue* _tmp27_;
					gchar* _tmp28_ = NULL;
					_tmp27_ = arg;
					_tmp28_ = g_strdup_value_contents (_tmp27_);
					_g_free0 (_tmp21_);
					_tmp21_ = _tmp28_;
				}
				_tmp29_ = i;
				_tmp30_ = _tmp21_;
				g_debug ("rygel-media-export-media-cache.vala:364: Arg %d: %s", _tmp29_, _tmp30_);
				_g_free0 (_tmp21_);
				__vala_GValue_free0 (arg);
			}
		}
	}
	_tmp31_ = container_id;
	if (_tmp31_ != NULL) {
		RygelMediaExportSQLFactory* _tmp32_;
		const gchar* _tmp33_ = NULL;
		_tmp32_ = self->priv->sql;
		_tmp33_ = rygel_media_export_sql_factory_make (_tmp32_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER_WITH_ANCESTOR);
		sql = _tmp33_;
	} else {
		RygelMediaExportSQLFactory* _tmp34_;
		const gchar* _tmp35_ = NULL;
		_tmp34_ = self->priv->sql;
		_tmp35_ = rygel_media_export_sql_factory_make (_tmp34_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
		sql = _tmp35_;
	}
	_tmp36_ = sort_criteria;
	_tmp37_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp36_, NULL, NULL);
	sort_order = _tmp37_;
	_tmp38_ = self->priv->db;
	_tmp39_ = sql;
	_tmp40_ = filter;
	_tmp41_ = sort_order;
	_tmp42_ = g_strdup_printf (_tmp39_, _tmp40_, _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = args;
	_tmp45_ = _tmp44_->values;
	_tmp45__length1 = (gint) _tmp44_->n_values;
	_tmp46_ = rygel_media_export_database_exec_cursor (_tmp38_, _tmp43_, _tmp45_, _tmp45__length1, &_inner_error_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp43_);
	cursor = _tmp47_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sort_order);
		_g_object_unref0 (parent);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		_g_object_unref0 (children);
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursor* _tmp48_;
		RygelMediaExportDatabaseCursorIterator* _tmp49_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp48_ = cursor;
		_tmp49_ = rygel_media_export_database_cursor_iterator (_tmp48_);
		_statement_it = _tmp49_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp50_;
			gboolean _tmp51_ = FALSE;
			gboolean _tmp52_;
			RygelMediaExportDatabaseCursorIterator* _tmp53_;
			sqlite3_stmt* _tmp54_ = NULL;
			sqlite3_stmt* statement;
			sqlite3_stmt* _tmp55_;
			const gchar* _tmp56_ = NULL;
			const gchar* parent_id;
			gboolean _tmp57_ = FALSE;
			RygelMediaContainer* _tmp58_;
			gboolean _tmp63_;
			RygelMediaContainer* _tmp68_;
			_tmp50_ = _statement_it;
			_tmp51_ = rygel_media_export_database_cursor_iterator_next (_tmp50_, &_inner_error_);
			_tmp52_ = _tmp51_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = _statement_it;
			_tmp54_ = rygel_media_export_database_cursor_iterator_get (_tmp53_, &_inner_error_);
			statement = _tmp54_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sort_order);
				_g_object_unref0 (parent);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				_g_object_unref0 (children);
				return NULL;
			}
			_tmp55_ = statement;
			_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
			parent_id = _tmp56_;
			_tmp58_ = parent;
			if (_tmp58_ == NULL) {
				_tmp57_ = TRUE;
			} else {
				const gchar* _tmp59_;
				RygelMediaContainer* _tmp60_;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				_tmp59_ = parent_id;
				_tmp60_ = parent;
				_tmp61_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp57_ = g_strcmp0 (_tmp59_, _tmp62_) != 0;
			}
			_tmp63_ = _tmp57_;
			if (_tmp63_) {
				const gchar* _tmp64_;
				_tmp64_ = parent_id;
				if (_tmp64_ == NULL) {
					RygelNullContainer* _tmp65_;
					_tmp65_ = rygel_null_container_new_root ();
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp65_;
				} else {
					const gchar* _tmp66_;
					RygelNullContainer* _tmp67_;
					_tmp66_ = parent_id;
					_tmp67_ = rygel_null_container_new (_tmp66_, NULL, "MediaExport");
					_g_object_unref0 (parent);
					parent = (RygelMediaContainer*) _tmp67_;
				}
			}
			_tmp68_ = parent;
			if (_tmp68_ != NULL) {
				RygelMediaObjects* _tmp69_;
				RygelMediaContainer* _tmp70_;
				sqlite3_stmt* _tmp71_;
				RygelMediaObject* _tmp72_ = NULL;
				RygelMediaObject* _tmp73_;
				RygelMediaObjects* _tmp74_;
				gpointer _tmp75_ = NULL;
				RygelMediaObject* _tmp76_;
				RygelMediaContainer* _tmp77_;
				_tmp69_ = children;
				_tmp70_ = parent;
				_tmp71_ = statement;
				_tmp72_ = rygel_media_export_media_cache_get_object_from_statement (self, _tmp70_, _tmp71_);
				_tmp73_ = _tmp72_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, _tmp73_);
				_g_object_unref0 (_tmp73_);
				_tmp74_ = children;
				_tmp75_ = gee_list_last ((GeeList*) _tmp74_);
				_tmp76_ = (RygelMediaObject*) _tmp75_;
				_tmp77_ = parent;
				rygel_media_object_set_parent_ref (_tmp76_, _tmp77_);
				_g_object_unref0 (_tmp76_);
			} else {
				sqlite3_stmt* _tmp78_;
				const gchar* _tmp79_ = NULL;
				const gchar* _tmp80_;
				_tmp78_ = statement;
				_tmp79_ = sqlite3_column_text (_tmp78_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
				_tmp80_ = parent_id;
				g_warning ("Inconsistent database: item %s " "has no parent %s", _tmp79_, _tmp80_);
			}
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	_g_free0 (sort_order);
	_g_object_unref0 (parent);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		RygelMediaExportDatabaseCursor* cursor;
		g_debug ("rygel-media-export-media-cache.vala:407: Database statistics:");
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_STATISTICS, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		{
			RygelMediaExportDatabaseCursor* _tmp1_;
			RygelMediaExportDatabaseCursorIterator* _tmp2_ = NULL;
			RygelMediaExportDatabaseCursorIterator* _statement_it;
			_tmp1_ = cursor;
			_tmp2_ = rygel_media_export_database_cursor_iterator (_tmp1_);
			_statement_it = _tmp2_;
			while (TRUE) {
				RygelMediaExportDatabaseCursorIterator* _tmp3_;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_;
				RygelMediaExportDatabaseCursorIterator* _tmp6_;
				sqlite3_stmt* _tmp7_ = NULL;
				sqlite3_stmt* statement;
				sqlite3_stmt* _tmp8_;
				const gchar* _tmp9_ = NULL;
				sqlite3_stmt* _tmp10_;
				gint _tmp11_ = 0;
				_tmp3_ = _statement_it;
				_tmp4_ = rygel_media_export_database_cursor_iterator_next (_tmp3_, &_inner_error_);
				_tmp5_ = _tmp4_;
				if (_inner_error_ != NULL) {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch10_g_error;
				}
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = _statement_it;
				_tmp7_ = rygel_media_export_database_cursor_iterator_get (_tmp6_, &_inner_error_);
				statement = _tmp7_;
				if (_inner_error_ != NULL) {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					goto __catch10_g_error;
				}
				_tmp8_ = statement;
				_tmp9_ = sqlite3_column_text (_tmp8_, 0);
				_tmp10_ = statement;
				_tmp11_ = sqlite3_column_int (_tmp10_, 1);
				g_debug ("rygel-media-export-media-cache.vala:410: %s: %d", _tmp9_, _tmp11_);
			}
			_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
		}
		_g_object_unref0 (cursor);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* children;
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	GValue* _tmp4_;
	gint _tmp4__length1;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	children = _tmp0_;
	_tmp1_ = container_id;
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue, 1);
	_tmp3_[0] = _tmp2_;
	values = _tmp3_;
	values_length1 = 1;
	_values_size_ = values_length1;
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS, _tmp4_, _tmp4__length1, &_inner_error_);
	cursor = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_object_unref0 (children);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp6_;
		RygelMediaExportDatabaseCursorIterator* _tmp7_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp6_ = cursor;
		_tmp7_ = rygel_media_export_database_cursor_iterator (_tmp6_);
		_statement_it = _tmp7_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			RygelMediaExportDatabaseCursorIterator* _tmp11_;
			sqlite3_stmt* _tmp12_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
			_tmp8_ = _statement_it;
			_tmp9_ = rygel_media_export_database_cursor_iterator_next (_tmp8_, &_inner_error_);
			_tmp10_ = _tmp9_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _statement_it;
			_tmp12_ = rygel_media_export_database_cursor_iterator_get (_tmp11_, &_inner_error_);
			statement = _tmp12_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					return NULL;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					values = (_vala_GValue_array_free (values, values_length1), NULL);
					_g_object_unref0 (children);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp13_ = children;
			_tmp14_ = statement;
			_tmp15_ = sqlite3_column_text (_tmp14_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = children;
	_g_object_unref0 (cursor);
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch11_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, const gchar* sort_criteria, glong max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	glong _tmp0_;
	GValue _tmp1_ = {0};
	GValue v;
	GValueArray* _tmp2_;
	GValue _tmp3_;
	glong _tmp4_;
	GValue _tmp5_ = {0};
	GValueArray* _tmp6_;
	GValue _tmp7_;
	gchar* extra_columns = NULL;
	gint column_count = 0;
	GString* _tmp8_;
	GString* builder;
	GeeArrayList* _tmp9_;
	GeeArrayList* data;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* sql_sort_order;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_;
	GString* _tmp27_;
	RygelMediaExportSQLFactory* _tmp28_;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	RygelMediaExportDatabase* _tmp34_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	GValueArray* _tmp37_;
	GValue* _tmp38_;
	gint _tmp38__length1;
	RygelMediaExportDatabaseCursor* _tmp39_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = offset;
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, _tmp0_);
	v = _tmp1_;
	_tmp2_ = args;
	_tmp3_ = v;
	g_value_array_append (_tmp2_, &_tmp3_);
	_tmp4_ = max_count;
	g_value_init (&_tmp5_, G_TYPE_LONG);
	g_value_set_long (&_tmp5_, _tmp4_);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp5_;
	_tmp6_ = args;
	_tmp7_ = v;
	g_value_array_append (_tmp6_, &_tmp7_);
	_tmp8_ = g_string_new ("");
	builder = _tmp8_;
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	data = _tmp9_;
	_tmp10_ = sort_criteria;
	_tmp13_ = rygel_media_export_media_cache_translate_sort_criteria (_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (extra_columns);
	extra_columns = _tmp11_;
	column_count = _tmp12_;
	sql_sort_order = _tmp13_;
	_tmp14_ = sql_sort_order;
	_tmp15_ = string_replace (_tmp14_, "o.title", "_column");
	_g_free0 (sql_sort_order);
	sql_sort_order = _tmp15_;
	_tmp16_ = extra_columns;
	_tmp17_ = string_replace (_tmp16_, "o.title", "1");
	_g_free0 (extra_columns);
	extra_columns = _tmp17_;
	_tmp18_ = add_all_container;
	if (_tmp18_) {
		GString* _tmp19_;
		GString* _tmp26_;
		_tmp19_ = builder;
		g_string_append (_tmp19_, "SELECT 'all_place_holder' AS _column ");
		{
			gint i;
			i = 0;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					gboolean _tmp21_;
					gint _tmp23_;
					gint _tmp24_;
					GString* _tmp25_;
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						gint _tmp22_;
						_tmp22_ = i;
						i = _tmp22_ + 1;
					}
					_tmp20_ = FALSE;
					_tmp23_ = i;
					_tmp24_ = column_count;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = builder;
					g_string_append (_tmp25_, ", 1 ");
				}
			}
		}
		_tmp26_ = builder;
		g_string_append (_tmp26_, "UNION ");
	}
	_tmp27_ = builder;
	_tmp28_ = self->priv->sql;
	_tmp29_ = rygel_media_export_sql_factory_make (_tmp28_, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
	_tmp30_ = column;
	_tmp31_ = extra_columns;
	_tmp32_ = filter;
	_tmp33_ = sql_sort_order;
	g_string_append_printf (_tmp27_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
	_tmp34_ = self->priv->db;
	_tmp35_ = builder;
	_tmp36_ = _tmp35_->str;
	_tmp37_ = args;
	_tmp38_ = _tmp37_->values;
	_tmp38__length1 = (gint) _tmp37_->n_values;
	_tmp39_ = rygel_media_export_database_exec_cursor (_tmp34_, _tmp36_, _tmp38_, _tmp38__length1, &_inner_error_);
	cursor = _tmp39_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql_sort_order);
		_g_object_unref0 (data);
		_g_string_free0 (builder);
		_g_free0 (extra_columns);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return NULL;
	}
	{
		RygelMediaExportDatabaseCursor* _tmp40_;
		RygelMediaExportDatabaseCursorIterator* _tmp41_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp40_ = cursor;
		_tmp41_ = rygel_media_export_database_cursor_iterator (_tmp40_);
		_statement_it = _tmp41_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp42_;
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_;
			RygelMediaExportDatabaseCursorIterator* _tmp45_;
			sqlite3_stmt* _tmp46_ = NULL;
			sqlite3_stmt* statement;
			GeeArrayList* _tmp47_;
			sqlite3_stmt* _tmp48_;
			const gchar* _tmp49_ = NULL;
			_tmp42_ = _statement_it;
			_tmp43_ = rygel_media_export_database_cursor_iterator_next (_tmp42_, &_inner_error_);
			_tmp44_ = _tmp43_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			if (!_tmp44_) {
				break;
			}
			_tmp45_ = _statement_it;
			_tmp46_ = rygel_media_export_database_cursor_iterator_get (_tmp45_, &_inner_error_);
			statement = _tmp46_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
				_g_object_unref0 (cursor);
				_g_free0 (sql_sort_order);
				_g_object_unref0 (data);
				_g_string_free0 (builder);
				_g_free0 (extra_columns);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return NULL;
			}
			_tmp47_ = data;
			_tmp48_ = statement;
			_tmp49_ = sqlite3_column_text (_tmp48_, 0);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp49_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	result = (GeeList*) data;
	_g_object_unref0 (cursor);
	_g_free0 (sql_sort_order);
	_g_string_free0 (builder);
	_g_free0 (extra_columns);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


/**
     * TODO
     */
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, const gchar* sort_criteria, glong offset, guint max_count, gboolean add_all_container, GError** error) {
	GeeList* result = NULL;
	GValueArray* _tmp0_;
	GValueArray* args;
	RygelSearchExpression* _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filter;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* column;
	guint _tmp7_;
	guint _tmp8_ = 0U;
	guint max_objects;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GValueArray* _tmp11_;
	glong _tmp12_;
	const gchar* _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_;
	GeeList* _tmp16_ = NULL;
	GeeList* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_translate_search_expression (_tmp1_, _tmp2_, "AND", &_inner_error_);
	filter = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp4_ = filter;
	g_debug ("rygel-media-export-media-cache.vala:498: Parsed filter: %s", _tmp4_);
	_tmp5_ = attribute;
	_tmp6_ = rygel_media_export_media_cache_map_operand_to_column (_tmp5_, NULL, FALSE, &_inner_error_);
	column = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp7_ = max_count;
	_tmp8_ = rygel_media_export_media_cache_modify_limit (self, _tmp7_);
	max_objects = _tmp8_;
	_tmp9_ = column;
	_tmp10_ = filter;
	_tmp11_ = args;
	_tmp12_ = offset;
	_tmp13_ = sort_criteria;
	_tmp14_ = max_objects;
	_tmp15_ = add_all_container;
	_tmp16_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, (glong) _tmp14_, _tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp17_;
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* id;
	gint id_length1;
	gint _id_size_;
	guchar* _tmp1_ = NULL;
	guchar* unparsed;
	gint unparsed_length1;
	gint _unparsed_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar _tmp6_;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	_tmp0_ = g_new0 (guchar, 16);
	id = _tmp0_;
	id_length1 = 16;
	_id_size_ = id_length1;
	_tmp1_ = g_new0 (guchar, 51);
	unparsed = _tmp1_;
	unparsed_length1 = 51;
	_unparsed_size_ = unparsed_length1;
	_tmp2_ = id;
	_tmp2__length1 = id_length1;
	uuid_generate (_tmp2_);
	_tmp3_ = id;
	_tmp3__length1 = id_length1;
	_tmp4_ = unparsed;
	_tmp4__length1 = unparsed_length1;
	uuid_unparse (_tmp3_, _tmp4_);
	_tmp5_ = unparsed;
	_tmp5__length1 = unparsed_length1;
	_tmp5_[50] = (guchar) '\0';
	_tmp6_ = _tmp5_[50];
	_tmp7_ = unparsed;
	_tmp7__length1 = unparsed_length1;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	result = _tmp8_;
	unparsed = (g_free (unparsed), NULL);
	id = (g_free (id), NULL);
	return result;
}


gchar* rygel_media_export_media_cache_get_reset_token (RygelMediaExportMediaCache* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		RygelMediaExportDatabaseCursor* _tmp0_ = NULL;
		RygelMediaExportDatabaseCursor* cursor;
		RygelMediaExportDatabaseCursor* _tmp1_;
		sqlite3_stmt* _tmp2_ = NULL;
		sqlite3_stmt* statement;
		sqlite3_stmt* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_RESET_TOKEN, NULL, 0, &_inner_error_);
		cursor = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch12_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp1_ = cursor;
		_tmp2_ = rygel_media_export_database_cursor_next (_tmp1_, &_inner_error_);
		statement = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (cursor);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch12_rygel_media_export_database_error;
			}
			_g_object_unref0 (cursor);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = statement;
		_tmp4_ = sqlite3_column_text (_tmp3_, 0);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (cursor);
		return result;
	}
	goto __finally12;
	__catch12_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp6_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-media-cache.vala:519: Failed to get reset token");
		_tmp6_ = uuid_get ();
		result = _tmp6_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally12:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void rygel_media_export_media_cache_save_reset_token (RygelMediaExportMediaCache* self, const gchar* token) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	{
		const gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		GValue* args;
		gint args_length1;
		gint _args_size_;
		RygelMediaExportDatabase* _tmp3_;
		_tmp0_ = token;
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_set_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		args = _tmp2_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp3_ = self->priv->db;
		rygel_media_export_database_exec (_tmp3_, "UPDATE schema_info SET reset_token = ?", args, args_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch13_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally13;
	__catch13_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("rygel-media-export-media-cache.vala:531: Failed to persist ServiceRese" \
"tToken: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_drop_virtual_folders (RygelMediaExportMediaCache* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RygelMediaExportDatabase* _tmp0_;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_exec (_tmp0_, "DELETE FROM object WHERE " "upnp_id LIKE 'virtual-parent:%'", NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("rygel-media-export-media-cache.vala:540: Failed to drop virtual folder" \
"s: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_make_object_guarded (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean guarded) {
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint _tmp2_;
	gint guarded_val;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp1_ = guarded;
	if (_tmp1_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = _tmp0_;
	guarded_val = _tmp2_;
	{
		GValue _tmp3_ = {0};
		RygelMediaObject* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GValue _tmp7_ = {0};
		GValue* _tmp8_ = NULL;
		GValue* values;
		gint values_length1;
		gint _values_size_;
		RygelMediaExportDatabase* _tmp9_;
		RygelMediaExportSQLFactory* _tmp10_;
		const gchar* _tmp11_ = NULL;
		g_value_init (&_tmp3_, G_TYPE_INT);
		g_value_set_int (&_tmp3_, guarded_val);
		_tmp4_ = object;
		_tmp5_ = rygel_media_object_get_id (_tmp4_);
		_tmp6_ = _tmp5_;
		g_value_init (&_tmp7_, G_TYPE_STRING);
		g_value_set_string (&_tmp7_, _tmp6_);
		_tmp8_ = g_new0 (GValue, 2);
		_tmp8_[0] = _tmp3_;
		_tmp8_[1] = _tmp7_;
		values = _tmp8_;
		values_length1 = 2;
		_values_size_ = values_length1;
		_tmp9_ = self->priv->db;
		_tmp10_ = self->priv->sql;
		_tmp11_ = rygel_media_export_sql_factory_make (_tmp10_, RYGEL_MEDIA_EXPORT_SQL_STRING_MAKE_GUARDED);
		rygel_media_export_database_exec (_tmp9_, _tmp11_, values, values_length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch15_rygel_media_export_database_error;
			}
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		values = (_vala_GValue_array_free (values, values_length1), NULL);
	}
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		RygelMediaObject* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = object;
		_tmp13_ = rygel_media_object_get_id (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning ("rygel-media-export-media-cache.vala:554: Failed to mark item %s as gua" \
"rded (%d): %s", _tmp14_, guarded_val, _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gchar* rygel_media_export_media_cache_create_reference (RygelMediaExportMediaCache* self, RygelMediaObject* object, RygelMediaContainer* parent, GError** error) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp5_;
	RygelMediaContainer* _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	RygelMediaObject* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	RygelMediaObject* _tmp17_;
	RygelMediaObject* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* msg;
		const gchar* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = _ ("Cannot create references to containers");
		_tmp2_ = g_strdup (_tmp1_);
		msg = _tmp2_;
		_tmp3_ = msg;
		_tmp4_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return NULL;
	}
	_tmp5_ = object;
	_tmp6_ = parent;
	rygel_media_object_set_parent (_tmp5_, _tmp6_);
	_tmp7_ = object;
	_tmp8_ = rygel_media_object_get_ref_id (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		RygelMediaObject* _tmp10_;
		RygelMediaObject* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = object;
		_tmp11_ = object;
		_tmp12_ = rygel_media_object_get_id (_tmp11_);
		_tmp13_ = _tmp12_;
		rygel_media_object_set_ref_id (_tmp10_, _tmp13_);
	}
	_tmp14_ = object;
	_tmp15_ = uuid_get ();
	_tmp16_ = _tmp15_;
	rygel_media_object_set_id (_tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = object;
	rygel_media_export_media_cache_save_item (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp17_) : NULL, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp18_ = object;
	_tmp19_ = rygel_media_object_get_id (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup (_tmp20_);
	result = _tmp21_;
	return result;
}


static gboolean rygel_media_export_media_cache_is_object_guarded (RygelMediaExportMediaCache* self, const gchar* id) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	{
		const gchar* _tmp0_;
		GValue _tmp1_ = {0};
		GValue* _tmp2_ = NULL;
		GValue* id_value;
		gint id_value_length1;
		gint _id_value_size_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		_tmp0_ = id;
		g_value_init (&_tmp1_, G_TYPE_STRING);
		g_value_set_string (&_tmp1_, _tmp0_);
		_tmp2_ = g_new0 (GValue, 1);
		_tmp2_[0] = _tmp1_;
		id_value = _tmp2_;
		id_value_length1 = 1;
		_id_value_size_ = id_value_length1;
		_tmp3_ = rygel_media_export_media_cache_query_value (self, RYGEL_MEDIA_EXPORT_SQL_STRING_IS_GUARDED, id_value, id_value_length1, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch16_rygel_media_export_database_error;
			}
			id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp4_ == 1;
		id_value = (_vala_GValue_array_free (id_value, id_value_length1), NULL);
		return result;
	}
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = id;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("rygel-media-export-media-cache.vala:591: Failed to get whether item %s" \
" is guarded: %s", _tmp5_, _tmp7_);
		result = FALSE;
		_g_error_free0 (_error_);
		return result;
	}
	__finally16:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


void rygel_media_export_media_cache_rebuild_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_;
	RygelMediaExportDatabaseCursor* _tmp1_ = NULL;
	RygelMediaExportDatabaseCursor* cursor;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exists_cache);
	self->priv->exists_cache = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_exec_cursor (self, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE, NULL, 0, &_inner_error_);
	cursor = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		RygelMediaExportDatabaseCursor* _tmp2_;
		RygelMediaExportDatabaseCursorIterator* _tmp3_ = NULL;
		RygelMediaExportDatabaseCursorIterator* _statement_it;
		_tmp2_ = cursor;
		_tmp3_ = rygel_media_export_database_cursor_iterator (_tmp2_);
		_statement_it = _tmp3_;
		while (TRUE) {
			RygelMediaExportDatabaseCursorIterator* _tmp4_;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			RygelMediaExportDatabaseCursorIterator* _tmp7_;
			sqlite3_stmt* _tmp8_ = NULL;
			sqlite3_stmt* statement;
			RygelMediaExportExistsCacheEntry entry = {0};
			sqlite3_stmt* _tmp9_;
			gint64 _tmp10_ = 0LL;
			sqlite3_stmt* _tmp11_;
			gint64 _tmp12_ = 0LL;
			GeeHashMap* _tmp13_;
			sqlite3_stmt* _tmp14_;
			const gchar* _tmp15_ = NULL;
			RygelMediaExportExistsCacheEntry _tmp16_;
			_tmp4_ = _statement_it;
			_tmp5_ = rygel_media_export_database_cursor_iterator_next (_tmp4_, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _statement_it;
			_tmp8_ = rygel_media_export_database_cursor_iterator_get (_tmp7_, &_inner_error_);
			statement = _tmp8_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					return;
				} else {
					_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
					_g_object_unref0 (cursor);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
			_tmp9_ = statement;
			_tmp10_ = sqlite3_column_int64 (_tmp9_, 1);
			entry.mtime = _tmp10_;
			_tmp11_ = statement;
			_tmp12_ = sqlite3_column_int64 (_tmp11_, 0);
			entry.size = _tmp12_;
			_tmp13_ = self->priv->exists_cache;
			_tmp14_ = statement;
			_tmp15_ = sqlite3_column_text (_tmp14_, 2);
			_tmp16_ = entry;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp15_, &_tmp16_);
		}
		_rygel_media_export_database_cursor_iterator_unref0 (_statement_it);
	}
	_g_object_unref0 (cursor);
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = max_count;
	if (_tmp0_ == ((guint) 0)) {
		result = (guint) (-1);
		return result;
	} else {
		guint _tmp1_;
		_tmp1_ = max_count;
		result = _tmp1_;
		return result;
	}
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	RygelMediaExportDatabase* _tmp1_;
	RygelMediaExportDatabase* _tmp2_;
	gint old_version;
	gint _tmp3_ = 0;
	gint current_version;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = rygel_media_export_database_new (_tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp2_;
	old_version = -1;
	_tmp3_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
	current_version = _tmp3_;
	{
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		RygelMediaExportMediaCacheUpgrader* _tmp6_;
		RygelMediaExportMediaCacheUpgrader* upgrader;
		RygelMediaExportMediaCacheUpgrader* _tmp7_;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		RygelMediaExportMediaCacheUpgrader* _tmp19_;
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_media_cache_upgrader_new (_tmp4_, _tmp5_);
		upgrader = _tmp6_;
		_tmp7_ = upgrader;
		_tmp9_ = rygel_media_export_media_cache_upgrader_needs_upgrade (_tmp7_, &_tmp8_, &_inner_error_);
		old_version = _tmp8_;
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch17_rygel_media_export_database_error;
			}
			goto __finally17;
		}
		if (_tmp10_) {
			RygelMediaExportMediaCacheUpgrader* _tmp11_;
			gint _tmp12_;
			_tmp11_ = upgrader;
			_tmp12_ = old_version;
			rygel_media_export_media_cache_upgrader_upgrade (_tmp11_, _tmp12_);
		} else {
			gint _tmp13_;
			gint _tmp14_;
			_tmp13_ = old_version;
			_tmp14_ = current_version;
			if (_tmp13_ == _tmp14_) {
				RygelMediaExportMediaCacheUpgrader* _tmp15_;
				_tmp15_ = upgrader;
				rygel_media_export_media_cache_upgrader_fix_schema (_tmp15_, &_inner_error_);
				if (_inner_error_ != NULL) {
					_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch17_rygel_media_export_database_error;
					}
					goto __finally17;
				}
			} else {
				gint _tmp16_;
				gint _tmp17_;
				GError* _tmp18_;
				_tmp16_ = old_version;
				_tmp17_ = current_version;
				g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", _tmp16_, _tmp17_);
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_tmp18_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
				_inner_error_ = _tmp18_;
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch17_rygel_media_export_database_error;
				}
				goto __finally17;
			}
		}
		_tmp19_ = upgrader;
		rygel_media_export_media_cache_upgrader_ensure_indices (_tmp19_);
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	}
	goto __finally17;
	__catch17_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-media-export-media-cache.vala:641: %s", "Could not find schema version;" " checking for empty database...");
		{
			RygelMediaExportDatabase* _tmp20_;
			gint _tmp21_ = 0;
			gint rows;
			gint _tmp22_;
			_tmp20_ = self->priv->db;
			_tmp21_ = rygel_media_export_database_query_value (_tmp20_, "SELECT count(type) FROM " "sqlite_master WHERE rowid=1", NULL, 0, &_inner_error_);
			rows = _tmp21_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch18_rygel_media_export_database_error;
				}
				_g_error_free0 (_error_);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp22_ = rows;
			if (_tmp22_ == 0) {
				gboolean _tmp23_ = FALSE;
				g_debug ("rygel-media-export-media-cache.vala:647: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_SCHEMA_VERSION);
				_tmp23_ = rygel_media_export_media_cache_create_schema (self);
				if (!_tmp23_) {
					_g_object_unref0 (self->priv->db);
					self->priv->db = NULL;
					_g_error_free0 (_error_);
					return;
				}
			} else {
				g_warning ("rygel-media-export-media-cache.vala:655: Incompatible schema... cannot" \
" proceed");
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				_g_error_free0 (_error_);
				return;
			}
		}
		goto __finally18;
		__catch18_rygel_media_export_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			GError* _tmp26_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = _error_;
			_tmp25_ = _tmp24_->message;
			g_warning ("rygel-media-export-media-cache.vala:661: Something weird going on: %s", _tmp25_);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp26_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
			_inner_error_ = _tmp26_;
			_g_error_free0 (_error_);
			goto __finally18;
		}
		__finally18:
		if (_inner_error_ != NULL) {
			_g_error_free0 (_error_);
			goto __finally17;
		}
		_g_error_free0 (_error_);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_save_container_metadata (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GValue _tmp0_ = {0};
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	RygelMediaContainer* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	RygelMediaContainer* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue* _tmp26_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabase* _tmp27_;
	RygelMediaExportSQLFactory* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_value_init (&_tmp0_, G_TYPE_INT);
	g_value_set_int (&_tmp0_, 0);
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, "inode/directory");
	g_value_init (&_tmp2_, G_TYPE_INT);
	g_value_set_int (&_tmp2_, -1);
	g_value_init (&_tmp3_, G_TYPE_INT);
	g_value_set_int (&_tmp3_, -1);
	_tmp4_ = container;
	_tmp5_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp4_);
	_tmp6_ = _tmp5_;
	g_value_init (&_tmp7_, G_TYPE_STRING);
	g_value_set_string (&_tmp7_, _tmp6_);
	rygel_media_export_database_null (&_tmp8_);
	rygel_media_export_database_null (&_tmp9_);
	rygel_media_export_database_null (&_tmp10_);
	g_value_init (&_tmp11_, G_TYPE_INT);
	g_value_set_int (&_tmp11_, -1);
	g_value_init (&_tmp12_, G_TYPE_INT);
	g_value_set_int (&_tmp12_, -1);
	g_value_init (&_tmp13_, G_TYPE_INT);
	g_value_set_int (&_tmp13_, -1);
	g_value_init (&_tmp14_, G_TYPE_INT);
	g_value_set_int (&_tmp14_, -1);
	g_value_init (&_tmp15_, G_TYPE_INT);
	g_value_set_int (&_tmp15_, -1);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	g_value_init (&_tmp17_, G_TYPE_INT);
	g_value_set_int (&_tmp17_, -1);
	_tmp18_ = container;
	_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp18_);
	_tmp20_ = _tmp19_;
	g_value_init (&_tmp21_, G_TYPE_STRING);
	g_value_set_string (&_tmp21_, _tmp20_);
	rygel_media_export_database_null (&_tmp22_);
	rygel_media_export_database_null (&_tmp23_);
	g_value_init (&_tmp24_, G_TYPE_INT);
	g_value_set_int (&_tmp24_, -1);
	rygel_media_export_database_null (&_tmp25_);
	_tmp26_ = g_new0 (GValue, 20);
	_tmp26_[0] = _tmp0_;
	_tmp26_[1] = _tmp1_;
	_tmp26_[2] = _tmp2_;
	_tmp26_[3] = _tmp3_;
	_tmp26_[4] = _tmp7_;
	_tmp26_[5] = _tmp8_;
	_tmp26_[6] = _tmp9_;
	_tmp26_[7] = _tmp10_;
	_tmp26_[8] = _tmp11_;
	_tmp26_[9] = _tmp12_;
	_tmp26_[10] = _tmp13_;
	_tmp26_[11] = _tmp14_;
	_tmp26_[12] = _tmp15_;
	_tmp26_[13] = _tmp16_;
	_tmp26_[14] = _tmp17_;
	_tmp26_[15] = _tmp21_;
	_tmp26_[16] = _tmp22_;
	_tmp26_[17] = _tmp23_;
	_tmp26_[18] = _tmp24_;
	_tmp26_[19] = _tmp25_;
	values = _tmp26_;
	values_length1 = 20;
	_values_size_ = values_length1;
	_tmp27_ = self->priv->db;
	_tmp28_ = self->priv->sql;
	_tmp29_ = rygel_media_export_sql_factory_make (_tmp28_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	rygel_media_export_database_exec (_tmp27_, _tmp29_, values, values_length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_export_media_cache_save_item_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	RygelMediaItem* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GValue _tmp3_ = {0};
	RygelMediaItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	RygelMediaItem* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	RygelMediaItem* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue _tmp22_ = {0};
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GValue _tmp25_ = {0};
	GValue _tmp26_ = {0};
	RygelMediaItem* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GValue _tmp30_ = {0};
	RygelMediaItem* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GValue _tmp36_ = {0};
	RygelMediaItem* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GValue _tmp40_ = {0};
	GValue* _tmp41_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaItem* _tmp42_;
	RygelMediaItem* _tmp107_;
	RygelMediaItem* _tmp137_;
	RygelMediaExportDatabase* _tmp146_;
	RygelMediaExportSQLFactory* _tmp147_;
	const gchar* _tmp148_ = NULL;
	GValue* _tmp149_;
	gint _tmp149__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = rygel_media_item_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	g_value_init (&_tmp3_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp3_, _tmp2_);
	_tmp4_ = item;
	_tmp5_ = rygel_media_item_get_mime_type (_tmp4_);
	_tmp6_ = _tmp5_;
	g_value_init (&_tmp7_, G_TYPE_STRING);
	g_value_set_string (&_tmp7_, _tmp6_);
	g_value_init (&_tmp8_, G_TYPE_INT);
	g_value_set_int (&_tmp8_, -1);
	g_value_init (&_tmp9_, G_TYPE_INT);
	g_value_set_int (&_tmp9_, -1);
	_tmp10_ = item;
	_tmp11_ = rygel_media_object_get_upnp_class ((RygelMediaObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	g_value_init (&_tmp13_, G_TYPE_STRING);
	g_value_set_string (&_tmp13_, _tmp12_);
	rygel_media_export_database_null (&_tmp14_);
	rygel_media_export_database_null (&_tmp15_);
	_tmp16_ = item;
	_tmp17_ = rygel_media_item_get_date (_tmp16_);
	_tmp18_ = _tmp17_;
	g_value_init (&_tmp19_, G_TYPE_STRING);
	g_value_set_string (&_tmp19_, _tmp18_);
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, -1);
	g_value_init (&_tmp21_, G_TYPE_INT);
	g_value_set_int (&_tmp21_, -1);
	g_value_init (&_tmp22_, G_TYPE_INT);
	g_value_set_int (&_tmp22_, -1);
	g_value_init (&_tmp23_, G_TYPE_INT);
	g_value_set_int (&_tmp23_, -1);
	g_value_init (&_tmp24_, G_TYPE_INT);
	g_value_set_int (&_tmp24_, -1);
	g_value_init (&_tmp25_, G_TYPE_INT);
	g_value_set_int (&_tmp25_, -1);
	g_value_init (&_tmp26_, G_TYPE_INT);
	g_value_set_int (&_tmp26_, -1);
	_tmp27_ = item;
	_tmp28_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp27_);
	_tmp29_ = _tmp28_;
	g_value_init (&_tmp30_, G_TYPE_STRING);
	g_value_set_string (&_tmp30_, _tmp29_);
	_tmp31_ = item;
	_tmp32_ = rygel_media_item_get_dlna_profile (_tmp31_);
	_tmp33_ = _tmp32_;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, _tmp33_);
	rygel_media_export_database_null (&_tmp35_);
	g_value_init (&_tmp36_, G_TYPE_INT);
	g_value_set_int (&_tmp36_, -1);
	_tmp37_ = item;
	_tmp38_ = rygel_media_item_get_creator (_tmp37_);
	_tmp39_ = _tmp38_;
	g_value_init (&_tmp40_, G_TYPE_STRING);
	g_value_set_string (&_tmp40_, _tmp39_);
	_tmp41_ = g_new0 (GValue, 20);
	_tmp41_[0] = _tmp3_;
	_tmp41_[1] = _tmp7_;
	_tmp41_[2] = _tmp8_;
	_tmp41_[3] = _tmp9_;
	_tmp41_[4] = _tmp13_;
	_tmp41_[5] = _tmp14_;
	_tmp41_[6] = _tmp15_;
	_tmp41_[7] = _tmp19_;
	_tmp41_[8] = _tmp20_;
	_tmp41_[9] = _tmp21_;
	_tmp41_[10] = _tmp22_;
	_tmp41_[11] = _tmp23_;
	_tmp41_[12] = _tmp24_;
	_tmp41_[13] = _tmp25_;
	_tmp41_[14] = _tmp26_;
	_tmp41_[15] = _tmp30_;
	_tmp41_[16] = _tmp34_;
	_tmp41_[17] = _tmp35_;
	_tmp41_[18] = _tmp36_;
	_tmp41_[19] = _tmp40_;
	values = _tmp41_;
	values_length1 = 20;
	_values_size_ = values_length1;
	_tmp42_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaItem* _tmp43_;
		RygelAudioItem* _tmp44_;
		RygelAudioItem* audio_item;
		GValue* _tmp45_;
		gint _tmp45__length1;
		RygelAudioItem* _tmp46_;
		glong _tmp47_;
		glong _tmp48_;
		GValue _tmp49_ = {0};
		GValue _tmp50_;
		GValue* _tmp51_;
		gint _tmp51__length1;
		RygelAudioItem* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		GValue _tmp55_ = {0};
		GValue _tmp56_;
		GValue* _tmp57_;
		gint _tmp57__length1;
		RygelAudioItem* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		GValue _tmp61_ = {0};
		GValue _tmp62_;
		GValue* _tmp63_;
		gint _tmp63__length1;
		RygelAudioItem* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		GValue _tmp67_ = {0};
		GValue _tmp68_;
		GValue* _tmp69_;
		gint _tmp69__length1;
		RygelAudioItem* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		GValue _tmp73_ = {0};
		GValue _tmp74_;
		RygelMediaItem* _tmp75_;
		_tmp43_ = item;
		_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp43_) : NULL);
		audio_item = _tmp44_;
		_tmp45_ = values;
		_tmp45__length1 = values_length1;
		_tmp46_ = audio_item;
		_tmp47_ = rygel_audio_item_get_duration (_tmp46_);
		_tmp48_ = _tmp47_;
		g_value_init (&_tmp49_, G_TYPE_LONG);
		g_value_set_long (&_tmp49_, _tmp48_);
		G_IS_VALUE (&_tmp45_[14]) ? (g_value_unset (&_tmp45_[14]), NULL) : NULL;
		_tmp45_[14] = _tmp49_;
		_tmp50_ = _tmp45_[14];
		_tmp51_ = values;
		_tmp51__length1 = values_length1;
		_tmp52_ = audio_item;
		_tmp53_ = rygel_audio_item_get_bitrate (_tmp52_);
		_tmp54_ = _tmp53_;
		g_value_init (&_tmp55_, G_TYPE_INT);
		g_value_set_int (&_tmp55_, _tmp54_);
		G_IS_VALUE (&_tmp51_[8]) ? (g_value_unset (&_tmp51_[8]), NULL) : NULL;
		_tmp51_[8] = _tmp55_;
		_tmp56_ = _tmp51_[8];
		_tmp57_ = values;
		_tmp57__length1 = values_length1;
		_tmp58_ = audio_item;
		_tmp59_ = rygel_audio_item_get_sample_freq (_tmp58_);
		_tmp60_ = _tmp59_;
		g_value_init (&_tmp61_, G_TYPE_INT);
		g_value_set_int (&_tmp61_, _tmp60_);
		G_IS_VALUE (&_tmp57_[9]) ? (g_value_unset (&_tmp57_[9]), NULL) : NULL;
		_tmp57_[9] = _tmp61_;
		_tmp62_ = _tmp57_[9];
		_tmp63_ = values;
		_tmp63__length1 = values_length1;
		_tmp64_ = audio_item;
		_tmp65_ = rygel_audio_item_get_bits_per_sample (_tmp64_);
		_tmp66_ = _tmp65_;
		g_value_init (&_tmp67_, G_TYPE_INT);
		g_value_set_int (&_tmp67_, _tmp66_);
		G_IS_VALUE (&_tmp63_[10]) ? (g_value_unset (&_tmp63_[10]), NULL) : NULL;
		_tmp63_[10] = _tmp67_;
		_tmp68_ = _tmp63_[10];
		_tmp69_ = values;
		_tmp69__length1 = values_length1;
		_tmp70_ = audio_item;
		_tmp71_ = rygel_audio_item_get_channels (_tmp70_);
		_tmp72_ = _tmp71_;
		g_value_init (&_tmp73_, G_TYPE_INT);
		g_value_set_int (&_tmp73_, _tmp72_);
		G_IS_VALUE (&_tmp69_[11]) ? (g_value_unset (&_tmp69_[11]), NULL) : NULL;
		_tmp69_[11] = _tmp73_;
		_tmp74_ = _tmp69_[11];
		_tmp75_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaItem* _tmp76_;
			RygelMediaExportMusicItem* _tmp77_;
			RygelMediaExportMusicItem* music_item;
			GValue* _tmp78_;
			gint _tmp78__length1;
			RygelMediaExportMusicItem* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			GValue _tmp82_ = {0};
			GValue _tmp83_;
			GValue* _tmp84_;
			gint _tmp84__length1;
			RygelMediaExportMusicItem* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			GValue _tmp88_ = {0};
			GValue _tmp89_;
			GValue* _tmp90_;
			gint _tmp90__length1;
			RygelMediaExportMusicItem* _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			GValue _tmp94_ = {0};
			GValue _tmp95_;
			GValue* _tmp96_;
			gint _tmp96__length1;
			RygelMediaExportMusicItem* _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			GValue _tmp100_ = {0};
			GValue _tmp101_;
			GValue* _tmp102_;
			gint _tmp102__length1;
			RygelMediaExportMusicItem* _tmp103_;
			gint _tmp104_;
			GValue _tmp105_ = {0};
			GValue _tmp106_;
			_tmp76_ = item;
			_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp76_) : NULL);
			music_item = _tmp77_;
			_tmp78_ = values;
			_tmp78__length1 = values_length1;
			_tmp79_ = music_item;
			_tmp80_ = rygel_music_item_get_artist ((RygelMusicItem*) _tmp79_);
			_tmp81_ = _tmp80_;
			g_value_init (&_tmp82_, G_TYPE_STRING);
			g_value_set_string (&_tmp82_, _tmp81_);
			G_IS_VALUE (&_tmp78_[5]) ? (g_value_unset (&_tmp78_[5]), NULL) : NULL;
			_tmp78_[5] = _tmp82_;
			_tmp83_ = _tmp78_[5];
			_tmp84_ = values;
			_tmp84__length1 = values_length1;
			_tmp85_ = music_item;
			_tmp86_ = rygel_music_item_get_album ((RygelMusicItem*) _tmp85_);
			_tmp87_ = _tmp86_;
			g_value_init (&_tmp88_, G_TYPE_STRING);
			g_value_set_string (&_tmp88_, _tmp87_);
			G_IS_VALUE (&_tmp84_[6]) ? (g_value_unset (&_tmp84_[6]), NULL) : NULL;
			_tmp84_[6] = _tmp88_;
			_tmp89_ = _tmp84_[6];
			_tmp90_ = values;
			_tmp90__length1 = values_length1;
			_tmp91_ = music_item;
			_tmp92_ = rygel_music_item_get_genre ((RygelMusicItem*) _tmp91_);
			_tmp93_ = _tmp92_;
			g_value_init (&_tmp94_, G_TYPE_STRING);
			g_value_set_string (&_tmp94_, _tmp93_);
			G_IS_VALUE (&_tmp90_[17]) ? (g_value_unset (&_tmp90_[17]), NULL) : NULL;
			_tmp90_[17] = _tmp94_;
			_tmp95_ = _tmp90_[17];
			_tmp96_ = values;
			_tmp96__length1 = values_length1;
			_tmp97_ = music_item;
			_tmp98_ = rygel_music_item_get_track_number ((RygelMusicItem*) _tmp97_);
			_tmp99_ = _tmp98_;
			g_value_init (&_tmp100_, G_TYPE_INT);
			g_value_set_int (&_tmp100_, _tmp99_);
			G_IS_VALUE (&_tmp96_[12]) ? (g_value_unset (&_tmp96_[12]), NULL) : NULL;
			_tmp96_[12] = _tmp100_;
			_tmp101_ = _tmp96_[12];
			_tmp102_ = values;
			_tmp102__length1 = values_length1;
			_tmp103_ = music_item;
			_tmp104_ = _tmp103_->disc;
			g_value_init (&_tmp105_, G_TYPE_INT);
			g_value_set_int (&_tmp105_, _tmp104_);
			G_IS_VALUE (&_tmp102_[18]) ? (g_value_unset (&_tmp102_[18]), NULL) : NULL;
			_tmp102_[18] = _tmp105_;
			_tmp106_ = _tmp102_[18];
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp107_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelMediaItem* _tmp108_;
		RygelVisualItem* _tmp109_;
		RygelVisualItem* visual_item;
		GValue* _tmp110_;
		gint _tmp110__length1;
		RygelVisualItem* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		GValue _tmp114_ = {0};
		GValue _tmp115_;
		GValue* _tmp116_;
		gint _tmp116__length1;
		RygelVisualItem* _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		GValue _tmp120_ = {0};
		GValue _tmp121_;
		GValue* _tmp122_;
		gint _tmp122__length1;
		RygelVisualItem* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		GValue _tmp126_ = {0};
		GValue _tmp127_;
		RygelMediaItem* _tmp128_;
		_tmp108_ = item;
		_tmp109_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp108_) : NULL);
		visual_item = _tmp109_;
		_tmp110_ = values;
		_tmp110__length1 = values_length1;
		_tmp111_ = visual_item;
		_tmp112_ = rygel_visual_item_get_width (_tmp111_);
		_tmp113_ = _tmp112_;
		g_value_init (&_tmp114_, G_TYPE_INT);
		g_value_set_int (&_tmp114_, _tmp113_);
		G_IS_VALUE (&_tmp110_[2]) ? (g_value_unset (&_tmp110_[2]), NULL) : NULL;
		_tmp110_[2] = _tmp114_;
		_tmp115_ = _tmp110_[2];
		_tmp116_ = values;
		_tmp116__length1 = values_length1;
		_tmp117_ = visual_item;
		_tmp118_ = rygel_visual_item_get_height (_tmp117_);
		_tmp119_ = _tmp118_;
		g_value_init (&_tmp120_, G_TYPE_INT);
		g_value_set_int (&_tmp120_, _tmp119_);
		G_IS_VALUE (&_tmp116_[3]) ? (g_value_unset (&_tmp116_[3]), NULL) : NULL;
		_tmp116_[3] = _tmp120_;
		_tmp121_ = _tmp116_[3];
		_tmp122_ = values;
		_tmp122__length1 = values_length1;
		_tmp123_ = visual_item;
		_tmp124_ = rygel_visual_item_get_color_depth (_tmp123_);
		_tmp125_ = _tmp124_;
		g_value_init (&_tmp126_, G_TYPE_INT);
		g_value_set_int (&_tmp126_, _tmp125_);
		G_IS_VALUE (&_tmp122_[13]) ? (g_value_unset (&_tmp122_[13]), NULL) : NULL;
		_tmp122_[13] = _tmp126_;
		_tmp127_ = _tmp122_[13];
		_tmp128_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM)) {
			RygelMediaItem* _tmp129_;
			RygelMediaExportVideoItem* _tmp130_;
			RygelMediaExportVideoItem* video_item;
			GValue* _tmp131_;
			gint _tmp131__length1;
			RygelMediaExportVideoItem* _tmp132_;
			const gchar* _tmp133_;
			const gchar* _tmp134_;
			GValue _tmp135_ = {0};
			GValue _tmp136_;
			_tmp129_ = item;
			_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, RYGEL_MEDIA_EXPORT_TYPE_VIDEO_ITEM) ? ((RygelMediaExportVideoItem*) _tmp129_) : NULL);
			video_item = _tmp130_;
			_tmp131_ = values;
			_tmp131__length1 = values_length1;
			_tmp132_ = video_item;
			_tmp133_ = rygel_video_item_get_author ((RygelVideoItem*) _tmp132_);
			_tmp134_ = _tmp133_;
			g_value_init (&_tmp135_, G_TYPE_STRING);
			g_value_set_string (&_tmp135_, _tmp134_);
			G_IS_VALUE (&_tmp131_[5]) ? (g_value_unset (&_tmp131_[5]), NULL) : NULL;
			_tmp131_[5] = _tmp135_;
			_tmp136_ = _tmp131_[5];
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
	_tmp137_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM)) {
		RygelMediaItem* _tmp138_;
		RygelMediaExportPlaylistItem* _tmp139_;
		RygelMediaExportPlaylistItem* playlist_item;
		GValue* _tmp140_;
		gint _tmp140__length1;
		RygelMediaExportPlaylistItem* _tmp141_;
		const gchar* _tmp142_;
		const gchar* _tmp143_;
		GValue _tmp144_ = {0};
		GValue _tmp145_;
		_tmp138_ = item;
		_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp138_, RYGEL_MEDIA_EXPORT_TYPE_PLAYLIST_ITEM) ? ((RygelMediaExportPlaylistItem*) _tmp138_) : NULL);
		playlist_item = _tmp139_;
		_tmp140_ = values;
		_tmp140__length1 = values_length1;
		_tmp141_ = playlist_item;
		_tmp142_ = rygel_media_item_get_creator ((RygelMediaItem*) _tmp141_);
		_tmp143_ = _tmp142_;
		g_value_init (&_tmp144_, G_TYPE_STRING);
		g_value_set_string (&_tmp144_, _tmp143_);
		G_IS_VALUE (&_tmp140_[5]) ? (g_value_unset (&_tmp140_[5]), NULL) : NULL;
		_tmp140_[5] = _tmp144_;
		_tmp145_ = _tmp140_[5];
		_g_object_unref0 (playlist_item);
	}
	_tmp146_ = self->priv->db;
	_tmp147_ = self->priv->sql;
	_tmp148_ = rygel_media_export_sql_factory_make (_tmp147_, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	_tmp149_ = values;
	_tmp149__length1 = values_length1;
	rygel_media_export_database_exec (_tmp146_, _tmp148_, _tmp149_, _tmp149__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_export_media_cache_update_guarded_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	gint type;
	GValue parent = {0};
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_;
	GeeArrayList* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp19_;
	GValue _tmp20_ = {0};
	GValue _tmp21_;
	GValue _tmp22_ = {0};
	RygelMediaObject* _tmp23_;
	guint64 _tmp24_;
	guint64 _tmp25_;
	GValue _tmp26_ = {0};
	const gchar* _tmp27_;
	GValue _tmp28_ = {0};
	RygelMediaObject* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	GValue _tmp32_ = {0};
	GValue _tmp33_ = {0};
	GValue _tmp34_ = {0};
	RygelMediaObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GValue _tmp38_ = {0};
	GValue* _tmp39_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* _tmp40_;
	RygelMediaExportDatabase* _tmp53_;
	RygelMediaExportSQLFactory* _tmp54_;
	const gchar* _tmp55_ = NULL;
	GValue* _tmp56_;
	gint _tmp56__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp1_ = object;
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		GValue _tmp4_ = {0};
		rygel_media_export_database_null (&_tmp4_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp4_;
	} else {
		RygelMediaObject* _tmp5_;
		RygelMediaContainer* _tmp6_;
		RygelMediaContainer* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GValue _tmp10_ = {0};
		_tmp5_ = object;
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_value_init (&_tmp10_, G_TYPE_STRING);
		g_value_set_string (&_tmp10_, _tmp9_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp10_;
	}
	_tmp12_ = object;
	_tmp13_ = _tmp12_->uris;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	} else {
		RygelMediaObject* _tmp16_;
		GeeArrayList* _tmp17_;
		gpointer _tmp18_ = NULL;
		_tmp16_ = object;
		_tmp17_ = _tmp16_->uris;
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
		_g_free0 (_tmp11_);
		_tmp11_ = (gchar*) _tmp18_;
	}
	_tmp19_ = type;
	g_value_init (&_tmp20_, G_TYPE_INT);
	g_value_set_int (&_tmp20_, _tmp19_);
	_tmp21_ = parent;
	if (G_IS_VALUE (&_tmp21_)) {
		g_value_init (&_tmp22_, G_VALUE_TYPE (&_tmp21_));
		g_value_copy (&_tmp21_, &_tmp22_);
	} else {
		_tmp22_ = _tmp21_;
	}
	_tmp23_ = object;
	_tmp24_ = rygel_media_object_get_modified (_tmp23_);
	_tmp25_ = _tmp24_;
	g_value_init (&_tmp26_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp26_, _tmp25_);
	_tmp27_ = _tmp11_;
	g_value_init (&_tmp28_, G_TYPE_STRING);
	g_value_set_string (&_tmp28_, _tmp27_);
	_tmp29_ = object;
	_tmp30_ = rygel_media_object_get_object_update_id (_tmp29_);
	_tmp31_ = _tmp30_;
	g_value_init (&_tmp32_, G_TYPE_UINT);
	g_value_set_uint (&_tmp32_, _tmp31_);
	g_value_init (&_tmp33_, G_TYPE_INT);
	g_value_set_int (&_tmp33_, -1);
	g_value_init (&_tmp34_, G_TYPE_INT);
	g_value_set_int (&_tmp34_, -1);
	_tmp35_ = object;
	_tmp36_ = rygel_media_object_get_id (_tmp35_);
	_tmp37_ = _tmp36_;
	g_value_init (&_tmp38_, G_TYPE_STRING);
	g_value_set_string (&_tmp38_, _tmp37_);
	_tmp39_ = g_new0 (GValue, 8);
	_tmp39_[0] = _tmp20_;
	_tmp39_[1] = _tmp22_;
	_tmp39_[2] = _tmp26_;
	_tmp39_[3] = _tmp28_;
	_tmp39_[4] = _tmp32_;
	_tmp39_[5] = _tmp33_;
	_tmp39_[6] = _tmp34_;
	_tmp39_[7] = _tmp38_;
	values = _tmp39_;
	values_length1 = 8;
	_values_size_ = values_length1;
	_tmp40_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaObject* _tmp41_;
		RygelMediaContainer* _tmp42_;
		RygelMediaContainer* container;
		GValue* _tmp43_;
		gint _tmp43__length1;
		RygelMediaContainer* _tmp44_;
		gint64 _tmp45_;
		GValue _tmp46_ = {0};
		GValue _tmp47_;
		GValue* _tmp48_;
		gint _tmp48__length1;
		RygelMediaContainer* _tmp49_;
		guint32 _tmp50_;
		GValue _tmp51_ = {0};
		GValue _tmp52_;
		_tmp41_ = object;
		_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp41_) : NULL);
		container = _tmp42_;
		_tmp43_ = values;
		_tmp43__length1 = values_length1;
		_tmp44_ = container;
		_tmp45_ = _tmp44_->total_deleted_child_count;
		g_value_init (&_tmp46_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp46_, _tmp45_);
		G_IS_VALUE (&_tmp43_[6]) ? (g_value_unset (&_tmp43_[6]), NULL) : NULL;
		_tmp43_[6] = _tmp46_;
		_tmp47_ = _tmp43_[6];
		_tmp48_ = values;
		_tmp48__length1 = values_length1;
		_tmp49_ = container;
		_tmp50_ = _tmp49_->update_id;
		g_value_init (&_tmp51_, G_TYPE_UINT);
		g_value_set_uint (&_tmp51_, _tmp50_);
		G_IS_VALUE (&_tmp48_[7]) ? (g_value_unset (&_tmp48_[7]), NULL) : NULL;
		_tmp48_[7] = _tmp51_;
		_tmp52_ = _tmp48_[7];
		_g_object_unref0 (container);
	}
	_tmp53_ = self->priv->db;
	_tmp54_ = self->priv->sql;
	_tmp55_ = rygel_media_export_sql_factory_make (_tmp54_, RYGEL_MEDIA_EXPORT_SQL_STRING_UPDATE_GUARDED_OBJECT);
	_tmp56_ = values;
	_tmp56__length1 = values_length1;
	rygel_media_export_database_exec (_tmp53_, _tmp55_, _tmp56_, _tmp56__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp11_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp11_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


static void rygel_media_export_media_cache_create_normal_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean is_guarded, GError** error) {
	gint type;
	GValue parent = {0};
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaContainer* _tmp2_;
	RygelMediaContainer* _tmp3_;
	gchar* _tmp11_ = NULL;
	RygelMediaObject* _tmp12_;
	GeeArrayList* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp19_ = 0;
	gboolean _tmp20_;
	RygelMediaObject* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GValue _tmp30_ = {0};
	RygelMediaObject* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GValue _tmp34_ = {0};
	gint _tmp35_;
	GValue _tmp36_ = {0};
	GValue _tmp37_;
	GValue _tmp38_ = {0};
	RygelMediaObject* _tmp39_;
	guint64 _tmp40_;
	guint64 _tmp41_;
	GValue _tmp42_ = {0};
	const gchar* _tmp43_;
	GValue _tmp44_ = {0};
	RygelMediaObject* _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	GValue _tmp48_ = {0};
	GValue _tmp49_ = {0};
	GValue _tmp50_ = {0};
	gint _tmp51_;
	GValue _tmp52_ = {0};
	const gchar* _tmp53_;
	GValue _tmp54_ = {0};
	GValue* _tmp55_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaObject* _tmp56_;
	RygelMediaExportDatabase* _tmp69_;
	RygelMediaExportSQLFactory* _tmp70_;
	const gchar* _tmp71_ = NULL;
	GValue* _tmp72_;
	gint _tmp72__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	_tmp0_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_ITEM)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	_tmp1_ = object;
	_tmp2_ = rygel_media_object_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		GValue _tmp4_ = {0};
		rygel_media_export_database_null (&_tmp4_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp4_;
	} else {
		RygelMediaObject* _tmp5_;
		RygelMediaContainer* _tmp6_;
		RygelMediaContainer* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GValue _tmp10_ = {0};
		_tmp5_ = object;
		_tmp6_ = rygel_media_object_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_value_init (&_tmp10_, G_TYPE_STRING);
		g_value_set_string (&_tmp10_, _tmp9_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp10_;
	}
	_tmp12_ = object;
	_tmp13_ = _tmp12_->uris;
	_tmp14_ = gee_collection_get_is_empty ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_g_free0 (_tmp11_);
		_tmp11_ = NULL;
	} else {
		RygelMediaObject* _tmp16_;
		GeeArrayList* _tmp17_;
		gpointer _tmp18_ = NULL;
		_tmp16_ = object;
		_tmp17_ = _tmp16_->uris;
		_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
		_g_free0 (_tmp11_);
		_tmp11_ = (gchar*) _tmp18_;
	}
	_tmp20_ = is_guarded;
	if (_tmp20_) {
		_tmp19_ = 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp21_ = object;
	_tmp22_ = rygel_media_object_get_ref_id (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	if (_tmp26_ == NULL) {
		_g_free0 (_tmp25_);
		_tmp25_ = NULL;
	}
	_tmp27_ = object;
	_tmp28_ = rygel_media_object_get_id (_tmp27_);
	_tmp29_ = _tmp28_;
	g_value_init (&_tmp30_, G_TYPE_STRING);
	g_value_set_string (&_tmp30_, _tmp29_);
	_tmp31_ = object;
	_tmp32_ = rygel_media_object_get_title (_tmp31_);
	_tmp33_ = _tmp32_;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, _tmp33_);
	_tmp35_ = type;
	g_value_init (&_tmp36_, G_TYPE_INT);
	g_value_set_int (&_tmp36_, _tmp35_);
	_tmp37_ = parent;
	if (G_IS_VALUE (&_tmp37_)) {
		g_value_init (&_tmp38_, G_VALUE_TYPE (&_tmp37_));
		g_value_copy (&_tmp37_, &_tmp38_);
	} else {
		_tmp38_ = _tmp37_;
	}
	_tmp39_ = object;
	_tmp40_ = rygel_media_object_get_modified (_tmp39_);
	_tmp41_ = _tmp40_;
	g_value_init (&_tmp42_, G_TYPE_UINT64);
	g_value_set_uint64 (&_tmp42_, _tmp41_);
	_tmp43_ = _tmp11_;
	g_value_init (&_tmp44_, G_TYPE_STRING);
	g_value_set_string (&_tmp44_, _tmp43_);
	_tmp45_ = object;
	_tmp46_ = rygel_media_object_get_object_update_id (_tmp45_);
	_tmp47_ = _tmp46_;
	g_value_init (&_tmp48_, G_TYPE_UINT);
	g_value_set_uint (&_tmp48_, _tmp47_);
	g_value_init (&_tmp49_, G_TYPE_INT);
	g_value_set_int (&_tmp49_, -1);
	g_value_init (&_tmp50_, G_TYPE_INT);
	g_value_set_int (&_tmp50_, -1);
	_tmp51_ = _tmp19_;
	g_value_init (&_tmp52_, G_TYPE_INT);
	g_value_set_int (&_tmp52_, _tmp51_);
	_tmp53_ = _tmp25_;
	g_value_init (&_tmp54_, G_TYPE_STRING);
	g_value_set_string (&_tmp54_, _tmp53_);
	_tmp55_ = g_new0 (GValue, 11);
	_tmp55_[0] = _tmp30_;
	_tmp55_[1] = _tmp34_;
	_tmp55_[2] = _tmp36_;
	_tmp55_[3] = _tmp38_;
	_tmp55_[4] = _tmp42_;
	_tmp55_[5] = _tmp44_;
	_tmp55_[6] = _tmp48_;
	_tmp55_[7] = _tmp49_;
	_tmp55_[8] = _tmp50_;
	_tmp55_[9] = _tmp52_;
	_tmp55_[10] = _tmp54_;
	values = _tmp55_;
	values_length1 = 11;
	_values_size_ = values_length1;
	_tmp56_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		RygelMediaObject* _tmp57_;
		RygelMediaContainer* _tmp58_;
		RygelMediaContainer* container;
		GValue* _tmp59_;
		gint _tmp59__length1;
		RygelMediaContainer* _tmp60_;
		gint64 _tmp61_;
		GValue _tmp62_ = {0};
		GValue _tmp63_;
		GValue* _tmp64_;
		gint _tmp64__length1;
		RygelMediaContainer* _tmp65_;
		guint32 _tmp66_;
		GValue _tmp67_ = {0};
		GValue _tmp68_;
		_tmp57_ = object;
		_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp57_) : NULL);
		container = _tmp58_;
		_tmp59_ = values;
		_tmp59__length1 = values_length1;
		_tmp60_ = container;
		_tmp61_ = _tmp60_->total_deleted_child_count;
		g_value_init (&_tmp62_, G_TYPE_INT64);
		g_value_set_int64 (&_tmp62_, _tmp61_);
		G_IS_VALUE (&_tmp59_[7]) ? (g_value_unset (&_tmp59_[7]), NULL) : NULL;
		_tmp59_[7] = _tmp62_;
		_tmp63_ = _tmp59_[7];
		_tmp64_ = values;
		_tmp64__length1 = values_length1;
		_tmp65_ = container;
		_tmp66_ = _tmp65_->update_id;
		g_value_init (&_tmp67_, G_TYPE_UINT);
		g_value_set_uint (&_tmp67_, _tmp66_);
		G_IS_VALUE (&_tmp64_[8]) ? (g_value_unset (&_tmp64_[8]), NULL) : NULL;
		_tmp64_[8] = _tmp67_;
		_tmp68_ = _tmp64_[8];
		_g_object_unref0 (container);
	}
	_tmp69_ = self->priv->db;
	_tmp70_ = self->priv->sql;
	_tmp71_ = rygel_media_export_sql_factory_make (_tmp70_, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
	_tmp72_ = values;
	_tmp72__length1 = values_length1;
	rygel_media_export_database_exec (_tmp69_, _tmp71_, _tmp72_, _tmp72__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp11_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp11_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


/**
     * Add the container or item to the cache.
     */
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, gboolean override_guarded, GError** error) {
	RygelMediaObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean is_guarded;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = rygel_media_object_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = rygel_media_export_media_cache_is_object_guarded (self, _tmp2_);
	is_guarded = _tmp3_;
	_tmp5_ = override_guarded;
	if (!_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = is_guarded;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		RygelMediaObject* _tmp8_;
		_tmp8_ = object;
		rygel_media_export_media_cache_update_guarded_object (self, _tmp8_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		RygelMediaObject* _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = is_guarded;
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gboolean _tmp11_;
			_tmp11_ = override_guarded;
			_tmp9_ = _tmp11_;
		}
		_tmp12_ = object;
		_tmp13_ = _tmp9_;
		rygel_media_export_media_cache_create_normal_object (self, _tmp12_, _tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		RygelMediaExportDatabase* _tmp0_;
		RygelMediaExportDatabase* _tmp1_;
		RygelMediaExportSQLFactory* _tmp2_;
		const gchar* _tmp3_ = NULL;
		RygelMediaExportDatabase* _tmp4_;
		RygelMediaExportSQLFactory* _tmp5_;
		const gchar* _tmp6_ = NULL;
		RygelMediaExportDatabase* _tmp7_;
		RygelMediaExportSQLFactory* _tmp8_;
		const gchar* _tmp9_ = NULL;
		RygelMediaExportDatabase* _tmp10_;
		RygelMediaExportSQLFactory* _tmp11_;
		const gchar* _tmp12_ = NULL;
		RygelMediaExportDatabase* _tmp13_;
		RygelMediaExportSQLFactory* _tmp14_;
		const gchar* _tmp15_ = NULL;
		RygelMediaExportDatabase* _tmp16_;
		RygelMediaExportSQLFactory* _tmp17_;
		const gchar* _tmp18_ = NULL;
		RygelMediaExportDatabase* _tmp19_;
		RygelMediaExportDatabase* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		_tmp0_ = self->priv->db;
		rygel_media_export_database_begin (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp1_ = self->priv->db;
		_tmp2_ = self->priv->sql;
		_tmp3_ = rygel_media_export_sql_factory_make (_tmp2_, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
		rygel_media_export_database_exec (_tmp1_, _tmp3_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp4_ = self->priv->db;
		_tmp5_ = self->priv->sql;
		_tmp6_ = rygel_media_export_sql_factory_make (_tmp5_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
		rygel_media_export_database_exec (_tmp4_, _tmp6_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp7_ = self->priv->db;
		_tmp8_ = self->priv->sql;
		_tmp9_ = rygel_media_export_sql_factory_make (_tmp8_, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
		rygel_media_export_database_exec (_tmp7_, _tmp9_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp10_ = self->priv->db;
		_tmp11_ = self->priv->sql;
		_tmp12_ = rygel_media_export_sql_factory_make (_tmp11_, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
		rygel_media_export_database_exec (_tmp10_, _tmp12_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp13_ = self->priv->db;
		_tmp14_ = self->priv->sql;
		_tmp15_ = rygel_media_export_sql_factory_make (_tmp14_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
		rygel_media_export_database_exec (_tmp13_, _tmp15_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp16_ = self->priv->db;
		_tmp17_ = self->priv->sql;
		_tmp18_ = rygel_media_export_sql_factory_make (_tmp17_, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_REFERENCE);
		rygel_media_export_database_exec (_tmp16_, _tmp18_, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp19_ = self->priv->db;
		rygel_media_export_database_commit (_tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
		_tmp20_ = self->priv->db;
		rygel_media_export_database_analyze (_tmp20_);
		_tmp21_ = uuid_get ();
		_tmp22_ = _tmp21_;
		rygel_media_export_media_cache_save_reset_token (self, _tmp22_);
		_g_free0 (_tmp22_);
		result = TRUE;
		return result;
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		RygelMediaExportDatabase* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = err;
		_tmp24_ = _tmp23_->message;
		g_warning ("rygel-media-export-media-cache.vala:861: Failed to create schema: %s", _tmp24_);
		_tmp25_ = self->priv->db;
		rygel_media_export_database_rollback (_tmp25_);
		_g_error_free0 (err);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


/**
     * Create a new container or item based on a SQL result.
     *
     * The Rygel server discards the object when the browse request is finished,
     * after serializing the result.
     *
     * @param parent The object's parent container.
     * @param statement a SQLite result indicating the container's details.
     */
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
	sqlite3_stmt* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* title;
	sqlite3_stmt* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* object_id;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* uri;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_ = 0;
	RygelMediaObject* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	object = NULL;
	_tmp0_ = statement;
	_tmp1_ = sqlite3_column_text (_tmp0_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
	title = _tmp1_;
	_tmp2_ = statement;
	_tmp3_ = sqlite3_column_text (_tmp2_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	object_id = _tmp3_;
	_tmp4_ = statement;
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
	uri = _tmp5_;
	_tmp6_ = statement;
	_tmp7_ = sqlite3_column_int (_tmp6_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
	switch (_tmp7_) {
		case 0:
		{
			RygelMediaExportObjectFactory* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			RygelMediaExportDBContainer* _tmp12_ = NULL;
			RygelMediaObject* _tmp13_;
			RygelMediaContainer* _tmp14_;
			RygelMediaContainer* container;
			const gchar* _tmp15_;
			RygelMediaContainer* _tmp19_;
			sqlite3_stmt* _tmp20_;
			gint64 _tmp21_ = 0LL;
			RygelMediaContainer* _tmp22_;
			sqlite3_stmt* _tmp23_;
			gint64 _tmp24_ = 0LL;
			_tmp8_ = self->priv->factory;
			_tmp9_ = object_id;
			_tmp10_ = title;
			_tmp11_ = uri;
			_tmp12_ = rygel_media_export_object_factory_get_container (_tmp8_, _tmp9_, _tmp10_, (guint) 0, _tmp11_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp12_;
			_tmp13_ = object;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp13_) : NULL);
			container = _tmp14_;
			_tmp15_ = uri;
			if (_tmp15_ != NULL) {
				RygelMediaContainer* _tmp16_;
				GeeArrayList* _tmp17_;
				const gchar* _tmp18_;
				_tmp16_ = container;
				_tmp17_ = ((RygelMediaObject*) _tmp16_)->uris;
				_tmp18_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_tmp19_ = container;
			_tmp20_ = statement;
			_tmp21_ = sqlite3_column_int64 (_tmp20_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DELETED_CHILD_COUNT);
			_tmp19_->total_deleted_child_count = (gint64) ((guint32) _tmp21_);
			_tmp22_ = container;
			_tmp23_ = statement;
			_tmp24_ = sqlite3_column_int64 (_tmp23_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CONTAINER_UPDATE_ID);
			_tmp22_->update_id = (guint32) ((guint) _tmp24_);
			_g_object_unref0 (container);
			break;
		}
		case 1:
		{
			sqlite3_stmt* _tmp25_;
			const gchar* _tmp26_ = NULL;
			const gchar* upnp_class;
			RygelMediaExportObjectFactory* _tmp27_;
			RygelMediaContainer* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			RygelMediaItem* _tmp32_ = NULL;
			sqlite3_stmt* _tmp33_;
			RygelMediaObject* _tmp34_;
			const gchar* _tmp35_;
			_tmp25_ = statement;
			_tmp26_ = sqlite3_column_text (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
			upnp_class = _tmp26_;
			_tmp27_ = self->priv->factory;
			_tmp28_ = parent;
			_tmp29_ = object_id;
			_tmp30_ = title;
			_tmp31_ = upnp_class;
			_tmp32_ = rygel_media_export_object_factory_get_item (_tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp32_;
			_tmp33_ = statement;
			_tmp34_ = object;
			rygel_media_export_media_cache_fill_item (self, _tmp33_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp34_) : NULL);
			_tmp35_ = uri;
			if (_tmp35_ != NULL) {
				RygelMediaObject* _tmp36_;
				const gchar* _tmp37_;
				_tmp36_ = object;
				_tmp37_ = uri;
				rygel_media_item_add_uri (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp36_) : NULL, _tmp37_);
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp38_ = object;
	if (_tmp38_ != NULL) {
		RygelMediaObject* _tmp39_;
		sqlite3_stmt* _tmp40_;
		gint64 _tmp41_ = 0LL;
		gboolean _tmp42_ = FALSE;
		RygelMediaObject* _tmp43_;
		guint64 _tmp44_;
		guint64 _tmp45_;
		gint64 _tmp46_;
		gboolean _tmp48_;
		RygelMediaObject* _tmp51_;
		sqlite3_stmt* _tmp52_;
		gint64 _tmp53_ = 0LL;
		RygelMediaObject* _tmp54_;
		sqlite3_stmt* _tmp55_;
		const gchar* _tmp56_ = NULL;
		_tmp39_ = object;
		_tmp40_ = statement;
		_tmp41_ = sqlite3_column_int64 (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
		rygel_media_object_set_modified (_tmp39_, (guint64) _tmp41_);
		_tmp43_ = object;
		_tmp44_ = rygel_media_object_get_modified (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = G_MAXINT64;
		if (_tmp45_ == ((guint64) _tmp46_)) {
			RygelMediaObject* _tmp47_;
			_tmp47_ = object;
			_tmp42_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, RYGEL_TYPE_MEDIA_ITEM);
		} else {
			_tmp42_ = FALSE;
		}
		_tmp48_ = _tmp42_;
		if (_tmp48_) {
			RygelMediaObject* _tmp49_;
			RygelMediaObject* _tmp50_;
			_tmp49_ = object;
			rygel_media_object_set_modified (_tmp49_, (guint64) 0);
			_tmp50_ = object;
			rygel_media_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp50_) : NULL, TRUE);
		}
		_tmp51_ = object;
		_tmp52_ = statement;
		_tmp53_ = sqlite3_column_int64 (_tmp52_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_OBJECT_UPDATE_ID);
		rygel_media_object_set_object_update_id (_tmp51_, (guint) _tmp53_);
		_tmp54_ = object;
		_tmp55_ = statement;
		_tmp56_ = sqlite3_column_text (_tmp55_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_REFERENCE_ID);
		rygel_media_object_set_ref_id (_tmp54_, _tmp56_);
	}
	result = object;
	return result;
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	RygelMediaItem* _tmp0_;
	sqlite3_stmt* _tmp1_;
	const gchar* _tmp2_ = NULL;
	RygelMediaItem* _tmp3_;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_ = NULL;
	RygelMediaItem* _tmp6_;
	sqlite3_stmt* _tmp7_;
	const gchar* _tmp8_ = NULL;
	RygelMediaItem* _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint64 _tmp11_ = 0LL;
	RygelMediaItem* _tmp12_;
	sqlite3_stmt* _tmp13_;
	const gchar* _tmp14_ = NULL;
	RygelMediaItem* _tmp15_;
	RygelMediaItem* _tmp49_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = statement;
	_tmp2_ = sqlite3_column_text (_tmp1_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
	rygel_media_item_set_date (_tmp0_, _tmp2_);
	_tmp3_ = item;
	_tmp4_ = statement;
	_tmp5_ = sqlite3_column_text (_tmp4_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
	rygel_media_item_set_mime_type (_tmp3_, _tmp5_);
	_tmp6_ = item;
	_tmp7_ = statement;
	_tmp8_ = sqlite3_column_text (_tmp7_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
	rygel_media_item_set_dlna_profile (_tmp6_, _tmp8_);
	_tmp9_ = item;
	_tmp10_ = statement;
	_tmp11_ = sqlite3_column_int64 (_tmp10_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
	rygel_media_item_set_size (_tmp9_, _tmp11_);
	_tmp12_ = item;
	_tmp13_ = statement;
	_tmp14_ = sqlite3_column_text (_tmp13_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CREATOR);
	rygel_media_item_set_creator (_tmp12_, _tmp14_);
	_tmp15_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaItem* _tmp16_;
		RygelAudioItem* _tmp17_;
		RygelAudioItem* audio_item;
		RygelAudioItem* _tmp18_;
		sqlite3_stmt* _tmp19_;
		gint64 _tmp20_ = 0LL;
		RygelAudioItem* _tmp21_;
		sqlite3_stmt* _tmp22_;
		gint _tmp23_ = 0;
		RygelAudioItem* _tmp24_;
		sqlite3_stmt* _tmp25_;
		gint _tmp26_ = 0;
		RygelAudioItem* _tmp27_;
		sqlite3_stmt* _tmp28_;
		gint _tmp29_ = 0;
		RygelAudioItem* _tmp30_;
		sqlite3_stmt* _tmp31_;
		gint _tmp32_ = 0;
		RygelMediaItem* _tmp33_;
		_tmp16_ = item;
		_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp16_) : NULL);
		audio_item = _tmp17_;
		_tmp18_ = audio_item;
		_tmp19_ = statement;
		_tmp20_ = sqlite3_column_int64 (_tmp19_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
		rygel_audio_item_set_duration (_tmp18_, (glong) _tmp20_);
		_tmp21_ = audio_item;
		_tmp22_ = statement;
		_tmp23_ = sqlite3_column_int (_tmp22_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
		rygel_audio_item_set_bitrate (_tmp21_, _tmp23_);
		_tmp24_ = audio_item;
		_tmp25_ = statement;
		_tmp26_ = sqlite3_column_int (_tmp25_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
		rygel_audio_item_set_sample_freq (_tmp24_, _tmp26_);
		_tmp27_ = audio_item;
		_tmp28_ = statement;
		_tmp29_ = sqlite3_column_int (_tmp28_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
		rygel_audio_item_set_bits_per_sample (_tmp27_, _tmp29_);
		_tmp30_ = audio_item;
		_tmp31_ = statement;
		_tmp32_ = sqlite3_column_int (_tmp31_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
		rygel_audio_item_set_channels (_tmp30_, _tmp32_);
		_tmp33_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaItem* _tmp34_;
			RygelMediaExportMusicItem* _tmp35_;
			RygelMediaExportMusicItem* music_item;
			RygelMediaExportMusicItem* _tmp36_;
			sqlite3_stmt* _tmp37_;
			const gchar* _tmp38_ = NULL;
			RygelMediaExportMusicItem* _tmp39_;
			sqlite3_stmt* _tmp40_;
			const gchar* _tmp41_ = NULL;
			RygelMediaExportMusicItem* _tmp42_;
			sqlite3_stmt* _tmp43_;
			const gchar* _tmp44_ = NULL;
			RygelMediaExportMusicItem* _tmp45_;
			sqlite3_stmt* _tmp46_;
			gint _tmp47_ = 0;
			RygelMediaExportMusicItem* _tmp48_;
			_tmp34_ = item;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp34_) : NULL);
			music_item = _tmp35_;
			_tmp36_ = music_item;
			_tmp37_ = statement;
			_tmp38_ = sqlite3_column_text (_tmp37_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			rygel_music_item_set_artist ((RygelMusicItem*) _tmp36_, _tmp38_);
			_tmp39_ = music_item;
			_tmp40_ = statement;
			_tmp41_ = sqlite3_column_text (_tmp40_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
			rygel_music_item_set_album ((RygelMusicItem*) _tmp39_, _tmp41_);
			_tmp42_ = music_item;
			_tmp43_ = statement;
			_tmp44_ = sqlite3_column_text (_tmp43_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
			rygel_music_item_set_genre ((RygelMusicItem*) _tmp42_, _tmp44_);
			_tmp45_ = music_item;
			_tmp46_ = statement;
			_tmp47_ = sqlite3_column_int (_tmp46_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp45_, _tmp47_);
			_tmp48_ = music_item;
			rygel_music_item_lookup_album_art ((RygelMusicItem*) _tmp48_);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp49_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelMediaItem* _tmp50_;
		RygelVisualItem* _tmp51_;
		RygelVisualItem* visual_item;
		RygelVisualItem* _tmp52_;
		sqlite3_stmt* _tmp53_;
		gint _tmp54_ = 0;
		RygelVisualItem* _tmp55_;
		sqlite3_stmt* _tmp56_;
		gint _tmp57_ = 0;
		RygelVisualItem* _tmp58_;
		sqlite3_stmt* _tmp59_;
		gint _tmp60_ = 0;
		_tmp50_ = item;
		_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp50_) : NULL);
		visual_item = _tmp51_;
		_tmp52_ = visual_item;
		_tmp53_ = statement;
		_tmp54_ = sqlite3_column_int (_tmp53_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
		rygel_visual_item_set_width (_tmp52_, _tmp54_);
		_tmp55_ = visual_item;
		_tmp56_ = statement;
		_tmp57_ = sqlite3_column_int (_tmp56_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
		rygel_visual_item_set_height (_tmp55_, _tmp57_);
		_tmp58_ = visual_item;
		_tmp59_ = statement;
		_tmp60_ = sqlite3_column_int (_tmp59_, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
		rygel_visual_item_set_color_depth (_tmp58_, _tmp60_);
		_g_object_unref0 (visual_item);
	}
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GValueArray* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* filter;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = expression;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = expression;
	_tmp3_ = args;
	_tmp4_ = rygel_media_export_media_cache_search_expression_to_sql (_tmp2_, _tmp3_, &_inner_error_);
	filter = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp5_ = prefix;
	_tmp6_ = filter;
	_tmp7_ = g_strdup_printf (" %s %s", _tmp5_, _tmp6_);
	result = _tmp7_;
	_g_free0 (filter);
	return result;
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		RygelSearchExpression* _tmp3_;
		GValueArray* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp3_ = expression;
		_tmp4_ = args;
		_tmp5_ = rygel_media_export_media_cache_logical_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp3_) : NULL, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp6_;
		return result;
	} else {
		RygelSearchExpression* _tmp7_;
		GValueArray* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp7_ = expression;
		_tmp8_ = args;
		_tmp9_ = rygel_media_export_media_cache_relational_expression_to_sql (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _tmp7_) : NULL, _tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp10_;
		return result;
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	RygelLogicalExpression* _tmp0_;
	gconstpointer _tmp1_;
	GValueArray* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* left_sql_string;
	RygelLogicalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValueArray* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* right_sql_string;
	const gchar* operator_sql_string;
	RygelLogicalExpression* _tmp8_;
	gconstpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = expression;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp2_ = args;
	_tmp3_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp1_, _tmp2_, &_inner_error_);
	left_sql_string = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = expression;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->operand2;
	_tmp6_ = args;
	_tmp7_ = rygel_media_export_media_cache_search_expression_to_sql ((RygelSearchExpression*) _tmp5_, _tmp6_, &_inner_error_);
	right_sql_string = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	operator_sql_string = "OR";
	_tmp8_ = expression;
	_tmp9_ = ((RygelSearchExpression*) _tmp8_)->op;
	if (((RygelLogicalOperator) ((gintptr) _tmp9_)) == RYGEL_LOGICAL_OPERATOR_AND) {
		operator_sql_string = "AND";
	}
	_tmp10_ = left_sql_string;
	_tmp11_ = operator_sql_string;
	_tmp12_ = right_sql_string;
	_tmp13_ = g_strdup_printf ("(%s %s %s)", _tmp10_, _tmp11_, _tmp12_);
	result = _tmp13_;
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (const gchar* operand, gchar** collate, gboolean for_sort, GError** error) {
	gchar* _vala_collate = NULL;
	gchar* result = NULL;
	gchar* column;
	gboolean use_collation;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	gboolean _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("res")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("o.uri");
				_g_free0 (column);
				column = _tmp4_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("res@duration")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("m.duration");
				_g_free0 (column);
				column = _tmp5_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("o.upnp_id");
				_g_free0 (column);
				column = _tmp6_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("o.parent");
				_g_free0 (column);
				column = _tmp7_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("m.class");
				_g_free0 (column);
				column = _tmp8_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("o.title");
				_g_free0 (column);
				column = _tmp9_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:artist")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:author"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("m.author");
				_g_free0 (column);
				column = _tmp10_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("m.creator");
				_g_free0 (column);
				column = _tmp11_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				gboolean _tmp12_;
				_tmp12_ = for_sort;
				if (_tmp12_) {
					gchar* _tmp13_;
					_tmp13_ = g_strdup ("m.date");
					_g_free0 (column);
					column = _tmp13_;
				} else {
					gchar* _tmp14_;
					_tmp14_ = g_strdup ("strftime(\"%Y\", m.date)");
					_g_free0 (column);
					column = _tmp14_;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("m.album");
				_g_free0 (column);
				column = _tmp15_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("dc:genre"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				_tmp16_ = g_strdup ("m.genre");
				_g_free0 (column);
				column = _tmp16_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("upnp:originalTrackNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				_tmp17_ = g_strdup ("m.track");
				_g_free0 (column);
				column = _tmp17_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("rygel:originalVolumeNumber")))) {
		switch (0) {
			default:
			{
				gchar* _tmp18_;
				_tmp18_ = g_strdup ("m.disc");
				_g_free0 (column);
				column = _tmp18_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_;
				_tmp19_ = g_strdup ("o.object_update_id");
				_g_free0 (column);
				column = _tmp19_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp20_;
				_tmp20_ = g_strdup ("o.container_update_id");
				_g_free0 (column);
				column = _tmp20_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* message;
				const gchar* _tmp23_;
				GError* _tmp24_;
				_tmp21_ = operand;
				_tmp22_ = g_strdup_printf ("Unsupported column %s", _tmp21_);
				message = _tmp22_;
				_tmp23_ = message;
				_tmp24_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, _tmp23_);
				_inner_error_ = _tmp24_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	_tmp25_ = use_collation;
	if (_tmp25_) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup ("COLLATE CASEFOLD");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp26_;
	} else {
		gchar* _tmp27_;
		_tmp27_ = g_strdup ("");
		_g_free0 (_vala_collate);
		_vala_collate = _tmp27_;
	}
	result = column;
	if (collate) {
		*collate = _vala_collate;
	} else {
		_g_free0 (_vala_collate);
	}
	return result;
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v;
	gchar* collate;
	RygelRelationalExpression* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* column;
	RygelMediaExportSqlOperator* operator = NULL;
	RygelRelationalExpression* _tmp4_;
	gconstpointer _tmp5_;
	GValue* _tmp40_;
	RygelMediaExportSqlOperator* _tmp44_;
	gchar* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp0_ = exp;
	_tmp1_ = ((RygelSearchExpression*) _tmp0_)->operand1;
	_tmp3_ = rygel_media_export_media_cache_map_operand_to_column ((const gchar*) _tmp1_, &_tmp2_, FALSE, &_inner_error_);
	_g_free0 (collate);
	collate = _tmp2_;
	column = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	_tmp4_ = exp;
	_tmp5_ = ((RygelSearchExpression*) _tmp4_)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			RygelRelationalExpression* _tmp6_;
			gconstpointer _tmp7_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			_tmp6_ = exp;
			_tmp7_ = ((RygelSearchExpression*) _tmp6_)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp7_, "true") == 0) {
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp8_;
			} else {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp9_;
			}
			_tmp10_ = sql_function;
			_tmp11_ = column;
			_tmp12_ = column;
			_tmp13_ = g_strdup_printf (_tmp10_, _tmp11_, _tmp12_);
			result = _tmp13_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			RygelRelationalExpression* _tmp14_;
			gconstpointer _tmp15_;
			GValue* _tmp16_ = NULL;
			RygelRelationalExpression* _tmp17_;
			gconstpointer _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			RygelMediaExportSqlOperator* _tmp21_;
			_tmp14_ = exp;
			_tmp15_ = ((RygelSearchExpression*) _tmp14_)->operand2;
			_tmp16_ = g_new0 (GValue, 1);
			g_value_init (_tmp16_, G_TYPE_STRING);
			g_value_set_string (_tmp16_, (const gchar*) _tmp15_);
			__vala_GValue_free0 (v);
			v = _tmp16_;
			_tmp17_ = exp;
			_tmp18_ = ((RygelSearchExpression*) _tmp17_)->op;
			_tmp19_ = column;
			_tmp20_ = collate;
			_tmp21_ = rygel_media_export_sql_operator_new_from_search_criteria_op ((GUPnPSearchCriteriaOp) ((gintptr) _tmp18_), _tmp19_, _tmp20_);
			_g_object_unref0 (operator);
			operator = _tmp21_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp22_;
			RygelMediaExportSqlFunction* _tmp23_;
			RygelRelationalExpression* _tmp24_;
			gconstpointer _tmp25_;
			GValue* _tmp26_ = NULL;
			_tmp22_ = column;
			_tmp23_ = rygel_media_export_sql_function_new ("contains", _tmp22_);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp23_;
			_tmp24_ = exp;
			_tmp25_ = ((RygelSearchExpression*) _tmp24_)->operand2;
			_tmp26_ = g_new0 (GValue, 1);
			g_value_init (_tmp26_, G_TYPE_STRING);
			g_value_set_string (_tmp26_, (const gchar*) _tmp25_);
			__vala_GValue_free0 (v);
			v = _tmp26_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			const gchar* _tmp27_;
			RygelMediaExportSqlFunction* _tmp28_;
			RygelRelationalExpression* _tmp29_;
			gconstpointer _tmp30_;
			GValue* _tmp31_ = NULL;
			_tmp27_ = column;
			_tmp28_ = rygel_media_export_sql_function_new ("NOT contains", _tmp27_);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp28_;
			_tmp29_ = exp;
			_tmp30_ = ((RygelSearchExpression*) _tmp29_)->operand2;
			_tmp31_ = g_new0 (GValue, 1);
			g_value_init (_tmp31_, G_TYPE_STRING);
			g_value_set_string (_tmp31_, (const gchar*) _tmp30_);
			__vala_GValue_free0 (v);
			v = _tmp31_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp32_;
			RygelMediaExportSqlOperator* _tmp33_;
			RygelRelationalExpression* _tmp34_;
			gconstpointer _tmp35_;
			gchar* _tmp36_ = NULL;
			GValue* _tmp37_ = NULL;
			_tmp32_ = column;
			_tmp33_ = rygel_media_export_sql_operator_new ("LIKE", _tmp32_, "");
			_g_object_unref0 (operator);
			operator = _tmp33_;
			_tmp34_ = exp;
			_tmp35_ = ((RygelSearchExpression*) _tmp34_)->operand2;
			_tmp36_ = g_strdup_printf ("%s%%", (const gchar*) _tmp35_);
			_tmp37_ = g_new0 (GValue, 1);
			g_value_init (_tmp37_, G_TYPE_STRING);
			g_value_take_string (_tmp37_, _tmp36_);
			__vala_GValue_free0 (v);
			v = _tmp37_;
			break;
		}
		default:
		{
			RygelRelationalExpression* _tmp38_;
			gconstpointer _tmp39_;
			_tmp38_ = exp;
			_tmp39_ = ((RygelSearchExpression*) _tmp38_)->op;
			g_warning ("rygel-media-export-media-cache.vala:1145: Unsupported op %d", (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp39_)));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	_tmp40_ = v;
	if (_tmp40_ != NULL) {
		GValueArray* _tmp41_;
		GValue* _tmp42_;
		GValue _tmp43_;
		_tmp41_ = args;
		_tmp42_ = v;
		_tmp43_ = *_tmp42_;
		g_value_array_append (_tmp41_, &_tmp43_);
	}
	_tmp44_ = operator;
	_tmp45_ = rygel_media_export_sql_operator_to_string (_tmp44_);
	result = _tmp45_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}


static RygelMediaExportDatabaseCursor* rygel_media_export_media_cache_exec_cursor (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	RygelMediaExportDatabaseCursor* result = NULL;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	RygelMediaExportDatabaseCursor* _tmp5_ = NULL;
	RygelMediaExportDatabaseCursor* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = self->priv->sql;
	_tmp2_ = id;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = rygel_media_export_database_exec_cursor (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp6_;
	return result;
}


static gint rygel_media_export_media_cache_query_value (RygelMediaExportMediaCache* self, RygelMediaExportSQLString id, GValue* values, int values_length1, GError** error) {
	gint result = 0;
	RygelMediaExportDatabase* _tmp0_;
	RygelMediaExportSQLFactory* _tmp1_;
	RygelMediaExportSQLString _tmp2_;
	const gchar* _tmp3_ = NULL;
	GValue* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->db;
	_tmp1_ = self->priv->sql;
	_tmp2_ = id;
	_tmp3_ = rygel_media_export_sql_factory_make (_tmp1_, _tmp2_);
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = rygel_media_export_database_query_value (_tmp0_, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp6_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* rygel_media_export_media_cache_translate_sort_criteria (const gchar* sort_criteria, gchar** extra_columns, gint* column_count) {
	gchar* _vala_extra_columns = NULL;
	gint _vala_column_count = 0;
	gchar* result = NULL;
	gchar* collate = NULL;
	GString* _tmp0_;
	GString* builder;
	GString* _tmp1_;
	GString* column_builder;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** fields;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	GString* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (sort_criteria != NULL, NULL);
	_tmp0_ = g_string_new ("ORDER BY ");
	builder = _tmp0_;
	_tmp1_ = g_string_new ("");
	column_builder = _tmp1_;
	_tmp2_ = sort_criteria;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
	fields = _tmp4_;
	fields_length1 = _vala_array_length (_tmp3_);
	_fields_size_ = fields_length1;
	_tmp5_ = fields;
	_tmp5__length1 = fields_length1;
	_vala_column_count = _tmp5__length1;
	_tmp6_ = fields;
	_tmp6__length1 = fields_length1;
	{
		gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp6_;
		field_collection_length1 = _tmp6__length1;
		for (field_it = 0; field_it < _tmp6__length1; field_it = field_it + 1) {
			const gchar* field = NULL;
			field = field_collection[field_it];
			{
				{
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					gint _tmp9_;
					gint _tmp10_;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_;
					gchar* column;
					const gchar* _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					GString* _tmp20_;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_;
					gchar _tmp23_ = '\0';
					GString* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					GString* _tmp28_;
					const gchar* _tmp29_;
					_tmp7_ = field;
					_tmp8_ = field;
					_tmp9_ = strlen (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = string_slice (_tmp7_, (glong) 1, (glong) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp14_ = rygel_media_export_media_cache_map_operand_to_column (_tmp12_, &_tmp13_, TRUE, &_inner_error_);
					_g_free0 (collate);
					collate = _tmp13_;
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp12_);
					column = _tmp15_;
					if (_inner_error_ != NULL) {
						goto __catch20_g_error;
					}
					_tmp16_ = field;
					_tmp17_ = fields;
					_tmp17__length1 = fields_length1;
					_tmp18_ = _tmp17_[0];
					if (g_strcmp0 (_tmp16_, _tmp18_) != 0) {
						GString* _tmp19_;
						_tmp19_ = builder;
						g_string_append (_tmp19_, ",");
					}
					_tmp20_ = column_builder;
					g_string_append (_tmp20_, ",");
					_tmp22_ = field;
					_tmp23_ = string_get (_tmp22_, (glong) 0);
					if (_tmp23_ == '-') {
						_tmp21_ = "DESC";
					} else {
						_tmp21_ = "ASC";
					}
					_tmp24_ = builder;
					_tmp25_ = column;
					_tmp26_ = collate;
					_tmp27_ = _tmp21_;
					g_string_append_printf (_tmp24_, "%s %s %s ", _tmp25_, _tmp26_, _tmp27_);
					_tmp28_ = column_builder;
					_tmp29_ = column;
					g_string_append (_tmp28_, _tmp29_);
					_g_free0 (column);
				}
				goto __finally20;
				__catch20_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp30_;
					_error_ = _inner_error_;
					_inner_error_ = NULL;
					_tmp30_ = field;
					g_warning ("rygel-media-export-media-cache.vala:1193: Skipping unsupported field: " \
"%s", _tmp30_);
					_g_error_free0 (_error_);
				}
				__finally20:
				if (_inner_error_ != NULL) {
					fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
					_g_string_free0 (column_builder);
					_g_string_free0 (builder);
					_g_free0 (collate);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	_tmp31_ = column_builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	_g_free0 (_vala_extra_columns);
	_vala_extra_columns = _tmp33_;
	_tmp34_ = builder;
	_tmp35_ = _tmp34_->str;
	_tmp36_ = g_strdup (_tmp35_);
	result = _tmp36_;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (column_builder);
	_g_string_free0 (builder);
	_g_free0 (collate);
	if (extra_columns) {
		*extra_columns = _vala_extra_columns;
	} else {
		_g_free0 (_vala_extra_columns);
	}
	if (column_count) {
		*column_count = _vala_column_count;
	}
	return result;
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	_g_object_unref0 (self->priv->exists_cache);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


/**
 * Persistent storage of media objects.
 *
 * MediaExportDB is a sqlite3 backed persistent storage of media objects.
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



