/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CSelectableRowList.cxx
    \author Romain BONDUE
    \date 28/07/2005 */
#include <cstdlib> // atoi()
#include <cstring> // memset()

#include "CSelectableRowList.h"
#include "GtkGUI.h"



nsGUI::CSelectableRowList::CSelectableRowList (unsigned NbColumn,
                                const ::GType* TabType, const char** TabTitle,
                                CGtkGUI* pUI, GUICallBack pGUICB) throw()
    : m_pListStore (GTK_LIST_STORE (::gtk_list_store_newv (NbColumn,
                                            const_cast< ::GType*> (TabType)))),
      m_pListView (GTK_TREE_VIEW (::gtk_tree_view_new_with_model
                                            (GTK_TREE_MODEL (m_pListStore)))),
      m_pScrollWindow (::gtk_scrolled_window_new (0, 0)),
      m_pButtonRenderer (GTK_CELL_RENDERER_TOGGLE
                                        (::gtk_cell_renderer_toggle_new())),
      m_SelectedRow (None), m_pUI (pUI), m_pGUICallBack (pGUICB)
{
         // Add the radio buttons column :
    ::gtk_cell_renderer_toggle_set_radio (GTK_CELL_RENDERER_TOGGLE
                                                    (m_pButtonRenderer), true);
    ::gtk_tree_view_append_column (m_pListView,
                                   ::gtk_tree_view_column_new_with_attributes
                                     (0, GTK_CELL_RENDERER (m_pButtonRenderer),
                                      "active", 0,
                                      reinterpret_cast<void*> (0)));
        // Set the signals :
    ::gtk_tree_selection_set_select_function (
                                ::gtk_tree_view_get_selection (m_pListView),
                                reinterpret_cast< ::GtkTreeSelectionFunc>
                                                    (_RowSelectedCallBack),
                                this, 0);
    ::g_signal_connect (G_OBJECT (m_pButtonRenderer), "toggled",
                        G_CALLBACK (ToggledCallBack), this);
    ::g_signal_connect (G_OBJECT (m_pListView), "row-activated",
                        G_CALLBACK (DoubleClickCallBack), this);

        // Now the user data columns :
    GtkCellRenderer* const pRenderer (::gtk_cell_renderer_text_new());
        // I could easily make the column sortable, but it's a bit pointless.
    for (unsigned i (1) ; i < NbColumn ; ++i)
        ::gtk_tree_view_append_column (m_pListView,
                ::gtk_tree_view_column_new_with_attributes (TabTitle [i],
                                                            pRenderer, "text",
                                                            i,
                                                reinterpret_cast<void*> (0)));

    ::gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (m_pScrollWindow),
                                      GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
    ::gtk_container_add (GTK_CONTAINER (m_pScrollWindow),
                         GTK_WIDGET (m_pListView));
    ::gtk_scrolled_window_set_shadow_type
                        (GTK_SCROLLED_WINDOW (m_pScrollWindow), GTK_SHADOW_IN);

} // CSelectableRowList()


void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         bool UserVal) throw()
{
    ::GValue Value;
    memset (&Value, 0, sizeof (::GValue));
    ::g_value_init (&Value, G_TYPE_BOOLEAN);
    ::g_value_set_boolean (&Value, UserVal);
    SetData (Row, Column, &Value);

} // SetData()


void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         unsigned UserVal) throw()
{
    ::GValue Value;
    memset (&Value, 0, sizeof (::GValue));
    ::g_value_init (&Value, G_TYPE_UINT);
    ::g_value_set_uint (&Value, UserVal);
    SetData (Row, Column, &Value);

} // SetData()


void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         int UserVal) throw()
{
    ::GValue Value;
    memset (&Value, 0, sizeof (::GValue));
    ::g_value_init (&Value, G_TYPE_INT);
    ::g_value_set_int (&Value, UserVal);
    SetData (Row, Column, &Value);

} // SetData()

    
void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         float UserVal) throw()
{
    ::GValue Value;
    memset (&Value, 0, sizeof (::GValue));
    ::g_value_init (&Value, G_TYPE_FLOAT);
    ::g_value_set_float (&Value, UserVal);
    SetData (Row, Column, &Value);

} // SetData()

    
void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         const std::string& UserVal) throw()
{
    ::GValue Value;
    memset (&Value, 0, sizeof (::GValue));
    ::g_value_init (&Value, G_TYPE_STRING);
    ::g_value_set_string (&Value, UserVal.c_str());
    SetData (Row, Column, &Value);

} // SetData()

    
void nsGUI::CSelectableRowList::SetData (unsigned Row, unsigned Column,
                                         ::GValue* pValue) throw()
{
    if (Row >= m_IterVec.size()) // Make the row if needed.
    {
        Row = m_IterVec.size();
        m_IterVec.push_back (::GtkTreeIter());
        ::gtk_list_store_insert (m_pListStore, &m_IterVec.back(), Row);
    }
    ::gtk_list_store_set_value (m_pListStore, &m_IterVec [Row], Column,
                                pValue);

} // SetData()


void nsGUI::CSelectableRowList::DeleteRow (unsigned Row) throw()
{
    if (int (Row) == m_SelectedRow)
        ::gtk_tree_selection_unselect_iter
                                (::gtk_tree_view_get_selection (m_pListView),
                                 &m_IterVec [Row]);
    ::gtk_list_store_remove (m_pListStore, &m_IterVec [Row]);
    m_IterVec.erase (m_IterVec.begin() + Row);

} // DeleteRow()


void nsGUI::CSelectableRowList::DoubleClickCallBack (::GtkTreeView*,
                                                     ::GtkTreePath*,
                                                     ::GtkTreeViewColumn*,
                                                     CSelectableRowList* This)
                                                                        throw()
{       // Trigger the row only if the button is not already selected.
    if (!::gtk_cell_renderer_toggle_get_active (This->m_pButtonRenderer))
        This->RowTriggered();

} // DoubleClickCallBack()


void nsGUI::CSelectableRowList::ToggledCallBack
                                        (::GtkCellRendererToggle* pRenderer,
                                         const char* Path,
                                         CSelectableRowList* This) throw()
{       // Trigger the row only if the button is not already selected.
    if (!::gtk_cell_renderer_toggle_get_active (pRenderer))
    {
        ::gtk_tree_selection_select_iter (::gtk_tree_view_get_selection
                                          (This->m_pListView),
                                           &This->m_IterVec [atoi(Path)]);
        This->RowTriggered();
    }

} // ToggledCallBack()


bool nsGUI::CSelectableRowList::_RowSelectedCallBack (::GtkTreeSelection*,
                                                      ::GtkTreeModel*,
                                                      ::GtkTreePath* pTreePath,
                                                      bool IsCurrentlySelected,
                                                      CSelectableRowList* This)
                                                                        throw()
{
    const int Row (::gtk_tree_path_get_indices (pTreePath) [0]);
    if (IsCurrentlySelected)
    {
        This->m_SelectedRow = None;
        This->RowUnselectedCallBack();
    }   // We need this check because this callback is called twice on select.
    else if (Row != This->m_SelectedRow)
    {
        This->m_SelectedRow = Row;
        This->RowSelectedCallBack();
    }
    return true; // The selection is accepted.

} // RowSelectedCallBack()


void nsGUI::CSelectableRowList::RowTriggered () throw()
{
    if (m_pUI && m_pGUICallBack && (m_pUI->*m_pGUICallBack) (m_SelectedRow))
        for (unsigned i (0) ; i < m_IterVec.size() ; ++i)
            SetData (i, 0, int (i) == m_SelectedRow);

} // RowTriggered()
