% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeManipulation.R
\name{allTrees}
\alias{allTrees}
\title{Compute all trees topologies.}
\usage{
allTrees(n, rooted = FALSE, tip.label = NULL)
}
\arguments{
\item{n}{Number of tips (<=10).}

\item{rooted}{Rooted or unrooted trees (default: rooted).}

\item{tip.label}{Tip labels.}
}
\value{
an object of class \code{multiPhylo}.
}
\description{
\code{allTrees} computes all tree topologies for rooted or unrooted trees
with up to 10 tips. \code{allTrees} returns bifurcating trees.
}
\examples{

trees <- allTrees(5)
par(mfrow = c(3,5))
for(i in 1:15)plot(trees[[i]])

}
\seealso{
\code{\link[ape]{rtree}}, \code{\link{nni}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
