% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badge.R
\name{badge}
\alias{badge}
\title{Embed a lifecycle badge in documentation}
\usage{
badge(stage)
}
\arguments{
\item{stage}{A lifecycle stage as a string, one of:
\code{"experimental"}, \code{"maturing"}, \code{"stable"}, \code{"questioning"},
\code{"archived"}, \code{"soft-deprecated"}, \code{"deprecated"}, \code{"defunct"}.}
}
\value{
An \code{Rd} expression describing the lifecycle stage.
}
\description{
Call \code{usethis::use_lifecycle()} to import the badges in your
package. Then use the \code{lifecycle} Rd macro to insert a lifecycle
badges in your documentation, with the relevant lifecycle stage as
argument:\preformatted{\lifecycle{experimental}
\lifecycle{soft-deprecated}
}

The badge is displayed as image in the HTML version of the
documentation and as text otherwise.

If the deprecated feature is a function, a good place for this
badge is at the top of the topic description (if the deprecated
function is documented with other functions, it might be a good
idea to extract it in its own documentation topic to prevent
confusion). If it is an argument, you can put the badge in the
argument description.
}
\details{
The \code{lifecycle{}} macro is made available by adding this field to
DESCRIPTION (this is done automatically by
\code{usethis::use_lifecycle()}):\preformatted{RdMacros: lifecycle
}

The macro expands to this expression:\preformatted{\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
}
}
\section{Badges}{

\itemize{
\item \verb{\lifecycle{experimental}}: \lifecycle{experimental}
\item \verb{\lifecycle{maturing}}: \lifecycle{maturing}
\item \verb{\lifecycle{stable}}: \lifecycle{stable}
\item \verb{\lifecycle{questioning}}: \lifecycle{questioning}
\item \verb{\lifecycle{archived}}: \lifecycle{archived}
\item \verb{\lifecycle{soft-deprecated}}: \lifecycle{soft-deprecated}
\item \verb{\lifecycle{deprecated}}: \lifecycle{deprecated}
\item \verb{\lifecycle{defunct}}: \lifecycle{defunct}
}
}

