% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{startParams}
\alias{startParams}
\title{Change starting parameters, either by residual method or by user input (start)}
\usage{
startParams(
  parameters,
  formula,
  ziformula,
  dispformula,
  fr,
  yobs,
  weights,
  size = NULL,
  Xdisp = NULL,
  XdispS = NULL,
  family,
  condReStruc,
  start = NULL,
  sparseX = NULL,
  start_method = list(method = NULL, jitter.sd = 0)
)
}
\arguments{
\item{formula}{current formula, containing both fixed & random effects}

\item{ziformula}{a \emph{one-sided} (i.e., no response variable) formula for zero-inflation combining fixed and random effects: the default \code{~0} specifies no zero-inflation. Specifying \code{~.} sets the zero-inflation formula identical to the right-hand side of \code{formula} (i.e., the conditional effects formula); terms can also be added or subtracted. \strong{When using \code{~.} as the zero-inflation formula in models where the conditional effects formula contains an offset term, the offset term will automatically be dropped}. The zero-inflation model uses a logit link.}

\item{dispformula}{a \emph{one-sided} formula for dispersion combining fixed and random effects: the default \code{~1} specifies the standard dispersion given any family. The argument is ignored for families that do not have a dispersion parameter. For an explanation of the dispersion parameter for each family, see \code{\link{sigma}}. The dispersion model uses a log link. In Gaussian mixed models, \code{dispformula=~0} fixes the residual variance to be 0 (actually a small non-zero value), forcing variance into the random effects. The precise value can be controlled via \code{control=glmmTMBControl(zero_dispval=...)}; the default value is \code{sqrt(.Machine$double.eps)}.}

\item{fr}{model frame}

\item{yobs}{observed y}

\item{weights}{model weights (for binomial-type models, used as size/number of trials)}

\item{size}{number of trials in binomial and betabinomial families}

\item{family}{family object}

\item{start}{starting values, expressed as a list with possible components \code{beta}, \code{betazi}, \code{betadisp} (fixed-effect parameters for conditional, zero-inflation, dispersion models); \code{b}, \code{bzi} (conditional modes for conditional and zero-inflation models); \code{theta}, \code{thetazi} (random-effect parameters, on the standard deviation/Cholesky scale, for conditional and z-i models); \code{psi} (extra family parameters, e.g., shape for Tweedie models).}

\item{sparseX}{see \code{\link{glmmTMB}}}

\item{start_method}{Options to initialise the starting values for rr parameters; jitter.sd adds variation to the starting values of latent variables when start = "res".}
}
\description{
Change starting parameters, either by residual method or by user input (start)
}
\keyword{internal}
