% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edge_attrs_ws.R
\name{get_edge_attrs_ws}
\alias{get_edge_attrs_ws}
\title{Get edge attribute values from a selection of edges}
\usage{
get_edge_attrs_ws(graph, edge_attr)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_attr}{the name of the attribute for which to get values.}
}
\value{
A named vector of edge attribute values for the attribute given by
\code{edge_attr} by edge.
}
\description{
From a graph object of class \code{dgr_graph}, get edge attribute values for one
or more edges.

This function makes use of an active selection of edges (and the function
ending with \verb{_ws} hints at this).

Selections of edges can be performed using the following selection
(\verb{select_*()}) functions: \code{\link[=select_edges]{select_edges()}}, \code{\link[=select_last_edges_created]{select_last_edges_created()}},
\code{\link[=select_edges_by_edge_id]{select_edges_by_edge_id()}}, or \code{\link[=select_edges_by_node_id]{select_edges_by_node_id()}}.

Selections of edges can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out_edge]{trav_out_edge()}}, \code{\link[=trav_in_edge]{trav_in_edge()}},
\code{\link[=trav_both_edge]{trav_both_edge()}}, or \code{\link[=trav_reverse_edge]{trav_reverse_edge()}}.
}
\examples{
# Create a simple graph where
# edges have an edge attribute
# named `value`
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 4) \%>\%
  {
    edges <-
      create_edge_df(
        from = c(1, 2, 1, 4),
          to = c(2, 3, 4, 3),
         rel = "rel")
    add_edge_df(
      graph = .,
      edge_df = edges)
  } \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 1.6,
    from = 1,
      to = 2) \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 4.3,
    from = 1,
      to = 4) \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 2.9,
    from = 2,
      to = 3) \%>\%
  set_edge_attrs(
    edge_attr = value,
    values = 8.4,
    from = 4,
      to = 3)

# Select the edges defined as
# `1`->`3` and `2`->`3`
graph <-
  graph \%>\%
  select_edges(
    from = c(1, 2),
    to = c(2, 3))

# Get the edge attribute values
# for the `value` attribute, limited
# to the current edge selection
graph \%>\%
  get_edge_attrs_ws(
    edge_attr = value)

}
