% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary_functions}
\alias{summary_functions}
\alias{continuous_summary_fns}
\title{Summary Functions}
\usage{
continuous_summary_fns(
  summaries = c("N", "mean", "sd", "median", "p25", "p75", "min", "max"),
  other_stats = NULL
)
}
\arguments{
\item{summaries}{(\code{character})\cr
a character vector of results to include in output. Select one or more from
'N', 'mean', 'sd', 'median', 'p25', 'p75', 'min', 'max'.}

\item{other_stats}{(named \code{list})\cr
named list of other statistic functions to supplement the pre-programmed functions.}
}
\value{
named list of summary statistics
}
\description{
\itemize{
\item \code{continuous_summary_fns()} returns a named list of summary functions
for continuous variables. Some functions include slight modifications to
their base equivalents. For example, the \code{min()} and \code{max()} functions
return \code{NA} instead of \code{Inf} when an empty vector is passed.
Statistics \code{"p25"} and \code{"p75"} are calculated with \code{quantile(type = 2)},
which matches
\href{https://psiaims.github.io/CAMIS/Comp/r-sas-summary-stats.html}{SAS's default value}.
}
}
\examples{
# continuous variable summaries
ard_continuous(
  ADSL,
  variables = "AGE",
  statistic = ~ continuous_summary_fns(c("N", "median"))
)
}
