# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iothubprovisioningservices import IotDpsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIotDpsIotDpsResourceOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IotDpsClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_get_operation_result(self, resource_group):
        response = self.client.iot_dps_resource.get_operation_result(
            operation_id="str",
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            asyncinfo="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_get(self, resource_group):
        response = self.client.iot_dps_resource.get(
            provisioning_service_name="str",
            resource_group_name=resource_group.name,
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_begin_create_or_update(self, resource_group):
        response = self.client.iot_dps_resource.begin_create_or_update(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            iot_dps_description={
                "location": "str",
                "properties": {
                    "allocationPolicy": "str",
                    "authorizationPolicies": [
                        {"keyName": "str", "rights": "str", "primaryKey": "str", "secondaryKey": "str"}
                    ],
                    "deviceProvisioningHostName": "str",
                    "deviceRegistryNamespace": {
                        "authenticationType": "str",
                        "resourceId": "str",
                        "selectedUserAssignedIdentityResourceId": "str",
                    },
                    "enableDataResidency": bool,
                    "idScope": "str",
                    "iotHubs": [
                        {
                            "connectionString": "str",
                            "location": "str",
                            "allocationWeight": 0,
                            "applyAllocationPolicy": bool,
                            "name": "str",
                        }
                    ],
                    "ipFilterRules": [{"action": "str", "filterName": "str", "ipMask": "str", "target": "str"}],
                    "portalOperationsHostName": "str",
                    "privateEndpointConnections": [
                        {
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "description": "str",
                                    "status": "str",
                                    "actionsRequired": "str",
                                },
                                "privateEndpoint": {"id": "str"},
                            },
                            "id": "str",
                            "name": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "serviceOperationsHostName": "str",
                    "state": "str",
                },
                "sku": {"capacity": 0, "name": "str", "tier": "str"},
                "etag": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "resourcegroup": "str",
                "subscriptionid": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_begin_update(self, resource_group):
        response = self.client.iot_dps_resource.begin_update(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            provisioning_service_tags={"tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_begin_delete(self, resource_group):
        response = self.client.iot_dps_resource.begin_delete(
            provisioning_service_name="str",
            resource_group_name=resource_group.name,
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_by_resource_group(self, resource_group):
        response = self.client.iot_dps_resource.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_by_subscription(self, resource_group):
        response = self.client.iot_dps_resource.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_valid_skus(self, resource_group):
        response = self.client.iot_dps_resource.list_valid_skus(
            provisioning_service_name="str",
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_keys(self, resource_group):
        response = self.client.iot_dps_resource.list_keys(
            provisioning_service_name="str",
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_keys_for_key_name(self, resource_group):
        response = self.client.iot_dps_resource.list_keys_for_key_name(
            provisioning_service_name="str",
            key_name="str",
            resource_group_name=resource_group.name,
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_get_private_link_resources(self, resource_group):
        response = self.client.iot_dps_resource.get_private_link_resources(
            resource_group_name=resource_group.name,
            resource_name="str",
            group_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_private_link_resources(self, resource_group):
        response = self.client.iot_dps_resource.list_private_link_resources(
            resource_group_name=resource_group.name,
            resource_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_get_private_endpoint_connection(self, resource_group):
        response = self.client.iot_dps_resource.get_private_endpoint_connection(
            resource_group_name=resource_group.name,
            resource_name="str",
            private_endpoint_connection_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_begin_create_or_update_private_endpoint_connection(self, resource_group):
        response = self.client.iot_dps_resource.begin_create_or_update_private_endpoint_connection(
            resource_group_name=resource_group.name,
            resource_name="str",
            private_endpoint_connection_name="str",
            private_endpoint_connection={
                "properties": {
                    "privateLinkServiceConnectionState": {
                        "description": "str",
                        "status": "str",
                        "actionsRequired": "str",
                    },
                    "privateEndpoint": {"id": "str"},
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_begin_delete_private_endpoint_connection(self, resource_group):
        response = self.client.iot_dps_resource.begin_delete_private_endpoint_connection(
            resource_group_name=resource_group.name,
            resource_name="str",
            private_endpoint_connection_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_list_private_endpoint_connections(self, resource_group):
        response = self.client.iot_dps_resource.list_private_endpoint_connections(
            resource_group_name=resource_group.name,
            resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_iot_dps_resource_check_provisioning_service_name_availability(self, resource_group):
        response = self.client.iot_dps_resource.check_provisioning_service_name_availability(
            arguments={"name": "str"},
        )

        # please add some check logic here by yourself
        # ...
