#!/usr/bin/perl
#
# Generate the errcodes.h header from errcodes.txt
# Copyright (c) 2000-2025, PostgreSQL Global Development Group

use strict;
use warnings FATAL => 'all';
use Getopt::Long;

my $outfile = '';

GetOptions('outfile=s' => \$outfile) or die "$0: wrong arguments";

open my $errcodes, '<', $ARGV[0]
  or die "$0: could not open input file '$ARGV[0]': $!\n";

my $outfh;
if ($outfile)
{
	open $outfh, '>', $outfile
	  or die "$0: could not open output file '$outfile': $!\n";
}
else
{
	$outfh = *STDOUT;
}

print $outfh
  "/* autogenerated from src/backend/utils/errcodes.txt, do not edit */\n";
print $outfh "/* there is deliberately not an #ifndef ERRCODES_H here */\n";


while (<$errcodes>)
{
	chomp;

	# Skip comments
	next if /^#/;
	next if /^\s*$/;

	# Emit a comment for each section header
	if (/^Section:(.*)/)
	{
		my $header = $1;
		$header =~ s/^\s+//;
		print $outfh "\n/* $header */\n";
		next;
	}

	die "unable to parse errcodes.txt"
	  unless /^([^\s]{5})\s+[EWS]\s+([^\s]+)/;

	(my $sqlstate, my $errcode_macro) = ($1, $2);

	# Split the sqlstate letters
	$sqlstate = join ",", split "", $sqlstate;

	# And quote them
	$sqlstate =~ s/([^,])/'$1'/g;

	print $outfh "#define $errcode_macro MAKE_SQLSTATE($sqlstate)\n";
}

close $errcodes;
close $outfh if ($outfile);
