#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2002-2006  Donald N. Allingham
# Copyright (C) 2011-2013  Tim G L Lyons
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, see <https://www.gnu.org/licenses/>.
#

# -------------------------------------------------------------------------
#
# Standard Python modules
#
# -------------------------------------------------------------------------
from ....const import GRAMPS_LOCALE as glocale

_ = glocale.translation.gettext

# -------------------------------------------------------------------------
#
# Gramps modules
#
# -------------------------------------------------------------------------
from .._hasgrampsid import HasGrampsId


# -------------------------------------------------------------------------
#
# Typing modules
#
# -------------------------------------------------------------------------
from ....lib import Citation
from ....db import Database


# -------------------------------------------------------------------------
#
# HasSourceIdOf
#
# -------------------------------------------------------------------------
class HasSourceIdOf(HasGrampsId):
    """Rule that checks for a citation with a source which has a specific
    Gramps ID"""

    name = _("Citation with Source <Id>")
    description = _("Matches a citation with a source with a specified Gramps " "ID")
    category = _("Source filters")

    def apply_to_one(self, dbase: Database, citation: Citation) -> bool:  # type: ignore[override]
        source = dbase.get_source_from_handle(citation.source_handle)
        return HasGrampsId.apply_to_one(self, dbase, source)  # type: ignore[override]
