/*************************************************************************
**
**    This file is part of the 'forwords' educational programm.
**    Copyright (C) 2024  Alexander Fomin
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <https://www.gnu.org/licenses/>.
**
**    Contact: fomin_alex@yahoo.com
**
**************************************************************************/

#ifndef DLGTEST3_H
#define DLGTEST3_H

#include <QDialog>
#include <QJsonObject>

namespace Ui {
class dlgTest3;
}

class dlgTest3 : public QDialog
{
    Q_OBJECT

public:
    explicit dlgTest3(QWidget *parent = nullptr);
    ~dlgTest3();
    void    TestStart(QList<QStringList> *lsl);
    void    GetUiText(QJsonObject *uitext);
    void    SetUiText(QJsonObject *uitext);

private slots:
    void on_leAnswer_editingFinished();
    void on_pbOk_clicked();
    void on_pbExit_clicked();

private:
    Ui::dlgTest3 *ui;
    void            Init();
    void            check();
    QList<QStringList>  *lTopicData;
    int                 vSucceedTrigger;  //  sucssesful trigger
    int                 vTotalEfforts;    //  total number of attempts
    int                 vSucceedEfforts;   // number of right attempts
    int                 vDictRandVal;     //  a random value for test dim
    QList<int>          aDictIndex;//         array of indexes

    //Strings for translation
    QString             sResult;
    QString             sResultComplete;
    QString             sResultLeft;
    QString             sPrompt;
};

#endif // DLGTEST3_H
