/***************************************************************************
*   Copyright (C) 2006 by Andreas Pakulat                                 *
*   apaku@gmx.de                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "createscopedlg.h"

#include <klineedit.h>
#include <kurlrequester.h>
#include <tqcheckbox.h>
#include <tdefile.h>
#include <kcombobox.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <tdefiledialog.h>
#include <kurlcompletion.h>

#include "urlutil.h"
#include "qmakescopeitem.h"
#include "scope.h"
#include "trollprojectwidget.h"

CreateScopeDlg::CreateScopeDlg( QMakeScopeItem* item, TQWidget* parent, const char* name, bool modal, WFlags fl )
        : CreateScopeDlgBase( parent, name, modal, fl ), m_item( item )
{
    incUrl->setMode( KFile::File | KFile::LocalOnly );
    incUrl->setCaption( i18n( "Choose existing .pri file or give a new filename for creation" ) );
    incUrl->setURL( TQString("") );
    incUrl->completionObject() ->setDir( item->scope->projectDir() );
    incUrl->fileDialog()->setURL( KURL::fromPathOrURL( item->scope->projectDir() ) );
}

CreateScopeDlg::~CreateScopeDlg()
{}

void CreateScopeDlg::accept()
{
    Scope * s = 0;
    switch ( comboScopeType->currentItem() )
    {
        case 0:
            if ( !editScopeName->text().isEmpty() )
                s = m_item->scope->createSimpleScope( editScopeName->text() );
            break;
        case 1:
            if ( !editFunction->text().isEmpty() && !editArguments->text().isEmpty() )
                s = m_item->scope->createFunctionScope( editFunction->text(), editArguments->text() );
            break;
        case 2:
            if ( !incUrl->url().isEmpty() )
            {
                TQString file = incUrl->url();
                if ( !incUrl->url().endsWith( ".pri" ) )
                    file += ".pri";
                if( file.find("/") == -1 )
                    file = m_item->scope->projectDir()+"/"+file;
                // We need to create the file, because getRelativePath checks for existent paths
                if( !TQFile::exists(file) )
                {
                    TQFile temp(file);
                    if( temp.open(IO_WriteOnly) )
                        temp.close();
                }
                file = URLUtil::getRelativePath( m_item->scope->projectDir(), file );
                s = m_item->scope->createIncludeScope( file );
            }
            break;
    }
    if ( s )
    {
        if ( !m_item->firstChild() )
            new QMakeScopeItem( m_item, s->scopeName(), s );
        else
        {
            TQListViewItem* item = m_item->firstChild();
            while( item->nextSibling() )
                item = item->nextSibling();
            QMakeScopeItem* newitem = new QMakeScopeItem( m_item, s->scopeName(), s );
            newitem->moveItem( item );
        }
        TQDialog::accept();
    }
    else
    {
        if ( KMessageBox::warningYesNo( this, i18n( "You did not specify all needed information. "
                                        "The scope will not be created.<br>Do you want to abort the scope creation?" ),
                                        i18n( "Missing information" ) ) == KMessageBox:: Yes )
            TQDialog::reject();
    }
}

#include "createscopedlg.moc"
