/***************************************************************************
 *   Copyright (C) 2005 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "viewer.h"

#include <tqdir.h>
#include <tqlineedit.h>
#include <tqlistbox.h>
#include <tqfiledialog.h>
#include <tqtextedit.h>
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqlistview.h>
#include <tqtabwidget.h>

#include <tqmakeast.h>
#include <tqmakedriver.h>
#include <tqmakeastvisitor.h>

using namespace TQMake;

Viewer::Viewer(TQWidget *parent, const char *name)
    :ViewerBase(parent, name), projectAST(0)
{
    if (TQFile::exists(TQDir::currentDirPath() + "/" + "qtlist"))
    {
        TQFile f(TQDir::currentDirPath() + "/" + "qtlist");
        f.open(IO_ReadOnly);
        TQTextStream str(&f);
        while (!str.eof())
            files->insertItem(str.readLine());
    }
    ast->setSorting(-1);
//    parentProject.push((TQListViewItem*)0);
}

void Viewer::addAll_clicked()
{
    if (allLocation->text().isEmpty())
        return;
    TQDir d(allLocation->text());
    TQStringList l = d.entryList("*.pro *.pri");
    for (TQStringList::iterator it = l.begin(); it != l.end(); ++it)
        (*it) = TQDir::cleanDirPath(allLocation->text() + "/" + (*it));
    files->insertStringList(l);
}

void Viewer::choose_clicked()
{
    TQString fileName = TQFileDialog::getOpenFileName(TQDir::currentDirPath(), "*.pro *.pri", this);
    if (!fileName.isEmpty())
        files->insertItem(fileName);
}

void Viewer::files_currentChanged(TQListBoxItem* item)
{
    ast->clear();

    TQFile f(item->text());
    f.open(IO_ReadOnly);
    TQTextStream str(&f);
    source->setText(str.read());
    f.close();

    int result = TQMake::Driver::parseFile(item->text().ascii(), &projectAST, 0);
    if (projectAST && (result == 0))
    {
        processAST(projectAST);
    }
    if (tabWidget2->currentPageIndex() == 1)
        tabWidget2_selected("Source to be written back");
}

void Viewer::tabWidget2_selected(const TQString& text)
{
    if ((text == "Source to Be Written Back") && projectAST)
    {
        TQString buffer;
        projectAST->writeBack(buffer);
        writeBack->setText(buffer);
    }
}

class ViewerVisitor: public ASTVisitor {
public:
    ViewerVisitor(Viewer *v): ASTVisitor()
    {
        this->v = v;
        parentProject.push((TQListViewItem*)0);
    }

    virtual void processProject(ProjectAST *project)
    {
        ASTVisitor::processProject(project);
    }

    virtual void enterRealProject(ProjectAST *project)
    {
        TQListViewItem *projectIt;
        if (!parentProject.top())
        {
            projectIt = new TQListViewItem(v->ast, "Project");
            projectIt->setOpen(true);
            parentProject.push(projectIt);
        }

        ASTVisitor::enterRealProject(project);
    }
    virtual void enterScope(ProjectAST *scope)
    {
        TQListViewItem *projectIt = new TQListViewItem(parentProject.top(), scope->scopedID, "scope");
        parentProject.push(projectIt);
        ASTVisitor::enterScope(scope);
    }
    virtual void leaveScope(ProjectAST *scope)
    {
        parentProject.pop();
    }
    virtual void enterFunctionScope(ProjectAST *fscope)
    {
        TQListViewItem *projectIt = new TQListViewItem(parentProject.top(),
            fscope->scopedID + "(" + fscope->args + ")", "function scope");
        parentProject.push(projectIt);
        ASTVisitor::enterFunctionScope(fscope);
    }
    virtual void leaveFunctionScope(ProjectAST *fscope)
    {
        parentProject.pop();
    }
    virtual void processAssignment(AssignmentAST *assignment)
    {
        TQListViewItem *item = new TQListViewItem(parentProject.top(),
                assignment->scopedID, assignment->op, assignment->values.join("|"),
                "assignment");
        item->setMultiLinesEnabled(true);

        ASTVisitor::processAssignment(assignment);
    }
    virtual void processNewLine(NewLineAST *newline)
    {
        new TQListViewItem(parentProject.top(), "<newline>");
        ASTVisitor::processNewLine(newline);
    }
    virtual void processComment(CommentAST *comment)
    {
        new TQListViewItem(parentProject.top(), "<comment>");
        ASTVisitor::processComment(comment);
    }
    virtual void processInclude(IncludeAST *include)
    {
        new TQListViewItem(parentProject.top(), "<include>", include->projectName);
        TQMake::ASTVisitor::processInclude(include);
    }

    Viewer *v;
    TQValueStack<TQListViewItem *> parentProject;
};


void Viewer::processAST(TQMake::ProjectAST *projectAST, TQListViewItem *globAfter)
{
    ViewerVisitor visitor(this);
    visitor.processProject(projectAST);
}

#include "viewer.moc"
