/***************************************************************************
                          radioview.h  -  description
                             -------------------
    begin                : Mit Mai 28 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_RADIOVIEW_H
#define KRADIO_RADIOVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqobjectlist.h>

#include "../../src/include/radio_interfaces.h"
#include "../../src/include/radiodevicepool_interfaces.h"
#include "../../src/include/soundstreamclient_interfaces.h"
#include "../../src/include/timecontrol_interfaces.h"
#include "../../src/include/widgetplugins.h"
#include "radioview_element.h"

class TQWidgetStack;
class TQToolButton;
class KComboBox;
class TQTabWidget;
class TDEPopupMenu;



class RadioView : public TQWidget,
                  public WidgetPluginBase,
                  public IRadioClient,
                  public IRadioDevicePoolClient,
                  public ISoundStreamClient,
                  public ITimeControlClient
{
TQ_OBJECT
  
public:

    RadioView(const TQString &name);
    virtual ~RadioView();

    virtual TQString pluginClassName() const { return "RadioView"; }

    const TQString &name() const { return PluginBase::name(); }
          TQString &name()       { return PluginBase::name(); }

    // WidgetPluginBase

public:
    virtual void   saveState (TDEConfig *) const;
    virtual void   restoreState (TDEConfig *);

    virtual bool   connectI(Interface *i);
    virtual bool   disconnectI(Interface *i);

    virtual void   noticeWidgetPluginShown(WidgetPluginBase *p, bool shown);
    virtual void   noticePluginsChanged(const PluginList &);

    virtual ConfigPageInfo  createConfigurationPage();
    virtual AboutPageInfo   createAboutPage();

public slots:
    // connects destroy-msg with remove-function
    bool addElement    (RadioViewElement *);
    bool removeElement (TQObject *);

protected:
    void selectTopWidgets();


    // IRadioClient

RECEIVERS:
    bool noticePowerChanged(bool on);
    bool noticeStationChanged (const RadioStation &, int idx);
    bool noticeStationsChanged(const StationList &sl);
    bool noticePresetFileChanged(const TQString &/*f*/)           { return false; }

    bool noticeCurrentSoundStreamIDChanged(SoundStreamID id);

    // IRadioDevicePoolClient

RECEIVERS:
    bool noticeActiveDeviceChanged(IRadioDevice *rd);
    bool noticeDevicesChanged(const TQPtrList<IRadioDevice> &)  { return false; }
    bool noticeDeviceDescriptionChanged(const TQString &) { return false; }

    // ISoundStreamClient

RECEIVERS:
    void noticeConnectedI (ISoundStreamServer *s, bool pointer_valid);

    bool startRecordingWithFormat(SoundStreamID /*id*/,
                      const SoundFormat &/*proposed_format*/,
                      SoundFormat       &/*real_format*/);
    bool stopRecording(SoundStreamID /*id*/);

    bool noticeSoundStreamChanged(SoundStreamID id);

    // ITimeControlClient

RECEIVERS:
    bool noticeAlarmsChanged(const AlarmVector &)     { return false; }
    bool noticeAlarm(const Alarm &)                   { return false; }
    bool noticeNextAlarmChanged(const Alarm *)        { return false; }
    bool noticeCountdownStarted(const TQDateTime &end);
    bool noticeCountdownStopped();
    bool noticeCountdownZero();
    bool noticeCountdownSecondsChanged(int)           { return false; }

protected slots:

    void slotPower (bool on);
    void slotPause();
    void slotConfigure (bool show);
    void slotRecord ();
    void slotSnooze (bool start);
    void slotSnooze (int time);
    void slotRecordingMenu(int i);
    void slotBtnPluginsClicked();
    void slotComboStationSelected(int);

    void slotConfigPageDeleted(TQObject*);
    void slotElementConfigPageDeleted(TQObject*);

public slots:

    void    toggleShown() { WidgetPluginBase::pToggleShown(); }
    void    showOnOrgDesktop();
    void    show();
    void    hide();

protected:
    virtual void showEvent(TQShowEvent *);
    virtual void hideEvent(TQHideEvent *);

    virtual void autoSetCaption();

    const TQWidget *getWidget() const { return this; }
          TQWidget *getWidget()       { return this; }

    void    addConfigurationTabFor(RadioViewElement *, TQTabWidget *);
    void    addCommonConfigurationTab(TQTabWidget *);

protected:
    bool                  enableToolbarFlag;

    TQToolButton          *btnPower;
    TQToolButton          *btnConfigure;
    TQToolButton          *btnQuit;
    TQToolButton          *btnRecording;
    TQToolButton          *btnSnooze;
    TQToolButton          *btnPlugins;
    KComboBox            *comboStations;

    struct ElementCfg
    {
        RadioViewElement *element;
        TQObject          *cfg;
        ElementCfg()                                : element(NULL), cfg(NULL) {}
        ElementCfg(RadioViewElement *e, TQObject *w) : element(e), cfg(w) {}
        ElementCfg(RadioViewElement *e)             : element(e), cfg(NULL) {}
        ElementCfg(TQObject *w)                      : element(NULL), cfg(w) {}
        bool operator == (const ElementCfg &x) const;
    };

    typedef  TQPtrList<RadioViewElement>         ElementList;
    typedef  TQPtrListIterator<RadioViewElement> ElementListIterator;
    typedef  TQValueList<ElementCfg>             ElementCfgList;
    typedef  TQValueListIterator<ElementCfg>     ElementCfgListIterator;

    ElementList           elements;
    ElementCfgList        elementConfigPages;
    TQObjectList           configPages;
    TQWidgetStack *        widgetStacks[clsClassMAX];
    float                 maxUsability[clsClassMAX];

    IRadioDevice         *currentDevice;

    TDEPopupMenu                    *m_RecordingMenu;
    TDEPopupMenu                    *m_pauseMenu;
    TDEPopupMenu                    *m_SnoozeMenu;
    int                            m_NextRecordingMenuID;
    TQMap<int, SoundStreamID>       m_MenuID2StreamID;
    TQMap<SoundStreamID, int>       m_StreamID2MenuID;

    TDEPopupMenu                    *m_PluginMenu;
    TQMap<WidgetPluginBase *, int>  m_Plugins2MenuID;
};




#endif
