/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MK_TDEIO_DELETE_H
#define MK_TDEIO_DELETE_H

/*
 * This class handles removing of selected messages.
 * This class starts working when deleteMails() is called.
 */

#include <tqobject.h>
class KKioDrop;
class TDEIO_Protocol;
class KornMailId;

class KURL;
namespace TDEIO { class MetaData; class Job; class Slave; }

template<class T> class TQPtrList;

class TDEIO_Delete : public TQObject
{ TQ_OBJECT
  
public:
	//constructors
	TDEIO_Delete( TQObject * parent = 0, const char * name = 0 );
	~TDEIO_Delete( );
	
	//This function should be called if there are messages to be deleted.
	bool deleteMails( TQPtrList< const KornMailId > *, KKioDrop* );
	
	//This function should return false then and only then if an error occurred.
	bool valid( ) { return _valid; }
	
public slots:
	//If this slot is called, the whole deletion is canceled.
	void canceled( );
private slots:
	void slotResult( TDEIO::Job* );
	
private:
	void disConnect( );
	bool setupSlave( KURL kurl, TDEIO::MetaData metadata, const TDEIO_Protocol *& protocol );
	void deleteItem( const KornMailId *item, KURL, TDEIO::MetaData, const TDEIO_Protocol *&);
	void commitDelete( KURL, TDEIO::MetaData, const TDEIO_Protocol *& );

	KKioDrop *_tdeio;
	unsigned int _total;
	TQPtrList< TDEIO::Job > *_jobs;
	TDEIO::Slave *_slave;
	bool _valid;
};

#endif //MK_TDEIO_DELETE_H
