/***************************************************************************
 *
 * tdenetman-vpnc.h - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_VPNC_H
#define TDENETWORKMANAGER_VPNC_H

#include <tqmap.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqlayout.h>

#include "tdenetman-vpnplugin.h"
#include "vpncprop.h"
#include "vpncauth.h"

class VPNCPlugin : public VPNPlugin
{
	TQ_OBJECT
  
	public:
		VPNCPlugin(TQObject*, const char*, const TQStringList&);
		~VPNCPlugin();

		VPNConfigWidget* CreateConfigWidget(TQWidget* parent=0);
		VPNAuthenticationWidget* CreateAuthenticationWidget(TQWidget* parent=0);
};

class VPNCConfig : public VPNConfigWidget
{
	TQ_OBJECT

	public:
		void setVPNData(TDENetworkSingleRouteConfigurationList& routes, TDENetworkSettingsMap& properties, TDENetworkSettingsMap& secrets);
		TDENetworkSettingsMap getVPNProperties();
		TDENetworkSettingsMap getVPNSecrets();
		TDENetworkSingleRouteConfigurationList getVPNRoutes();
		bool hasChanged();
		bool isValid(TQStringList&);

		VPNCConfig(TQWidget* parent);
		~VPNCConfig();

	public slots:
		void pcfImport();

	private:
		VPNCConfigWidget*   _vpncWidget;
		int getFileConfig(const char *parameter, char *line);

		TDENetworkSettingsMap m_vpnProperties;
		TDENetworkSettingsMap m_vpnSecrets;

	protected slots:
		void languageChange();
};

class VPNCAuthentication : public VPNAuthenticationWidget
{
	TQ_OBJECT

	public:
		VPNCAuthentication(TQWidget* parent = NULL, char* name = NULL);
		~VPNCAuthentication();
		TDENetworkSettingsMap getPasswords();
		void setPasswords(TDENetworkSettingsMap secrets);

	private:
		VPNCAuthenticationWidget* _vpncAuth;
};

#endif /* TDENETWORKMANAGER_VPNC_H */
