/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSEDITACCOUNTWIDGET_H
#define SMSEDITACCOUNTWIDGET_H

#include <tqwidget.h>
#include "editaccountwidget.h"

class SMSProtocol;
class SMSService;
class smsActPrefsUI;
namespace Kopete { class Account; }
class TQGridLayout;

class SMSEditAccountWidget : public TQWidget, public KopeteEditAccountWidget
{
	TQ_OBJECT
  
public:
	SMSEditAccountWidget(SMSProtocol *protocol, Kopete::Account *theAccount, TQWidget *parent = 0, const char *name = 0);
	~SMSEditAccountWidget();

	bool validateData();
	Kopete::Account* apply();
public slots:
	void setServicePreferences(const TQString& serviceName);
	void showDescription();
protected:
	smsActPrefsUI *preferencesDialog;
	TQWidget *configWidget;
	SMSService *service;
	SMSProtocol *m_protocol;
	TQGridLayout *middleFrameLayout;

signals:
	void saved();
};

#endif
