/*
    Tests for Kopete::Message::parseEmoticons

    Copyright (c) 2004      by Richard Smith          <kde@metafoo.co.uk>
    Copyright (c) 2005      by Duncan Mac-Vicar       <duncan@kde.org>

    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <stdlib.h>

#include <tqstring.h>
#include <tqdir.h>
#include <tqfile.h>

#include <tdeapplication.h>
#include <tdeglobal.h>
#include <tdestandarddirs.h>
#include <kdebug.h>

#include <tdeunittest/module.h>
#include "kopeteemoticontest.h"
#include "kopetemessage.h"
#include "kopeteemoticons.h"

using namespace KUnitTest;

TDEUNITTEST_MODULE( tdeunittest_kopeteemoticontest, "KopeteSuite");
TDEUNITTEST_MODULE_REGISTER_TESTER( KopeteEmoticonTest );

/*
  There are three sets of tests, the Kopete 0.7 baseline with tests that were
  working properly in Kopete 0.7.x. When these fail it's a real regression.

  The second set are those known to work in the current codebase.
  The last set is the set with tests that are known to fail right now.

   the name convention is working|broken-number.input|output
*/


void KopeteEmoticonTest::allTests()
{
	// change user data dir to avoid messing with user's .kde dir
	setenv( "TDEHOME", TQFile::encodeName( TQDir::homeDirPath() + "/.kopete-unittest" ), true );

	//TDEApplication::disableAutoDcopRegistration();
	//TDEApplication app;

	testEmoticonParser();
}

void KopeteEmoticonTest::testEmoticonParser()
{
	Kopete::Emoticons emo("Default");
	TQString basePath = TQString::fromLatin1( SRCDIR ) + TQString::fromLatin1("/emoticon-parser-testcases");
	TQDir testCasesDir(basePath);
	
	TQStringList inputFileNames = testCasesDir.entryList("*.input");
	for ( TQStringList::ConstIterator it = inputFileNames.begin(); it != inputFileNames.end(); ++it)
	{
		TQString fileName = *it;
		kdDebug() << "testcase: " << fileName << endl;
		TQString outputFileName = fileName;
		outputFileName.replace("input","output");
		// open the input file
		TQFile inputFile(basePath + TQString::fromLatin1("/") + fileName);
		TQFile expectedFile(basePath + TQString::fromLatin1("/") + outputFileName);
		// check if the expected output file exists
		// if it doesn't, skip the testcase
		if ( ! expectedFile.exists() )
		{
			SKIP("Warning! expected output for testcase "+ *it + " not found. Skiping testcase");
			continue;
		}
		if ( inputFile.open( IO_ReadOnly ) && expectedFile.open( IO_ReadOnly ))
		{
			TQTextStream inputStream(&inputFile);
			TQTextStream expectedStream(&expectedFile);
			TQString inputData;
			TQString expectedData;
			inputData = inputStream.read();
			expectedData = expectedStream.read();

			inputFile.close();
			expectedFile.close();

			TQString path = TDEGlobal::dirs()->findResource( "emoticons", "Default/smile.png" ).replace( "smile.png", TQString() );
				
			Kopete::Emoticons::self();
			TQString result = emo.parse( inputData ).replace( path, TQString() );	
			
			// HACK to know the test case we applied, concatenate testcase name to both
			// input and expected string. WIll remove when I can add some sort of metadata
			// to a CHECK so debug its origin testcase
			result = fileName + TQString::fromLatin1(": ") + result;
			expectedData = fileName + TQString::fromLatin1(": ") + expectedData;
			// if the test case begins with broken, we expect it to fail, then use XFAIL
			// otherwise use CHECK
			if ( fileName.section("-", 0, 0) == TQString::fromLatin1("broken") )
			{
				kdDebug() << "checking known-broken testcase: " << fileName << endl;
				XFAIL(result, expectedData);
			}
			else
			{
				kdDebug() << "checking known-working testcase: " << fileName << endl;
				CHECK(result, expectedData);
			}
		}
		else
		{
			SKIP("Warning! can't open testcase files for "+ *it + ". Skiping testcase");
			continue;
		}
	}
	
}
