/* $Id$ */
/***************************************************************************
                          service.cpp  -  A DCOP Service to provide RSS data
                             -------------------
    begin                : Saturday 15 February 2003
    copyright            : (C) 2003 by Ian Reinhart Geiser
    email                : geiseri@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include "service.h"
#include "cache.h"

RSSService::RSSService() :
	DCOPObject("RSSService")
{
	m_list.setAutoDelete( true );

	loadLinks();
}

RSSService::~RSSService()
{
}


TQStringList RSSService::list()
{
	TQStringList lst;
	TQDictIterator<RSSDocument> itr(m_list);
	for(; itr.current(); ++itr)
		lst.append(itr.currentKey());
	return lst;
}

DCOPRef RSSService::add(TQString id)
{
	if(m_list.find(id) == 0L) { // add a new one only if we need to
		m_list.insert(id, new RSSDocument(id));
		added(id);
		saveLinks();
        }
	return document(id);
}

void RSSService::remove(TQString id)
{
	m_list.remove(id);
	removed(id);
	saveLinks();
}

DCOPRef RSSService::document(TQString id)
{
	if( m_list[id] )
		return DCOPRef(m_list[id]);
	else
		return DCOPRef();
}

void RSSService::exit()
{
	//Save all current RSS links.
	saveLinks();
	Cache::self().save();
	tdeApp->quit();
}


void RSSService::loadLinks()
{
	TDEConfig *conf = tdeApp->config();
	conf->setGroup("RSS Links");	
	const TQStringList links = conf->readListEntry ("links"); 
	TQStringList::ConstIterator it = links.begin();
	TQStringList::ConstIterator end = links.end();
	for ( ; it != end; ++it )
		add( *it );
}

void RSSService::saveLinks()
{
	TDEConfig *conf = tdeApp->config();
	conf->setGroup("RSS Links");	
        TQStringList lst;
        TQDictIterator<RSSDocument> itr(m_list);
        for(; itr.current(); ++itr)
                lst.append(itr.currentKey());

	conf->writeEntry("links", lst);	
	conf->sync();
}



