/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#include "krecglobal.h"
#include "krecglobal.moc"

#include "krecexport_template.h"

#include <tdeconfig.h>
#include <tqwidget.h>
#include <tdeapplication.h>
#include <kstatusbar.h>

#include <ktrader.h>
#include <tdeparts/componentfactory.h>
#include <tqvaluelist.h>
#include <kservice.h>

#include <kdebug.h>

KRecGlobal::KRecGlobal( TQObject* p, const char* n )
  : TQObject( p,n )
  , _qwidget( 0 )
  , _statusbar( 0 )
  , _timeformatcache( -1 )
  , _framebasecache( -1 )
{
	//kdDebug( 60005 ) << k_funcinfo << endl;
	_exports = new TQDict<KRecExportItem>;
}
KRecGlobal::~KRecGlobal() {
	//kdDebug( 60005 ) << k_funcinfo << endl;
}

KRecGlobal* KRecGlobal::the() {
	//kdDebug( 60005 ) << k_funcinfo << endl;
	static KRecGlobal* object = new KRecGlobal();
	return object;
}

void KRecGlobal::setMainWidget( TQWidget* n ) { _qwidget = n; }
TQWidget* KRecGlobal::mainWidget() { return _qwidget; }

TDEConfig* KRecGlobal::tdeconfig() { return tdeApp->config(); }

void KRecGlobal::setStatusBar( KStatusBar *bar ) { _statusbar = bar; }
void KRecGlobal::message( const TQString &text ) { if ( _statusbar ) _statusbar->message( text, 2000 ); }

bool KRecGlobal::registerExport( KRecExportItem* item ) {
	//kdDebug( 60005 ) << k_funcinfo << "About to register ExportItem for \"" << item->exportFormat() << "\" extensions:\"" << item->extensions() << "\"" << endl;
	if ( !the()->_exports->find( item->exportFormat() ) ) {
		the()->_exports->insert( item->exportFormat(), item );
		the()->_exportformats << item->exportFormat();
	}
	return true;
}

KRecExportItem* KRecGlobal::getExportItem( const TQString &exportFormat ) {
	KRecExportItem *tmp = _exports->find( exportFormat );
	return tmp->newItem();
}

TQStringList KRecGlobal::exportFormats() const {
	return _exportformats;
}

TQString KRecGlobal::exportFormatEndings() const {
	TQString out;

	TDETrader::OfferList offers = TDETrader::self()->query( "KRec/exportplugin" );
	TDETrader::OfferList::iterator it = offers.begin();
	while (  it!=offers.end() ) {
		out += " *.";
		out += ( *it )->property( "X-TDE-ExportSuffix" ).toStringList().join( " *." );
		++it;
	}

	return out;
}

KRecExportItem* KRecGlobal::getExportItemForEnding( const TQString &ending ) {
	TDETrader::OfferList offers = TDETrader::self()->query( "KRec/exportplugin" );
	TDETrader::OfferList::iterator it = offers.begin();
	while (  it!=offers.end() ) {
		kdDebug(60005) << ( *it )->property( "X-TDE-ExportSuffix" ).toStringList() << endl;
		if ( ( *it )->property( "X-TDE-ExportSuffix" ).toStringList().grep( ending ).count() ) {
			kdDebug(60005) << "Ending(" << ending << ") found" << endl;
			return KParts::ComponentFactory::createInstanceFromService<KRecExportItem>( ( *it ), this, "exportplugin" );
		} else kdDebug(60005) << "Doesn't contain " << ending << endl;
		++it;
	}
	return 0;
}

int KRecGlobal::timeFormatMode() {
	if ( _timeformatcache < 0 ) {
		tdeApp->config()->setGroup( "General" );
		_timeformatcache = tdeApp->config()->readNumEntry( "TimeFormat", 0 );
	}
	return _timeformatcache;
}
void KRecGlobal::setTimeFormatMode( int n ) {
	tdeApp->config()->setGroup( "General" );
	tdeApp->config()->writeEntry( "TimeFormat", n );
	_timeformatcache = n;
}

int KRecGlobal::frameBase() {
	if ( _framebasecache < 0 ) {
		tdeApp->config()->setGroup( "General" );
		_framebasecache = tdeApp->config()->readNumEntry( "FrameBase", 25 );
	}
	return _framebasecache;
}
void KRecGlobal::setFrameBase( int n ) {
	tdeApp->config()->setGroup( "General" );
	tdeApp->config()->writeEntry( "FrameBase", n );
	_framebasecache = n;
}

