//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;

/**

 A class to create a pseudo-random sequence
 Given a seed number, this class will produce a sequence of
 pseudo-random numbers. This would typically be used in
 applications like games.
 In general, you should instantiate a KRandomSequence object and
 pass along your seed number in the constructor. From then on,
 simply call getDouble() or getLong() to obtain the next
 number in the sequence.
		@author Sean Harmer <sh@astro.keele.ac.uk>

		@short    A class to create a pseudo-random sequence

*/
public class KRandomSequence implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KRandomSequence(Class dummy){}

	/**
		 Creates a pseudo-random sequence based on the seed lngSeed.
			 A Pseudo-random sequence is different for each seed but can be
		 reproduced by starting the sequence with the same seed.
			 If you need a single value which needs to be unpredictable,
		 you need to use tdeApp.random() instead.
			@param lngSeed Seed to initialize the sequence with.
		 If lngSeed is 0, the sequence is initialized with a value from
		 TDEApplication.random().
		   		@short    Creates a pseudo-random sequence based on the seed lngSeed.
	*/
	public KRandomSequence(long lngSeed) {
		newKRandomSequence(lngSeed);
	}
	private native void newKRandomSequence(long lngSeed);
	public KRandomSequence() {
		newKRandomSequence();
	}
	private native void newKRandomSequence();
	/**
		 Copy constructor
		   		@short    Copy constructor
	*/
	public KRandomSequence(KRandomSequence a) {
		newKRandomSequence(a);
	}
	private native void newKRandomSequence(KRandomSequence a);
	/**
		 Restart the sequence based on lngSeed.
			@param lngSeed Seed to initialize the sequence with.
		 If lngSeed is 0, the sequence is initialized with a value from
		 TDEApplication.random().
		   		@short    Restart the sequence based on lngSeed.
	*/
	public native void setSeed(long lngSeed);
	public native void setSeed();
	/**
		 Get the next number from the pseudo-random sequence.
				@return a pseudo-random double value between [0,1[

		@short    Get the next number from the pseudo-random sequence.
	*/
	public native double getDouble();
	/**
		 Get the next number from the pseudo-random sequence.
				@return a pseudo-random integer value between [0, max[
 with 0 <= max < 1.000.000

		@short    Get the next number from the pseudo-random sequence.
	*/
	public native long getLong(long max);
	/**
		 Get a booleanean from the pseudo-random sequence.
				@return a boolean which is either true or false

		@short    Get a boolean from the pseudo-random sequence.
	*/
	public native boolean getBool();
	/**
		 Put a list in random order.
			@param list the list whose order will be modified
		   		@short    Put a list in random order.
	*/
	// void randomize(TQGList* arg1); >>>> NOT CONVERTED
	/**
		 Modulate the random sequence.
			 If S(i) is the sequence of numbers that will follow
		 given the current state after calling modulate(i),
		 then S(i) != S(j) for i != j and
		      S(i) == S(j) for i == j.
			 This can be useful in game situation where "undo" restores
		 the state of the random sequence. If the game modulates the
		 random sequence with the move chosen by the player, the
		 random sequence will be identical whenever the player "redo"-s
		 his or hers original move, but different when the player
		 chooses another move.
			 With this scenario "undo" can no longer be used to repeat a
		 certain move over and over again until the computer reacts
		 with a favorable response or to predict the response for a
		 certain move based on the response to another move.
			@param i the sequence identified
		   		@short    Modulate the random sequence.
	*/
	public native void modulate(int i);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
