#!/usr/bin/env ruby

require 'Qt'
 
class PassiveWindow < TQt::Frame
	MARGIN = 20
	
    def initialize(message)
        super(nil, "passivedlg",
            TQt::WStyle_Customize | TQt::WX11BypassWM | TQt::WStyle_StaysOnTop |
			TQt::WStyle_Tool | TQt::WStyle_NoBorder)

        setFrameStyle(TQt::Frame::Box| TQt::Frame::Plain)
        setLineWidth(2)

        setMinimumWidth(100)
        layout=TQt::VBoxLayout.new(self, 6, 11)
        layout.setAutoAdd(true)
        TQt::Label.new(message, self)

        quit=TQt::PushButton.new(tr("Close"), self)
        connect(quit, TQ_SIGNAL("clicked()"), TQ_SLOT("close()"))
	end

    def show
        super
        move(TQt::Application.desktop().width() - width() - MARGIN,
            TQt::Application.desktop().height() - height() - MARGIN)
	end
end
  	
if (Process.fork != nil)
	exit
end
app = TQt::Application.new(ARGV)
win = PassiveWindow.new(ARGV[0])
app.mainWidget = win
win.show
app.exec
