/*
    Rosegarden
    A sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    The moral right of the authors to claim authorship of this work
    has been asserted.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _LADSPA_PLUGIN_FACTORY_H_
#define _LADSPA_PLUGIN_FACTORY_H_

#ifdef HAVE_LADSPA

#include "PluginFactory.h"
#include <ladspa.h>

#include <vector>
#include <map>
#include <set>
#include <tqstring.h>

namespace Rosegarden
{

class LADSPAPluginInstance;

class LADSPAPluginFactory : public PluginFactory
{
public:
    virtual ~LADSPAPluginFactory();

    virtual void discoverPlugins();

    virtual const std::vector<TQString> &getPluginIdentifiers() const;

    virtual void enumeratePlugins(MappedObjectPropertyList &list);

    virtual void populatePluginSlot(TQString identifier, MappedPluginSlot &slot);

    virtual RunnablePluginInstance *instantiatePlugin(TQString identifier,
                                                      int instrumentId,
                                                      int position,
                                                      unsigned int sampleRate,
                                                      unsigned int blockSize,
                                                      unsigned int channels);

    MappedObjectValue getPortMinimum(const LADSPA_Descriptor *, int port);
    MappedObjectValue getPortMaximum(const LADSPA_Descriptor *, int port);
    MappedObjectValue getPortDefault(const LADSPA_Descriptor *, int port);
    int getPortDisplayHint(const LADSPA_Descriptor *, int port);

protected:
    LADSPAPluginFactory();
    friend class PluginFactory;

    virtual std::vector<TQString> getPluginPath();

#ifdef HAVE_LIBLRDF
    virtual std::vector<TQString> getLRDFPath(TQString &baseUri);
#endif

    virtual void discoverPlugins(TQString soName);
    virtual void generateTaxonomy(TQString uri, TQString base);
    virtual void generateFallbackCategories();

    virtual void releasePlugin(RunnablePluginInstance *, TQString);

    virtual const LADSPA_Descriptor *getLADSPADescriptor(TQString identifier);

    void loadLibrary(TQString soName);
    void unloadLibrary(TQString soName);
    void unloadUnusedLibraries();

    std::vector<TQString> m_identifiers;

    std::map<unsigned long, TQString> m_taxonomy;
    std::map<TQString, TQString> m_fallbackCategories;
    std::map<unsigned long, std::map<int, float> > m_portDefaults;

    std::set<RunnablePluginInstance *> m_instances;

    typedef std::map<TQString, void *> LibraryHandleMap;
    LibraryHandleMap m_libraryHandles;
};

}

#endif

#endif

