/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "TextFloat.h"
#include <tdeapplication.h>

#include "gui/general/GUIPalette.h"
#include <tqfontmetrics.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpoint.h>
#include <tqrect.h>
#include <tqstring.h>
#include <tqwidget.h>


namespace Rosegarden
{

TextFloat::TextFloat(TQWidget *parent):
        TQWidget(parent, "TextFloat",
                WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop),
        m_text("")
{
    reparent(parentWidget());
    resize(20, 20);
}

void
TextFloat::reparent(TQWidget *newParent)
{
    TQPoint position = newParent->pos();

    // Get position and reparent to either top level or dialog
    //
    while (newParent->parentWidget() && !newParent->isTopLevel()
            && !newParent->isDialog()) {
        newParent = newParent->parentWidget();
        position += newParent->pos();
    }

    // Position this widget to the right of the parent
    //
    //move(pos + TQPoint(parent->width() + 5, 5));

    TQWidget::reparent(newParent,
                      WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop,
                      position + TQPoint(20, 5));
}

void
TextFloat::paintEvent(TQPaintEvent *e)
{
    TQPainter paint(this);

    paint.setClipRegion(e->region());
    paint.setClipRect(e->rect().normalize());

    paint.setPen(tdeApp->palette().color(TQPalette::Active, TQColorGroup::Dark));

    paint.setPen(GUIPalette::getColour(GUIPalette::RotaryFloatForeground));
    paint.setBrush(GUIPalette::getColour(GUIPalette::RotaryFloatBackground));

    TQFontMetrics metrics(paint.fontMetrics());

    TQRect r = metrics.boundingRect(0, 0, 400, 400, TQt::AlignAuto, m_text);
    resize(r.width() + 7, r.height() + 7);
    paint.drawRect(0, 0, r.width() + 6, r.height() + 6);
    paint.setPen(TQt::black);
    paint.drawText(TQRect(3, 3, r.width(), r.height()), TQt::AlignAuto, m_text);

    /*
        TQRect textBound = metrics.boundingRect(m_text);
     
        resize(textBound.width() + 7, textBound.height() + 7);
        paint.drawRect(0, 0, textBound.width() + 6, textBound.height() + 6);
     
        paint.setPen(TQt::black);
        paint.drawText(3, textBound.height() + 3, m_text);
    */
}

void
TextFloat::setText(const TQString &text)
{
    m_text = text;
    repaint();
}

}
