/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "TimeDialog.h"

#include <tdelocale.h>
#include "base/Composition.h"
#include "gui/widgets/TimeWidget.h"
#include <kdialogbase.h>
#include <tqstring.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

TimeDialog::TimeDialog(TQWidget *parent, TQString title,
                       Composition *composition,
                       timeT defaultTime,
                       bool constrainToCompositionDuration) :
        KDialogBase(parent, 0, true, title, User1 | Ok | Cancel)
{
    TQVBox *vbox = makeVBoxMainWidget();
    m_timeWidget = new TimeWidget
        (title, vbox, composition, defaultTime, true,
         constrainToCompositionDuration);

    setButtonText(User1, i18n("Reset"));
    connect(this, TQ_SIGNAL(user1Clicked()),
            m_timeWidget, TQ_SLOT(slotResetToDefault()));
}

TimeDialog::TimeDialog(TQWidget *parent, TQString title,
                       Composition *composition,
                       timeT startTime,
                       timeT defaultTime,
                       bool constrainToCompositionDuration) :
        KDialogBase(parent, 0, true, title, User1 | Ok | Cancel)
{
    TQVBox *vbox = makeVBoxMainWidget();
    m_timeWidget = new TimeWidget
        (title, vbox, composition, startTime, defaultTime, true,
         constrainToCompositionDuration);

    setButtonText(User1, i18n("Reset"));
    connect(this, TQ_SIGNAL(user1Clicked()),
            m_timeWidget, TQ_SLOT(slotResetToDefault()));
}

timeT
TimeDialog::getTime() const
{
    return m_timeWidget->getTime();
}

}
#include "TimeDialog.moc"
