"""
This template constructs an application with menus, toolbar and statusbar,
HOWEVER it is not recommended this template actually be used. It presents
the "KDE 1.0" method for constructing menus and toolbars - later versions
of KDE have introduced better (easier and more powerful) methods for
doing this job - see other menuapp*.py templates for these methods
"""

"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


import sys

from PyTQt.tqt import TQPopupMenu, TQ_SIGNAL

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, i18n, TDEStdAccel, TDEIcon, TDEIconLoader
from tdeui import TDEMainWindow, KMessageBox

TOOLBAR_NEW   = 1
TOOLBAR_OPEN  = 2
TOOLBAR_SAVE  = 3
TOOLBAR_CUT   = 4
TOOLBAR_COPY  = 5
TOOLBAR_PASTE = 6

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        TDEMainWindow.__init__(self, *args)

        self.initMenus ()
        self.initToolBar ()
        self.initStatusBar ()

    def initMenus (self):
        fileMenu = TQPopupMenu (self)

        # "File" menu items
        fileMenu.insertItem (i18n ("New"), self.slotNew, TDEStdAccel.openNew ().keyCodeQt ())
        fileMenu.insertItem (i18n ("Open"), self.slotOpen, TDEStdAccel.open ().keyCodeQt ())
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("Save"), self.slotSave, TDEStdAccel.save ().keyCodeQt ())
        fileMenu.insertItem (i18n ("SaveAs"), self.slotSaveAs)
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("Print"), self.slotPrint, TDEStdAccel.print_ ().keyCodeQt ())
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("&Quit"), self.slotQuit, TDEStdAccel.quit ().keyCodeQt ());

        self.menuBar ().insertItem (i18n ("&File"), fileMenu)

        editMenu = TQPopupMenu (self)

        # "Edit" menu items
        editMenu.insertItem (i18n ("Undo"), self.slotUndo, TDEStdAccel.undo ().keyCodeQt ())
        editMenu.insertItem (i18n ("Redo"), self.slotRedo, TDEStdAccel.redo ().keyCodeQt ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Cut"), self.slotCut, TDEStdAccel.cut ().keyCodeQt ())
        editMenu.insertItem (i18n ("Copy"), self.slotCopy, TDEStdAccel.copy ().keyCodeQt ())
        editMenu.insertItem (i18n ("Paste"), self.slotPaste, TDEStdAccel.paste ().keyCodeQt ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Find"), self.slotFind, TDEStdAccel.find ().keyCodeQt ())
        editMenu.insertItem (i18n ("Find Next"), self.slotFindNext, TDEStdAccel.findNext ().keyCodeQt ())
        editMenu.insertItem (i18n ("Replace"), self.slotReplace, TDEStdAccel.replace ().keyCodeQt ())

        self.menuBar ().insertItem (i18n ("&Edit"), editMenu)

        helpMenu = self.helpMenu ("")
        self.menuBar ().insertItem (i18n ("&Help"), helpMenu)

    def initToolBar (self):
        icons = TDEIconLoader ()

        self.toolBar ().insertButton (icons.loadIcon ("filenew", TDEIcon.Toolbar), TOOLBAR_NEW, TQ_SIGNAL ("clicked (int)"), self.slotNew,\
                                                       True, "New")
        self.toolBar ().insertButton (icons.loadIcon ("fileopen", TDEIcon.Toolbar), TOOLBAR_OPEN, TQ_SIGNAL ("clicked (int)"), self.slotOpen,\
                                                       True, "Open")
        self.toolBar ().insertButton (icons.loadIcon ("filesave", TDEIcon.Toolbar), TOOLBAR_SAVE, TQ_SIGNAL ("clicked (int)"), self.slotSave,\
                                                       True, "Save")
        self.toolBar ().insertButton (icons.loadIcon ("editcut", TDEIcon.Toolbar), TOOLBAR_CUT, TQ_SIGNAL ("clicked (int)"), self.slotCut,\
                                                       True, "Cut")
        self.toolBar ().insertButton (icons.loadIcon ("editcopy", TDEIcon.Toolbar), TOOLBAR_COPY, TQ_SIGNAL ("clicked (int)"), self.slotCopy,\
                                                       True, "Copy")
        self.toolBar ().insertButton (icons.loadIcon ("editpaste", TDEIcon.Toolbar), TOOLBAR_PASTE, TQ_SIGNAL ("clicked (int)"), self.slotPaste,\
                                                       True, "Paste")

    def initStatusBar (self):
        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)


#-------------------- slots -----------------------------------------------

    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = TDEAboutData ("", "",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
