/*
 * This file is part of the Polkit-tqt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * polkit-tqt-listener based on code by David Zeuthen <davidz@redhat.com>
 */

#include "polkit-tqt-listener_p.h"
#include <stdio.h>


using namespace PolkitTQt::Agent;

struct _PolkitTQtListener
{
  PolkitAgentListener parent_instance;
};

struct _PolkitTQtListenerClass
{
  PolkitAgentListenerClass parent_class;
};

static void polkit_tqt_listener_initiate_authentication(PolkitAgentListener *agent_listener,
        const gchar *action_id, const gchar *message, const gchar *icon_name,
        PolkitDetails *details, const gchar *cookie, GList *identities,
        GCancellable *cancellable, GAsyncReadyCallback callback, gpointer user_data);

static gboolean polkit_tqt_listener_initiate_authentication_finish(PolkitAgentListener *listener,
        GAsyncResult *res, GError **error);

G_DEFINE_TYPE(PolkitTQtListener, polkit_tqt_listener, POLKIT_AGENT_TYPE_LISTENER);

static void polkit_tqt_listener_init(PolkitTQtListener *listener)
{
}

static void polkit_tqt_listener_finalize(GObject *object)
{
  PolkitTQtListener *listener = POLKIT_TQT_LISTENER(object);
  if (G_OBJECT_CLASS(polkit_tqt_listener_parent_class)->finalize != nullptr)
  {
    G_OBJECT_CLASS(polkit_tqt_listener_parent_class)->finalize(object);
  }
}

static void polkit_tqt_listener_class_init(PolkitTQtListenerClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
  PolkitAgentListenerClass *listener_class = POLKIT_AGENT_LISTENER_CLASS(klass);

  gobject_class->finalize = polkit_tqt_listener_finalize;

  listener_class->initiate_authentication        = polkit_tqt_listener_initiate_authentication;
  listener_class->initiate_authentication_finish = polkit_tqt_listener_initiate_authentication_finish;
}

PolkitAgentListener *polkit_tqt_listener_new(void)
{
  return POLKIT_AGENT_LISTENER(g_object_new(POLKIT_TQT_TYPE_LISTENER, nullptr));
}

static void cancelled_cb(GCancellable *cancellable, gpointer user_data)
{
  ListenerAdapter::instance()->cancelled_cb((PolkitAgentListener *)user_data);
}

static void polkit_tqt_listener_initiate_authentication(PolkitAgentListener *agent_listener,
        const gchar *action_id, const gchar *message, const gchar *icon_name,
        PolkitDetails *details, const gchar *cookie, GList *identities,
        GCancellable *cancellable, GAsyncReadyCallback callback, gpointer user_data)
{
  tqDebug("Listener adapter polkit_tqt_listener_initiate_authentication");
  PolkitTQtListener *listener = POLKIT_TQT_LISTENER(agent_listener);

  // The result of asynchronous method will be created here and it will be pushed to the listener.
  GSimpleAsyncResult *result = g_simple_async_result_new((GObject*)listener, callback, user_data,
          agent_listener);
  tqDebug("GSimpleAsyncResult: %p", result);

  ListenerAdapter::instance()->polkit_tqt_listener_initiate_authentication(agent_listener,
          action_id, message, icon_name, details, cookie, identities, cancellable, result);
  if (cancellable != nullptr)
  {
    g_signal_connect(cancellable, "cancelled", G_CALLBACK(cancelled_cb), agent_listener);
  }
}

static gboolean polkit_tqt_listener_initiate_authentication_finish(PolkitAgentListener *listener,
        GAsyncResult *res, GError **error)
{
  tqDebug("Listener adapter polkit_tqt_listener_initiate_authentication_finish");
  return ListenerAdapter::instance()->polkit_tqt_listener_initiate_authentication_finish(listener,
          res, error);
}
