/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef VPNACCOUNTDATA_H
#define VPNACCOUNTDATA_H

#include <tqstring.h>
#include <tqobject.h>
#include <tqstringlist.h>

/**
* holds the data for a account
* @author Christoph Thielecke
*/
class VpnAccountData : public TQObject
{
public:
	enum ConnectionType {cisco=0, racoon=1, freeswan=2, pptp=3,openvpn=4,l2tpd_racoon=5,l2tpd_freeswan=6,ciscoorig=7,vtun=8,ssh=9,other=99};
	enum AuthenticationType {cert=0, psk=1, hybrid=2, unknownauth=99};
	enum L2tpDaemonType  { l2tpd=0, openl2tp=1};

	/**
	 * Konstruktor
	 * @param ConnType Type (cisco, freeswan,racoon, etc)
	 * @param Name The name of the account
	 * @param Gateway The hostname/IP of the VPN gateway
	 * @return nothing
	 */
	VpnAccountData( ConnectionType ConnType, const TQString &Name);

	/**
	* Destruktor
	*/
	~VpnAccountData();

	/*
	Copy constructor
	*/
	VpnAccountData(const VpnAccountData&);

	ConnectionType getConnectionType() const; //< returns Connection type
	TQString getName() const; //< returns Name
	TQString getGateway() const; //< returns Gateway
	TQString getID() const; //< returns ID
	TQString getUserName() const; //< returns UserName
	TQString getUserPassword() const; //< returns UserPassword
	TQString getIkeGroup() const; //< returns IkeGroup
	TQString getEncryptionAlgorithm() const; //< returns EncryptionAlgorithm
	TQString getAuthenticationAlgorithm() const; //< returns AuthenticationAlgorithm
	TQString getPerfectForwardSecrety() const; //< returns PerfectForwardSecrecy
	TQString getNtDomainName() const; //< returns NtDomainName
	TQString getApplicationVersion() const; //< returns ApplicationVersion
	TQString getRemoteNetAddr() const; //<returns remoteNetAddr
	TQString getRemoteNetMask() const; //<returns remoteNetMask
	TQString getPreSharedKey() const; // returns PreSharedKey
	TQString getX509Certificate() const; //< returns x509 certificate
	TQString getCaCertificate() const; //< returns x509 certificate (CA)
	TQString getNetworkDevice() const; //< returns NetworkDevice
	TQString getCertPath() const; //<returns CertPath
	TQString getSpecialRemoteID() const; //< returns SpecialRemoteID;
	TQString getSpecialLocalID() const; //< returns SpecialLocalID;
	TQString getLocalIDType() const; //< return Local ID type for racoon
	TQString getRemoteIDType() const; //< return Remote ID type for racoon
	TQString getPingHostIP() const; //< returns last part of IP (host) for ping test
	TQString getPrivateKeyPass() const; //< returns PrivateKeyPass
	TQString getPrivateKey() const; //< returns PrivateKey
	TQString getDnsServer() const;
	TQString getLocalVirtualIP() const; //< returns LocalVirtualIP
	TQString getRemoteVirtualIP() const; //< returns RemoteVirtualIP (tun at openvpn,pptp) or Netmask for (tap at openvpn)
	TQString getPreSharedKeyFile() const;
	TQString getCommandBeforeConnect() const;
	TQString getCommandAfterConnect() const;
	TQString getCommandBeforeDisconnect() const;
	TQString getCommandAfterDisconnect() const;
	TQString getSpecialServerCertificate() const;
	TQString getHashAlgo() const;
	TQString getTunnelDeviceType() const;
	TQString getDescription() const;
	TQString getNsCertType() const;
	TQString getVirtualIP() const;
	TQString getUserdefiniedCipher() const;
	TQString getTlsAuthFile() const;
	TQString getHttpProxy() const;
	TQString getExchangeMode() const;
	TQString getTlsRemoteHost() const;
	TQString getRightNextHop() const;
	TQString getLeftNextHop() const;
	TQString getHttpProxyAuthType() const;
	TQString getHttpProxyUser() const;
	TQString getHttpProxyPass() const;
	TQString getPkcs11Providers() const;
	TQString getPkcs11SlotType() const;
	TQString getPkcs11Slot() const;
	TQString getPkcs11IdType() const;
	TQString getPkcs11Id() const;
	TQString getPkcs11SignMode() const;
	TQString getAuthMethod() const;
	TQString getSearchDomainInResolvConf() const;
	TQString getDomainInResolvConf() const;
	TQString getAuthenticationDirection() const;
	TQString getCiscoNatMode() const;
	TQString getIpsecEsp() const;
	TQString getIpsecIke() const;
	TQString getVtunProfile() const;
	TQString getIpsecVpnMode() const;
	TQString getLeftSourceIp() const;
	TQString getRightSourceIp() const;
	TQString getVirtualSubnetworks() const;
	TQString getSshConfigRemoteScript() const;

	int getLocalPort() const; //< returns LocalPort
	int getRemotePort() const; //< returns RemotePort
	int getUdpPort() const; //< returns UdpPort
	int getMtu() const;
	int getMru() const;
	int getUserdefinedPort() const;
	int getConnectionStatusCheckSuccessCount() const;
	int getConnectionStatusInterval() const;
	int getHttpProxyPort() const;
	int getHttpProxyTimeout() const;
	int getReconnectDelay() const;
	int getMssfix() const;
	int getFragment() const;
	int getPeerTimeout() const;
	int getCommandAfterConnectDelayTime() const;
	int getDpdIdleTimeout() const;
	int getMaxConnectTries() const;
	int getRenegSec() const;
	int getTunnelPing() const;
	int getTunnelPingRestart() const;

	AuthenticationType getAuthType() const; //< returns AuthType
	TQStringList getAdditionalNetworkRoutes() const;
	bool getSaveUserPassword() const; //< returns saveUserPassword
	bool getSavePsk() const; //< returns savePSK
	bool getUseSingleDes() const; //< returns useSingleDes
	bool getUseIkeGroup() const; //< returns useIkeGroup
	bool getUsePerfectForwardSecrety() const; //< returns usePerfectSecrecy
	bool getUseNtDomainName() const; //< returns useNtDomainName
	bool getUseApplicationVersion() const; //< returns useApplicationVersion
	bool getUseLocalPort() const; //< returns useLocalPort
	bool getUseRemotePort() const; //< returns useRemotePort
	bool getUseAdvancedSettings() const; //< returns useAdvancedSettings
	bool getUseGlobalIpsecSecret() const; //< returns useGlobalIpsecSecret
	bool getDoPingIP() const; //< returns doPingIP
	bool getUseSpecialRemoteID() const; //< returns useSpecialRemoteID
	bool getUseSpecialLocalID() const; //< returns useSpecialLocalID
	bool getUseUdp() const; //< returns useUdp
	bool getUseUdpPort() const; //< returns useUdpPort
	bool getUseDnsUpdate() const;
	bool getUseDnsServer() const;
	bool getRefuse40BitEncryption() const;
	bool getRefuse128BitEncryption() const;
	bool getAllowStatefulMode() const;
	bool getRequireMppe() const;
	bool getUseNoIpDefault() const;
	bool getDisableMPPEComp() const;
	bool getExecuteCmdBeforeConnect() const;
	bool getExecuteCmdAfterConnect() const;
	bool getExecuteCmdBeforeDisconnect() const;
	bool getExecuteCmdAfterDisconnect() const;
	bool getUseNoBsdComp() const;
	bool getUseNoDeflate() const;
	bool getReplaceDefaultRoute() const;
	bool getUseMtu() const;
	bool getUseMru() const;
	bool getUseVirtualIP() const;
	bool getPskIsInFile() const;
	bool getUseAdditionalNetworkRoutes() const;
	bool getUseSpecialServerCertificate() const;
	bool getUseUserdefinedPort() const;
	bool getUseNsCertType() const;
	bool getUseConnectionStatusCheck() const;
	bool getDoReconnectAfterConnectionLost() const;
	bool getDisableLzoCompression() const;
	bool getAuthWithUsernameAndPassword() const;
	bool getAllowEmptyGroupPassword() const;
	bool getUseUserdefiniedCipher() const;
	bool getUseRedirectGateway() const;
	bool getUseTlsAuth() const;
	bool getUseHttpProxy() const;
	bool getDontSaveUsername() const;
	bool getUseModeConfig() const;
	bool getUseReconnectDelay() const;//< if true kvpnc will wait ReconnectDelay before do reconnect instead of immediately reconnect
	bool getUseTlsRemoteHost() const;
	bool getDisableOpportunisticEncryption() const;
	bool getUseMssfix() const;
	bool getUseFragment() const;
	bool getDisableCcp() const;
	bool getUseSmartcard() const;
	bool getUseXauthInteractive() const;
	bool getSavePrivateKeyPassword() const;
	bool getUseHttpProxyAuth () const;
	bool getUseOnlyCaCertAndUserAuth() const;
	bool getUseMailAddressAsIdentifier() const;
	bool getUseRightNextHop() const;
	bool getUseLeftNextHop() const;
	bool getUsePkcs11Providers() const;
	bool getAllowEmptyPrivateKeyPassword() const;
	bool getAllowIpAddressChangeOfPeer() const;
	bool getUseSearchDomainInResolvConf() const;
	bool getUseDomainInResolvConf() const;
	bool getDisableDataEncryption() const;
	bool getUseAuthenticationAlgorithm() const;
	bool getFixPathMtuDiscoveryProblem() const;
	bool getUseRemoteNetwork() const;
	bool getDisableHeaderCompression() const;
	bool getDisableMagicNumberNegotiation() const;
	bool getDisableIpx() const;
	bool getDisableProtocolFieldCompression() const;
	bool getDisableAdressControlCompression() const;
	bool getUseCustomIke() const;
	bool getUseCustomEsp() const;
	bool getVerifyCaCert() const;
	bool getUseDpdIdleTimeout() const;
	bool getHideGroupPasswordInAccountDataDialog() const;
	bool getUseLeftSourceIp() const;
	bool getUseRightSourceIp() const;
	bool getUseVirtualSubnetworks() const;
	bool getDisablePushFromServer () const;
	bool getDisableBind() const;
	bool getUseRenegSec() const;
	bool getUseTunnelPing() const;
	bool getUseTunnelPingRestart() const;
	bool getRequireEap() const;
	bool getUseSshConfigRemoteScript() const;
	bool getAskUserPasswordOnEachConnect() const;
	bool getUseCiscoCertStore() const;
	bool getUseNat() const;
	L2tpDaemonType getL2tpDaemon() const;




	/**
	 *   Sets the connection type
	 * @param type The type
	 */
	void setConnectionType( ConnectionType type );

	/**
	 *   Sets the name of the profile
	 * @param Name The new name
	 */
	void setName( const TQString &Name );

	/**
	 *   Sets the IP/DNS name of the gateway
	 * @param Gateway the IP/DNS name
	 */
	void setGateway( const TQString &Gateway );

	/**
	 *   Sets the remote ID (cisco)
	 * @param ID The ID
	 */
	void setID( const TQString &ID );

	/**
	 *   Sets the group password (cisco)
	 * @param GroupPassword The password
	 */
	void setGroupPassword( const TQString &GroupPassword );

	/**
	 *   Sets the username (cisco)
	 * @param Username The username
	 */
	void setUserName( const TQString &Username );

	/**
	 *   Sets the user password
	 * @param UserPassword The password
	 */
	void setUserPassword( const TQString &UserPassword );

	/**
	 *   Sets if user password should be stored or not
	 * @param saveUserPassword True if password should be stored
	 */
	void setSaveUserPassword( bool saveUserPassword );

	/**
	 *  Sets if group password should be stored or not
	 * @param saveGroupPassword True if password should be stored
	 */
	void setSavePsk( bool savePsk );

	/**
	 *   Sets the IKE group (cisco)
	 * @param IkeGroup The group
	 */
	void setIkeGroup( const TQString &IkeGroup );
	void setEncryptionAlgorithm( const TQString &EncryptionAlgorithm );
	void setAuthenticationAlgorithm( const TQString &AuthenticationAlgorithm );

	void setPerfectForwardSecrety( const TQString &PerfectForwardSecrecy );
	void setNtDomainName( const TQString &Name );
	void setApplicationVersion( const TQString &version );
	void setUseSingleDes( bool useSingleDes );
	void setLocalPort( int port );
	void setRemotePort( int port );
	void setUseIkeGroup( bool useIkeGroup );
	void setUsePerfectForwardSecrety( bool usePerfectForwardSecrety );
	void setUseNtDomainName( bool useNtDomainName );
	void setUseApplicationVersion( bool useApplicationVersion );
	void setUseLocalPort( bool useLocalPort );
	void setUseRemotePort( bool useRemotePort );
	void setUseAdvancedSettings( bool useAdvancedSettings );
	void setUseGlobalIpsecSecret( bool useGlobalIpsecSecret );
	void setRemoteNetAddr( const TQString &RemoteNetAddr );
	void setRemoteNetMask( const TQString &RemoteNetMask );
	void setPreSharedKey( const TQString &PreSharedKey );
	void setX509Certificate( const TQString &x509Certificate );
	void setCaCertificate( const TQString &CaCertificate );
	void setNetworkDevice( const TQString &NetworkDevice );
	void setCertPath( const TQString &CertPath );
	void setAuthType( AuthenticationType authtype );
	void setDoPingIP( bool pingIP );
	void setPingHostIP( const TQString &pingHostIP );
	void setPrivateKeyPass( const TQString &PrivateKeyPass );
	void setPrivateKey( const TQString &PrivateKey );
	void setUseSpecialRemoteID( bool useSpecialRemoteID );
	void setUseSpecialLocalID( bool useSpecialLocalID );
	void setSpecialRemoteID( const TQString &SpecialRemoteID );
	void setSpecialLocalID( const TQString &SpecialLocalID );
	void setLocalIDType( const TQString &LocalIDType);
	void setRemoteIDType( const TQString &RemoteIDType);
	void setUseUdp( bool useUdp );
	void setUseUdpPort( bool useUdpPort);
	void setUdpPort( int UdpPort );
	void setUseDnsUpdate(bool useDnsUpdate );
	void setUseDnsServer(bool useDnsServer );
	void setDnsServer(const TQString &DnsServer );
	void setRefuse40BitEncryption(bool refuse40BitEncryption );
	void setRefuse128BitEncryption(bool refuse128BitEncryption );
	void setAllowStatefulMode(bool allowStatefulMode );
	void setRequireMppe(bool requireMppe );
	void setUseNoIpDefault (bool useNoIpDefault );
	void setDisableMPPEComp (bool disableMPPEComp );
	void setLocalVirtualIP( const TQString &LocalVirtualIP );
	void setRemoteVirtualIP( const TQString &RemoteVirtualIP );
	void setPreSharedKeyFile( const TQString &PreSharedKeyFile );
	void setExecuteCmdBeforeConnect(bool executeCmdBeforeConnect);
	void setExecuteCmdAfterConnect(bool executeCmdAfterConnect);
	void setExecuteCmdBeforeDisconnect(bool executeCmdBeforeDisonnect);
	void setExecuteCmdAfterDisconnect(bool executeCmdAfterDisonnect);
	void setCommandBeforeConnect(const TQString &CommandBeforeConnect);
	void setCommandAfterConnect(const TQString &CommandAfterConnect);
	void setCommandBeforeDisconnect(const TQString &CommandBeforeDisconnect);
	void setCommandAfterDisconnect(const TQString &CommandAfterDisconnect);
	void setUseNoBsdComp(bool useNoBsdComp);
	void setUseNoDeflate(bool useNoDeflate);
	void setReplaceDefaultRoute(bool setReplaceDefaultRoute);
	void setUseMtu(bool useMtu);
	void setUseMru(bool useMru);
	void setMtu (int Mtu);
	void setMru (int Mru);
	void setUseVirtualIP (bool useVirtualIP);
	void setVirtualIP( const TQString &VirtualIP );
	void setPskIsInFile(bool PskIsInFile );
	void setUseAdditionalNetworkRoutes( bool useAdditionalNetworkRoutes );
	void setAdditionalNetworkRoutes( TQStringList AdditionalNetworkRoutes );
	void setUseSpecialServerCertificate(bool useSpecialServerCertificate);
	void setSpecialServerCertificate(const TQString &SpecialServerCertificate);
	void setHashAlgo(const TQString &HashAlgo);
	void setTunnelDeviceType(const TQString &TunnelDeviceType);
	void setUseUserdefinedPort(bool useUserdefinedPort);
	void setUserdefinedPort(int UserdefinedPort);
	void setDescription( const TQString &Description );
	void setNsCertType( const TQString &NsCertType );
	void setUseNsCertType ( bool useNsCertType );
	void setUseConnectionStatusCheck ( bool useConnectionStatusCheck );
	void setConnectionStatusCheckSuccessCount ( int connectionStatusCheckSuccessCount );
	void setConnectionStatusInterval ( int connectionStatusInterval );
	void setDoReconnectAfterConnectionLost( bool doReconnectAfterConnectionLost );
	void setDisableLzoCompression( bool disableLzoCompression);
	void setAuthWithUsernameAndPassword( bool authWithUsernameAndPassword );
	void setAllowEmptyGroupPassword( bool allowEmptyGroupPassword );
	void setUseUserdefiniedCipher( bool useUserdefiniedCipher );
	void setUserdefiniedCipher( TQString UserdefiniedCipher );
	void setUseRedirectGateway( bool useRedirectGateway );
	void setUseTlsAuth( bool useTlsAuth );
	void setTlsAuthFile( TQString TlsAuthFile );
	void setUseHttpProxy( bool useHttpProxy );
	void setHttpProxy( TQString HttpProxy );
	void setHttpProxyPort ( int HttpProxyPort );
	void setHttpProxyTimeout ( int HttpProxyTimeout );
	void setDontSaveUsername( bool dontSaveUsername );
	void setUseModeConfig( bool useModeConfig );
	void setExchangeMode( TQString ExchangeMode );
	void setUseReconnectDelay( bool useReconnectDelay );
	void setReconnectDelay( int ReconnectDelay );
	void setUseTlsRemoteHost( bool useTlsRemoteHost );
	void setTlsRemoteHost( TQString TlsRemoteHost );
	void setDisableOpportunisticEncryption( bool );
	void setRightNextHop( TQString RightNextHop );
	void setLeftNextHop( TQString LeftNextHop );
	void setUseMssfix( bool useMssfix );
	void setUseFragment( bool useFragment);
	void setMssfix( int Mssfix );
	void setFragment( int Fragment );
	void setPeerTimeout( int PeerTimeout );
	void setDisableCcp( bool disableCcp );
	void setUseSmartcard( bool useSmartcard );
	void setUseXauthInteractive( bool useXauthInteractive );
	void setSavePrivateKeyPassword ( bool savePrivateKeyPassword );
	void setUseHttpProxyAuth (bool useHttpProxyAuth );
	void setHttpProxyAuthType(TQString HttpProxyAuthType );
	void setHttpProxyUser(TQString HttpProxyUser );
	void setHttpProxyPass(TQString HttpProxyPass );
	void setUseOnlyCaCertAndUserAuth(bool useOnlyCaCertAndUserAuth );
	void setUseMailAddressAsIdentifier(bool useMailAddressAsIdentifier );
	void setUseRightNextHop(bool useRightNextHop);
	void setUseLeftNextHop (bool useLeftNextHop);
	void setPkcs11Providers(TQString Pkcs11Providers);
	void setPkcs11SlotType(TQString Pkcs11SlotType);
	void setPkcs11Slot(TQString Pkcs11Slot);
	void setPkcs11IdType(TQString Pkcs11IdType);
	void setPkcs11Id(TQString Pkcs11Id);
	void setPkcs11SignMode(TQString Pkcs11SignMode);
	void setUsePkcs11Providers(bool usePkcs11Providers);
	void setAllowEmptyPrivateKeyPassword (bool allowEmptyPrivateKeyPassword );
	void setAllowIpAddressChangeOfPeer( bool allowIpAddressChangeOfPeer );
	void setAuthMethod( TQString AuthMethod );
	void setCommandAfterConnectDelayTime( int CommandAfterConnectDelayTime );
	void setUseSearchDomainInResolvConf( bool useSearchDomainInResolvConf );
	void setUseDomainInResolvConf( bool useDomainInResolvConf );
	void setSearchDomainInResolvConf(TQString SearchDomainInResolvConf );
	void setDomainInResolvConf(TQString DomainInResolvConf );
	void setAuthenticationDirection(TQString AuthenticationDirection );
	void setCiscoNatMode(TQString CiscoNatMode );
	void setIpsecEsp(TQString IpsecEsp);
	void setIpsecIke(TQString IpsecIke);
	void setVtunProfile(TQString VtunProfile);
	void setDisableDataEncryption(bool disableDataEncryption);
	void setUseAuthenticationAlgorithm(bool useAuthenticationAlgorithm);
	void setFixPathMtuDiscoveryProblem( bool fixPathMtuDiscoveryProblem);
	void setUseRemoteNetwork(bool useRemoteNetwork);
	void setIpsecVpnMode(TQString IpsecVpnMode);
	void setDisableHeaderCompression(bool disableHeaderCompression);
	void setDisableMagicNumberNegotiation(bool disableMagicNumberNegotiation);
	void setDisableIpx(bool disableIpx);
	void setDisableProtocolFieldCompression(bool disableProtocolFieldCompression);
	void setDisableAdressControlCompression(bool disableAdressControlCompression);
	void setUseCustomIke(bool useCustomIke );
	void setUseCustomEsp(bool useCustomEsp);
	void setVerifyCaCert(bool verifyCaCert);
	void setUseDpdIdleTimeout(bool useDpdIdleTimeout);
	void setDpdIdleTimeout(int DpdIdleTimeout);
	void setHideGroupPasswordInAccountDataDialog(bool hideGroupPasswordInAccountDataDialog);
	void setMaxConnectTries(int MaxConnectTries);
	void setL2tpDaemon(L2tpDaemonType L2tpDaemon );
	void setUseLeftSourceIp(bool useLeftSourceIp);
	void setUseRightSourceIp(bool useLeftRightIp);
	void setLeftSourceIp(TQString LeftSourceIp);
	void setRightSourceIp(TQString RightSourceIp);
	void setUseVirtualSubnetworks(bool useVirtualSubnetworks);
	void setVirtualSubnetworks(TQString VirtualSubnetworks);
	void setDisablePushFromServer( bool disablePushFromServer);
	void setDisableBind( bool disableBind );
	void setUseRenegSec(bool useRenegSec);
	void setRenegSec(int RenegSec);
	void setUseTunnelPing(bool useTunnelPing);
	void setTunnelPing(int TunnelPing);
	void setUseTunnelPingRestart(bool useTunnelPingRestart);
	void setTunnelPingRestart(int TunnelPingRestart);
	void setRequireEap(bool requireEap);
	void setUseSshConfigRemoteScript(bool useSshConfigRemoteScript);
	void setSshConfigRemoteScript( TQString SshConfigRemoteScript);
	void setAskUserPasswordOnEachConnect ( bool askUserPasswordOnEachConnect );
	void setUseCiscoCertStore(bool useCiscoCertStore);
	void setUseNat(bool useNat);

protected:
	TQString Name; //< Name of the profile
	TQString Gateway; //< IP/DNS name of the gateway
	TQString ID; //< ID of remote gateway
	TQString Username; //< Username (cisco)
	TQString UserPassword; //< User password (cisco)
	TQString IkeGroup; //< DH group for PFS (cisco,racoon)
	TQString PerfectForwardSecrecy; //< Type of PFS (cisco, racoon)
	TQString EncryptionAlgorithm; // phase 2 (ipsec)
	TQString AuthenticationAlgorithm; // phase 2 (ipsec)
	TQString NtDomainName; //< NT domain name for authentication (cisco/pptp)
	TQString ApplicationVersion; //< userdefined application version (cisco)
	TQString RemoteNetAddr; //< Remote network addr of VPN
	TQString RemoteNetMask; //< Remote network mask of VPN
	TQString PreSharedKey; //< Pre shared key (freeswan/racoon)
	TQString x509Certificate; //< Path to X.509 certificate file
	TQString CaCertificate; //< Path to CA certificate file
	TQString NetworkDevice; //< Network device
	TQString PrivateKeyPass; //< Password for private key
	TQString PrivateKey; //< Path to private key file
	TQString CertPath; //< Global certificate path
	TQString AuthType; //< Authentication type (cert/psk)
	TQString pingHostIP; //< IP of the host which should be pinged
	TQString SpecialRemoteID; //< userdefined ID of remote gateway
	TQString SpecialLocalID; //< userdefined ID of remote gateway
	TQString LocalIDType; //< type of the local ID for racoon
	TQString RemoteIDType; //< type of the remote ID for racoon
	TQString LocalVirtualIP; //< Local virtual IP for tunnel (openvpn)
	TQString RemoteVirtualIP; //< Remote virtual IP for tunnel (openvpn)
	TQString PreSharedKeyFile; //< for openvpn
	TQString HashAlgo; // Hash algorithm for racoon
	TQString UseUserdefiniedCipher; //< Cipher for OpenVPN
	TQString DnsServer; //< userdefined DNS server for pptp
	TQString SearchDomainInResolvConf;
	TQString DomainInResolvConf;
	TQString CommandBeforeConnect;
	TQString CommandAfterConnect;
	TQString CommandBeforeDisconnect;
	TQString CommandAfterDisconnect;
	TQString Description; //< Description of the profile
	TQString SpecialServerCertificate;
	TQString VirtualIP; //< Virtual IP for freeswan/racoon
	TQString TunnelDeviceType; //< Type of tunnel device which should be used e.g. tun or tap  for openvpn
	TQString NsCertType; //< openvpn
	TQString UserdefiniedCipher; //< Ciphers for OpenVPN
	TQString TlsAuthFile;
	TQString HttpProxy;
	TQString ExchangeMode; //< IKE exchange mode
	TQString TlsRemoteHost;
	TQString RightNextHop; // freeswan
	TQString LeftNextHop; // freeswan
	TQString HttpProxyAuthType;
	TQString HttpProxyUser;
	TQString HttpProxyPass;
	TQString Pkcs11Providers;
	TQString Pkcs11SlotType;
	TQString Pkcs11Slot;
	TQString Pkcs11IdType;
	TQString Pkcs11Id;
	TQString Pkcs11SignMode;
	TQString AuthMethod; //< authorization method for pptp (chap/pap)
	TQString AuthenticationDirection; //< openvpn key and tls-auth direction (none,0,1)
	TQString CiscoNatMode;
	TQString IpsecEsp; // IPsec ESP mode
	TQString IpsecIke; //< IPsec IKE mode
	TQString VtunProfile;
	TQString IpsecVpnMode; //< IPSec tunnel type (transport | tunnel)
	TQString LeftSourceIp;
	TQString RightSourceIp;
	TQString VirtualSubnetworks;
	TQString SshConfigRemoteScript;

	TQStringList AdditionalNetworkRoutes;

	bool saveUserPassword; //< True if the user password should be stored (cisco)
	bool savePsk; //< True if the PSK should be stored
	bool useAdvancedSettings; //< True if advanced settings should be used (cisco)
	bool useIkeGroup; //< True if userdefined IKE group should be used
	bool usePerfectForwardSecrety; //< True if userdefined PFS should be used
	bool useNtDomainName; //< True if NT domain name should eb used for authentication
	bool useApplicationVersion; //< True if userdefined application version should be used
	bool useLocalPort; //< True if userdefined local port should be used
	bool useRemotePort; //< True if userdefined remote port should be used
	bool useSingleDes; //< True if DES instead of 3DES should be used
	bool useGlobalIpsecSecret; //< True if global group password from /etc/vpnc.conf should be used
	bool doPingIP; //< True if pingHostIP should be pinged after connection is established
	bool useSpecialRemoteID; //< True if userdefined ID of remote gateway instead of certificate issuer should be used
	bool useSpecialLocalID; //< True if userdefined ID of local instead of certificate client should be used
	bool useUdp; //< True if NAT-T should be used
	bool useUdpPort; //< True if userdefined UDP port should be used
	bool useDnsUpdate; //< False if we don't update resolv.conf
	bool useDnsServer; //< True if userdefined DNS server should be used
	bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
	bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
	bool allowStatefulMode;
	bool requireMppe; //< True if MPPE is required (pptp)
	bool useNoIpDefault;
	bool disableMPPEComp;
	bool executeCmdBeforeConnect;
	bool executeCmdAfterConnect;
	bool executeCmdBeforeDisconnect;
	bool executeCmdAfterDisconnect;
	bool useNoBsdComp;
	bool useNoDeflate;
	bool replaceDefaultRoute; //< for PPTP
	bool useMtu;
	bool useMru;
	bool useVirtualIP; //< freeswan/racoon
	bool PskIsInFile; //< Read PSK from file
	bool useAdditionalNetworkRoutes;
	bool useSpecialServerCertificate;
	bool useUserdefinedPort;
	bool useNsCertType; // <openvpn
	bool useConnectionStatusCheck; //< if true it checks if the gateway is alive within a given time
	bool doReconnectAfterConnectionLost;
	bool disableLzoCompression;
	bool authWithUsernameAndPassword; //< openvpn, xauth
	bool allowEmptyGroupPassword; //< allows empty group password for vpnc
	bool useUserdefiniedCipher;
	bool useRedirectGateway;//< redirect gateway for openvpn
	bool useTlsAuth; //< Add an additional layer of HMAC authentication on top of the TLS control channel to protect against DoS attacks (openvpn)
	bool useHttpProxy;
	bool dontSaveUsername;
	bool useModeConfig;
	bool useReconnectDelay;
	bool useTlsRemoteHost;
	bool disableOpportunisticEncryption;
	bool useMssfix;
	bool useFragment;
	bool disableCcp;
	bool useSmartcard;
	bool useXauthInteractive;
	bool savePrivateKeyPassword;
	bool useHttpProxyAuth;
	bool useOnlyCaCertAndUserAuth; //< use only a CA certificate and authentication with username and password (openvpn)
	bool useMailAddressAsIdentifier; //< x509 cert
	bool useRightNextHop;
	bool useLeftNextHop;
	bool usePkcs11Providers;
	bool allowEmptyPrivateKeyPassword;
	bool allowIpAddressChangeOfPeer;
	bool useSearchDomainInResolvConf;
	bool useDomainInResolvConf;
	bool disableDataEncryption;
	bool useAuthenticationAlgorithm;
	bool fixPathMtuDiscoveryProblem; //< see http://pptpclient.sourceforge.net/howto-diagnosis.phtml#connections_freeze
	bool useRemoteNetwork; //< specify a remote network
	bool disableHeaderCompression; //< Disable Van Jacobson style TCP/IP header compression in both the transmit and the receive direction.
	bool disableMagicNumberNegotiation; //< Disable magic number negotiation. With this option, pppd cannot detect a looped-back line. This option should only be needed if the peer is buggy.
	bool disableIpx; //< Disable the IPXCP and IPX protocols.
	bool disableProtocolFieldCompression; //< Disable protocol field compression negotiation in both the receive and the transmit direction. 
	bool disableAdressControlCompression; //< Disable Address/Control compression in both directions (send and receive).
	bool useCustomIke;
	bool useCustomEsp;
	bool verifyCaCert; //< verify ca cert of remote host on racoon
	bool useDpdIdleTimeout; //< dead peer detection idle timeout (vpnc)
	bool hideGroupPasswordInAccountDataDialog;
	bool useLeftSourceIp;
	bool useRightSourceIp;
	bool useVirtualSubnetworks;
	bool disablePushFromServer; //< openvpn, no pull mode
	bool disableBind; //< Do not bind to local address and port. The IP stack will allocate a dynamic port for returning packets. Since the value of the dynamic port could not be known in advance by a peer, this option is only suitable for peers which will be initiating connections by using the --remote option.
	bool useRenegSec;
	bool useTunnelPing;
	bool useTunnelPingRestart;
	bool requireEap;
	bool useSshConfigRemoteScript;
	bool askUserPasswordOnEachConnect; //< ask for user password on each connect
	bool useCiscoCertStore;
	bool useNat;
	int Mtu;
	int Mru;
	int UdpPort; //< Port number of UDP port
	int LocalPort; //< userdefined local port
	int RemotePort; //< userdefined remote port
	int UserdefinedPort;
	int connectionStatusCheckSuccessCount; //< in which count a check must be successful
	int connectionStatusInterval; //< interval which is used for check
	int HttpProxyPort;
	int HttpProxyTimeout;
	int ReconnectDelay;
	int MaxConnectTries;
	int Mssfix;
	int Fragment;
	int PeerTimeout; // timeout given from peer (cisco for example gives that)
	int CommandAfterConnectDelayTime; //< time which is wait after connect before the cmd after connect should be executed
	int DpdIdleTimeout;
	int RenegSec;
	int TunnelPing;
	int TunnelPingRestart;

public:
	ConnectionType connectiontype; //< Type of the connection (cisco, freeswan, racoon, etc.)
	AuthenticationType authtype; //< Type of authentication (cert, psk)
	L2tpDaemonType L2tpDaemon;

};

#endif
