/***************************************************************************
 *   Copyright (C) 2007 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilesshoptions.h"

#include <klineedit.h>
#include <kcombobox.h>
#include <tdemessagebox.h>
#include <kurlrequester.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>

#include <tqlabel.h>
#include "widgetnotifyhelper.h"
#include <iostream>

ProfileSshOptions::ProfileSshOptions(TQWidget *parent)
		: ProfileSshOptionsBase(parent)
{
	WidgetNotifyHelper h;
	h.setupChangedAction(this);
	dialogModified=false;
}


ProfileSshOptions::~ProfileSshOptions()
{}

void ProfileSshOptions::usePortToggled(bool)
{
	if (UseUserdefinedRemotePortCheckBox->isChecked())
		UserdefinedRemotePortSpinBox->setEnabled(true);
	else
		UserdefinedRemotePortSpinBox->setEnabled(false);
}

void ProfileSshOptions::dialogChanged()
{
// 	std::cout << "ProfileSshOptions::dialogChanged()" << std::endl;
	dialogModified=true;
}

void ProfileSshOptions::sshKeyToggled(bool)
{
	if (AutoKeyRadioButton->isChecked())
	{
		SshKeyComboBox->setEnabled(true);
		CostumkeyURLRequester->setEnabled(false);
	}
	else
	{
		SshKeyComboBox->setEnabled(false);
		CostumkeyURLRequester->setEnabled(true);
	}
}

void ProfileSshOptions::sshAuthToggled(bool)
{
	if (AuthKeyRadioButton->isChecked() && !AuthPassRadioButton->isChecked())
	{
// 		KMessageBox::information ( this, "auth key is set", "a" );
		SshkeyButtonGroup->setEnabled(true);
	}
	if (!AuthKeyRadioButton->isChecked() && AuthPassRadioButton->isChecked())
	{
// 		KMessageBox::information ( this, "auth pass is set", "a" );
		SshkeyButtonGroup->setEnabled(false);
	}
	sshKeyToggled(true);
}



void ProfileSshOptions::useSshConfigRemoteScriptToggled(bool)
{
	if (UseSshConfigRemoteScriptCheckBox->isChecked())
		SshConfigRemoteScriptLineEdit->setEnabled(true);
	else
		SshConfigRemoteScriptLineEdit->setEnabled(false);
}

#include "profilesshoptions.moc"
