/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __LISTVIEWTOOLTIP_H__
#define __LISTVIEWTOOLTIP_H__
#include <tqtooltip.h>
#include <tqlistview.h>
#include <tqheader.h>

#include <tdelocale.h>

/**
	@author Christoph Thielecke <crissi99@gmx.de>
*/
class ListViewToolTip : public TQToolTip
{
	public:
		ListViewToolTip ( TQListView* parent );
	protected:
		void maybeTip ( const TQPoint& p );
	private:
		TQListView* listView;
};
inline ListViewToolTip::ListViewToolTip ( TQListView* parent ) : TQToolTip ( parent->viewport() ), listView ( parent ) {}
inline void ListViewToolTip::maybeTip ( const TQPoint& p )
{
	if ( !listView )
		return;
	const TQListViewItem* item = listView->itemAt ( p );
	if ( !item )
		return;
	const TQRect itemRect = listView->itemRect ( item );
	if ( !itemRect.isValid() )
		return;
	const int col = listView->header()->sectionAt ( p.x() );
	const int row = listView->header()->sectionAt ( p.y() );
	if ( col == -1 && row == -1 )
		return;

	const TQRect headerRect = listView->header()->sectionRect ( col );
	if ( !headerRect.isValid() )
		return;
// 	const TQRect cellRect ( headerRect.left(), itemRect.top(),
// 	                       headerRect.width(), itemRect.height() );
	const TQRect cellRect ( headerRect.left(), itemRect.top(), 400, 200 );
	TQString tipStr;
	tipStr = TQString ( "<h2>"+item->text ( 0 )+"</h2><ul><li>"+i18n("Path:")+" "+item->text(5)+"</li><li>"+i18n("Usability:")+" "+item->text(3)+"</li><li>"+i18n("Comment:")+ " "+item->text(6)+"</li></ul>");

	tip ( cellRect, tipStr );
}
#endif






