//
//   File : optw_mediatypes.cpp
//   Creation date : Sat Jan 20 2001 16:14:53 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "optw_mediatypes.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include "kvi_tal_tooltip.h"

#include "kvi_options.h"
#include "kvi_locale.h"

// kvi_app.cpp
extern KVIRC_API KviMediaManager * g_pMediaManager;

static void copyMediaType(KviMediaType * dst,const KviMediaType * src)
{
	dst->szFileMask              = src->szFileMask;
	dst->szIanaType              = src->szIanaType;
	dst->szDescription           = src->szDescription;
	dst->szMagicBytes            = src->szMagicBytes;
	dst->szSavePath              = src->szSavePath;
	dst->szCommandline           = src->szCommandline;
	dst->szRemoteExecCommandline = src->szRemoteExecCommandline;
	dst->szIcon                  = src->szIcon;
}

KviMediaTypeListViewItem::KviMediaTypeListViewItem(KviTalListView * w,KviMediaType * t)
: KviTalListViewItem(w)
{
	copyData(t);
}

KviMediaTypeListViewItem::~KviMediaTypeListViewItem()
{
}

void KviMediaTypeListViewItem::copyData(KviMediaType * t)
{
	copyMediaType(&m_data,t);
	setText(0,m_data.szFileMask.ptr());
	setText(1,m_data.szIanaType.ptr());
	setText(2,m_data.szDescription.ptr());	
}

KviMediaTypesOptionsWidget::KviMediaTypesOptionsWidget(TQWidget * parent)
: KviOptionsWidget(parent,"mediatypes_options_widget")
{
	createLayout(11,3);

	m_pListView = new KviTalListView(this);
	m_pListView->addColumn(__tr2qs_ctx("Pattern","options"));
	m_pListView->addColumn(__tr2qs_ctx("MIME Type","options"));
	m_pListView->addColumn(__tr2qs_ctx("Description","options"));
	m_pListView->setAllColumnsShowFocus(true);



	connect(m_pListView,TQ_SIGNAL(currentChanged(KviTalListViewItem *)),this,TQ_SLOT(currentItemChanged(KviTalListViewItem *)));

	layout()->addMultiCellWidget(m_pListView,0,0,0,2);

	TQLabel * l = new TQLabel(__tr2qs_ctx("Description:","options"),this);
	layout()->addWidget(l,1,0);
	m_pDescription = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pDescription,1,1,1,2);

	l = new TQLabel(__tr2qs_ctx("MIME type:","options"),this);
	layout()->addWidget(l,2,0);
	m_pIanaType = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pIanaType,2,2,1,2);

	l = new TQLabel(__tr2qs_ctx("File pattern:","options"),this);
	layout()->addWidget(l,3,0);
	m_pFileMask = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pFileMask,3,3,1,2);

	l = new TQLabel(__tr2qs_ctx("Magic bytes:","options"),this);
	layout()->addWidget(l,4,0);
	m_pMagicBytes = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pMagicBytes,4,4,1,2);

	l = new TQLabel(__tr2qs_ctx("Save path:","options"),this);
	layout()->addWidget(l,5,0);
	m_pSavePath = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pSavePath,5,5,1,2);

	l = new TQLabel(__tr2qs_ctx("Local open command:","options"),this);
	layout()->addWidget(l,6,0);
	m_pCommandline = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pCommandline,6,6,1,2);
#ifdef COMPILE_INFO_TIPS
	mergeTip(m_pCommandline,__tr2qs_ctx("<center>This field contains the command to execute to open a local file.<br>" \
		"<tt>$0</tt> is used in place of the filename</center>","options"));
#endif

	l = new TQLabel(__tr2qs_ctx("Remote open command:","options"),this);
	layout()->addWidget(l,7,0);
	m_pRemoteExecCommandline = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pRemoteExecCommandline,7,7,1,2);
#ifdef COMPILE_INFO_TIPS
	mergeTip(m_pRemoteExecCommandline,__tr2qs_ctx("<center>This field contains the command to execute when automatically opening a received file.<br>" \
		"<tt>$0</tt> is used in place of the filename</center>","options"));
#endif

	l = new TQLabel(__tr2qs_ctx("Icon","options"),this);
	layout()->addWidget(l,8,0);
	m_pIcon = new TQLineEdit(this);
	layout()->addMultiCellWidget(m_pIcon,8,8,1,2);

	TQFrame * f = new TQFrame(this);
	f->setFrameStyle(TQFrame::Sunken | TQFrame::HLine);
	layout()->addMultiCellWidget(f,9,9,0,2);

	TQPushButton * b = new TQPushButton(__tr2qs_ctx("&New","options"),this);
	connect(b,TQ_SIGNAL(clicked()),this,TQ_SLOT(newMediaType()));
	layout()->addWidget(b,10,1);

	m_pDelete = new TQPushButton(__tr2qs_ctx("Re&move","options"),this);
	connect(m_pDelete,TQ_SIGNAL(clicked()),this,TQ_SLOT(delMediaType()));
	layout()->addWidget(m_pDelete,10,2);
	

	layout()->setColStretch(1,1);
	layout()->setColStretch(2,1);
	layout()->setRowStretch(0,1);

	m_pLastItem = 0;

	fillListView();
}

KviMediaTypesOptionsWidget::~KviMediaTypesOptionsWidget()
{
}

void KviMediaTypesOptionsWidget::fillListView()
{
	m_pListView->clear();
	g_pMediaManager->lock();
	KviPointerList<KviMediaType> * l = g_pMediaManager->mediaTypeList();
	KviMediaTypeListViewItem * it;
	for(KviMediaType * t = l->first();t;t = l->next())
	{
		it = new KviMediaTypeListViewItem(m_pListView,t);
	}
	g_pMediaManager->unlock();
	enableOrDisable();
}

void KviMediaTypesOptionsWidget::saveLastItem()
{
	if(m_pLastItem)
	{
		KviMediaType t;
		t.szDescription           = m_pDescription->text();
		t.szIanaType              = m_pIanaType->text();
		t.szFileMask              = m_pFileMask->text();
		t.szSavePath              = m_pSavePath->text();
		t.szCommandline           = m_pCommandline->text();
		t.szMagicBytes            = m_pMagicBytes->text();
		t.szRemoteExecCommandline = m_pRemoteExecCommandline->text();
		t.szIcon                  = m_pIcon->text();

		if(t.szDescription.isEmpty())t.szDescription = __tr2qs_ctx("[Unknown Media Type]","options");

		m_pLastItem->copyData(&t);
	}
}

void KviMediaTypesOptionsWidget::enableOrDisable()
{
	m_pDescription->setEnabled(m_pLastItem);
	m_pIanaType->setEnabled(m_pLastItem);
	m_pFileMask->setEnabled(m_pLastItem);
	m_pSavePath->setEnabled(m_pLastItem);
	m_pCommandline->setEnabled(m_pLastItem);
	m_pMagicBytes->setEnabled(m_pLastItem);
	m_pRemoteExecCommandline->setEnabled(m_pLastItem);
	m_pDelete->setEnabled(m_pLastItem);
	m_pIcon->setEnabled(m_pLastItem);
}

void KviMediaTypesOptionsWidget::setLineEdits()
{
	m_pDescription->setText(m_pLastItem ? m_pLastItem->data()->szDescription.ptr() : "");
	m_pIanaType->setText(m_pLastItem ? m_pLastItem->data()->szIanaType.ptr() : "");
	m_pFileMask->setText(m_pLastItem ? m_pLastItem->data()->szFileMask.ptr() : "");
	m_pSavePath->setText(m_pLastItem ? m_pLastItem->data()->szSavePath.ptr() : "");
	m_pCommandline->setText(m_pLastItem ? m_pLastItem->data()->szCommandline.ptr() : "");
	m_pMagicBytes->setText(m_pLastItem ? m_pLastItem->data()->szMagicBytes.ptr() : "");
	m_pRemoteExecCommandline->setText(m_pLastItem ? m_pLastItem->data()->szRemoteExecCommandline.ptr() : "");
	m_pIcon->setText(m_pLastItem ? m_pLastItem->data()->szIcon.ptr() : "");
}

void KviMediaTypesOptionsWidget::currentItemChanged(KviTalListViewItem *it)
{
	saveLastItem();
	m_pLastItem = (KviMediaTypeListViewItem *)it;
	if(it)
	{
		if(!it->isSelected())m_pListView->setSelected(it,true);
	}
	setLineEdits();
	enableOrDisable();
}

void KviMediaTypesOptionsWidget::newMediaType()
{
	KviMediaType empty;
	empty.szDescription = __tr2qs_ctx("New Media Type","options");
	KviMediaTypeListViewItem * it = new KviMediaTypeListViewItem(m_pListView,&empty);
	m_pListView->setCurrentItem(it);
	m_pListView->setSelected(it,true);
}

void KviMediaTypesOptionsWidget::delMediaType()
{
	if(m_pLastItem)
	{
		KviMediaTypeListViewItem * it = m_pLastItem;
		m_pLastItem = 0;
		delete it;
	}
}

void KviMediaTypesOptionsWidget::commit()
{
	saveLastItem();
	KviMediaTypeListViewItem * it = (KviMediaTypeListViewItem *)m_pListView->firstChild();
	g_pMediaManager->lock();
	g_pMediaManager->clear();
	while(it)
	{
		KviMediaType * t = new KviMediaType;
		copyMediaType(t,it->data());
		g_pMediaManager->insertMediaType(t);
		it = (KviMediaTypeListViewItem *)it->nextSibling();
	}
	g_pMediaManager->unlock();
}

#include "m_optw_mediatypes.moc"
