/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef LOG_LINE_FILTER_H
#define LOG_LINE_FILTER_H

//For compatibility with old versions of KDE
#include <tdeversion.h>

//The filter is activated only if KDE version >= 3.3
#if defined(TDE_MAKE_VERSION) && TDE_VERSION >= TDE_MAKE_VERSION(3,3,0)

#include <tdelistviewsearchline.h>

/**
  This class provides a KLineEdit which contains a greyed-out hinting
  text as long as the user didn't enter any text
  Code taken from Daniel Molkentin (Amarok project)

  @short LineEdit with customizable "Click here" text
  @author Nicolas Ternisien
*/
class LogLineFilter : public TDEListViewSearchLine
{
    public:
        LogLineFilter(TQWidget* parent=NULL, TDEListView* listView=NULL, const char* name=NULL);

    protected:
        virtual void drawContents( TQPainter *p );
        virtual void focusInEvent( TQFocusEvent *ev );
        virtual void focusOutEvent( TQFocusEvent *ev );

    private:
        bool drawFilterMessage;

};

#endif

#endif //LOG_LINE_FILTER_H

