/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : dom ago 19 02:10:35 EDT 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>

#include <tdeuniqueapplication.h>
#include "ksensorssplash.h"
#include "lmsensorsdock.h"

static const char *description =
	I18N_NOOP("KSensors - A nice lmsensors frontend for TDE");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static TDECmdLineOptions options[] =
{
  { "nodock", I18N_NOOP("Don't dock in TDE system tray."), 0 },
  { "splash", I18N_NOOP("Show splash screen."), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};


int main(int argc, char *argv[])
{

  TDEAboutData aboutData( "ksensors", I18N_NOOP("KSensors"),
    VERSION, description, TDEAboutData::License_GPL,
    "(c) 2001, Miguel Novas", 0, 0, "michaell@teleline.es");
  aboutData.addAuthor("Miguel Novas",0, "michaell@teleline.es");

  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );
  TDEUniqueApplication::addCmdLineOptions();

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
  bool noDock= !args->isSet("dock");
  bool showSplash=  args->isSet("splash");
  args->clear();

  if(!TDEUniqueApplication::start())  return 0;
  TDEUniqueApplication a;
  // We handle autostart via standard autostart-enabled .desktop file instead of the session
  a.disableSessionManagement();

  TDEConfig *cfg= tdeApp->config();
  cfg->setGroup("General");
  if( cfg->readEntry("Version")!=aboutData.version() ) {
    cfg->writeEntry("Version",aboutData.version());
    showSplash= true;
  }

  if(showSplash)  (void)new KSensorsSplash();

  LMSensorsDock *ksensors= new LMSensorsDock(noDock);
  TQObject::connect( ksensors, TQ_SIGNAL(destroyed()), tdeApp, TQ_SLOT(quit()) );
  TQObject::connect( tdeApp, TQ_SIGNAL(saveYourself()), ksensors, TQ_SLOT(saveConfig()) );

  return a.exec();
}
