/***************************************************************************
*   Copyright (C) 2004 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef HEADERLISTVIEW_H
#define HEADERLISTVIEW_H

#include "dblistviewbase.h"

#include "datablocks/element.h"

class RecipeDB;
class TDEPopupMenu;

class HeaderListView : public DBListViewBase
{
	TQ_OBJECT

public:
	HeaderListView( TQWidget *parent, RecipeDB *db );

public slots:
	virtual void load( int curr_limit, int curr_offset );

protected slots:
	virtual void createHeader( const Element & ) = 0;
	virtual void removeHeader( int ) = 0;

	void checkCreateHeader( const Element &el );

protected:
	virtual void init();
};

class StdHeaderListView : public HeaderListView
{
	TQ_OBJECT

public:
	StdHeaderListView( TQWidget *parent, RecipeDB *db, bool editable = false );

protected:
	virtual void createHeader( const Element & );
	virtual void removeHeader( int );

private slots:
	void showPopup( TDEListView *, TQListViewItem *, const TQPoint & );

	void createNew();
	void remove();
	void rename();

	void modHeader( TQListViewItem* i, const TQPoint &p, int c );
	void saveHeader( TQListViewItem* i, const TQString &text, int c );

private:
	bool checkBounds( const TQString &unit );

	TDEPopupMenu *kpop;
};

#endif //HEADERLISTVIEW_H
