/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   Copyright (C) 2006 Jason Kivlighn (jkivlighn@gmail.com)               *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KRECIPESPREF_H_
#define _KRECIPESPREF_H_

#include <kdialogbase.h>

#include <tqmap.h>

class ServerPrefs;
class NumbersPrefs;
class ImportPrefs;
class PerformancePrefs;

class KIntNumInput;
class KLineEdit;
class KURLRequester;

class TQButtonGroup;
class TQCheckBox;
class TQRadioButton;
class TQVBoxLayout;
class TQComboBox;

class KrecipesPreferences : public KDialogBase
{
	TQ_OBJECT
public:
	KrecipesPreferences( TQWidget *parent );

protected slots:
	void slotHelp();

private:
	ServerPrefs *m_pageServer;
	NumbersPrefs *m_pageNumbers;
	ImportPrefs *m_pageImport;
	PerformancePrefs *m_pagePerformance;

	TQMap<int,TQString> m_helpMap;

private slots:
	void saveSettings( void );
};


class MySQLServerPrefs : public TQWidget
{
public:
	MySQLServerPrefs( TQWidget *parent );

	void saveOptions( void );
private:
	// Internal Widgets
	KURLRequester *dumpPathRequester;
	KURLRequester *mysqlPathRequester;

	KLineEdit *serverEdit;
	KLineEdit *usernameEdit;
	KLineEdit *passwordEdit;
	KLineEdit *dbNameEdit;
	KIntNumInput *portEdit;
};

class PostgreSQLServerPrefs : public TQWidget
{
public:
	PostgreSQLServerPrefs( TQWidget *parent );

	void saveOptions( void );
private:
	// Internal Widgets
	KURLRequester *dumpPathRequester;
	KURLRequester *psqlPathRequester;

	KLineEdit *serverEdit;
	KLineEdit *usernameEdit;
	KLineEdit *passwordEdit;
	KLineEdit *dbNameEdit;
	KIntNumInput *portEdit;
};

class SQLiteServerPrefs : public TQWidget
{
	TQ_OBJECT

public:
	SQLiteServerPrefs( TQWidget *parent );

	void saveOptions( void );

private:
	// Internal Widgets
	KURLRequester *dumpPathRequester;
	KURLRequester *fileRequester;
};


class ServerPrefs : public TQWidget
{
	TQ_OBJECT
public:
	ServerPrefs( TQWidget *parent = 0 );

	// Public Methods
	void saveOptions( void );
private:
	TQWidget *serverWidget;
	TQCheckBox *wizard_button;
};

class NumbersPrefs : public TQWidget
{
	TQ_OBJECT

public:
	NumbersPrefs( TQWidget *parent = 0 );

	void saveOptions();

protected:
	TQButtonGroup* numberButtonGroup;
	TQRadioButton* fractionRadioButton;
	TQRadioButton* decimalRadioButton;

	TQVBoxLayout* Form1Layout;
	TQVBoxLayout* numberButtonGroupLayout;

	KLineEdit *ingredientEdit;
	TQCheckBox *abbrevButton;

protected slots:
	virtual void languageChange();
};

class ImportPrefs : public TQWidget
{
	TQ_OBJECT

public:
	ImportPrefs( TQWidget *parent = 0 );

	void saveOptions();

protected:
	TQVBoxLayout* Form1Layout;
	TQCheckBox* overwriteCheckbox;
	TQCheckBox* directImportCheckbox;

	TQComboBox *clipBoardFormatComboBox;
};


class PerformancePrefs : public TQWidget
{
	TQ_OBJECT

public:
	PerformancePrefs( TQWidget *parent = 0 );

	void saveOptions();

protected:
	TQVBoxLayout* Form1Layout;
	TQCheckBox* searchAsYouTypeBox;
	KIntNumInput* catLimitInput;
	KIntNumInput* limitInput;
};

#endif // _KRECIPESPREF_H_
