/***************************************************************************
*   Copyright (C) 2006 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef HTMLBOOKEXPORTER_H
#define HTMLBOOKEXPORTER_H

#include <tqmap.h>
#include <tqvaluelist.h>

#include "baseexporter.h"
#include "htmlexporter.h"

class RecipeDB;
class CategoryTree;

/**
  * Exports a given recipe list as HTML
  * @author Jason Kivlighn
  */
class HTMLBookExporter : public HTMLExporter
{
public:
	HTMLBookExporter( CategoryTree *categories, const TQString&, const TQString& );
	virtual ~HTMLBookExporter();

protected:
	virtual TQString createContent( const RecipeList & );
	virtual TQString createHeader( const RecipeList & );
	virtual TQString createFooter();

	virtual int headerFlags() const;

private:
	void createCategoryStructure( TQTextStream &xml, const RecipeList &recipes );
	bool removeIfUnused( const TQValueList<int> &cat_ids, CategoryTree *parent, bool parent_should_show = false );
	void writeCategoryStructure( TQTextStream &xml, const CategoryTree *categoryTree );

	TQMap<TQString,TQTextStream*> fileMap;

	RecipeDB *database;
	CategoryTree *m_categories;
	TQString m_basedir;
};

#endif //HTMLBOOKEXPORTER_H
