#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )


#### Find strigi if needed #######################

if (USE_STRIGI)
	find_package(Strigi REQUIRED)
	include_directories(${STRIGI_INCLUDE_DIR})
	message(STATUS "Strigi support is: ON!")
else (USE_STRIGI)
	message(STATUS "Strigi support is: OFF!")
endif (USE_STRIGI)


#### Find menudrake if needed #####################

find_program(HAVE_MANDRAKE menudrake)
if (HAVE_MANDRAKE AND USE_MENUDRAKE)
	set(MANDRAKE "1")
	message(STATUS "Will use 'menudrake' instead of 'kmenuedit'!")
else (HAVE_MANDRAKE AND USE_MENUDRAKE)
	set(MANDRAKE "")
	message(STATUS "Will use 'kmenuedit'!")
endif (HAVE_MANDRAKE AND USE_MENUDRAKE)
