/*
 * playlistitem.h - a self-displayable item for kaffeine's playlist
 *
 * Copyright (C) 2004-2005 Giorgos Gousios
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef PLAYLISTITEM_H
#define PLAYLISTITEM_H

#include <tdelistview.h>

#define MIME_COLUMN 0
#define TITLE_COLUMN 1
#define ARTIST_COLUMN 2
#define ALBUM_COLUMN 3
#define TRACK_COLUMN 4
#define LENGTH_COLUMN 5

class TQTime;
class TQString;
class TQStringList;
class MRL;

class PlaylistItem : public TDEListViewItem
{

public:
   PlaylistItem(TDEListView *list, TDEListViewItem *after, const TQString& url, const TQString& mime, const TQString& title,
                const TQString& length = TQString(), const TQString& artist = TQString(), const TQString& album = TQString(),
                const TQString& track = TQString(), const TQString& year = TQString(), const TQString& genre = TQString(),
		const TQStringList& subtitles = TQStringList(), int currentSubtitle = -1);
   PlaylistItem(TDEListView* list, TDEListViewItem* after, const MRL&);
   virtual ~PlaylistItem();

   MRL toMRL() const;

   const TQString& url() const;
   TQString mime() const;
   TQString title() const;
   TQString artist() const;
   TQString album() const;
   TQString track() const;
   TQString year() const;
   TQString genre() const;
   TQString length() const;
   const TQStringList& subtitles() const;
   int currentSubtitle() const;

   void setUrl(const TQString&);
   void setMime(const TQString&);
   void setTitle(const TQString&);
   void setArtist(const TQString&);
   void setAlbum(const TQString&);
   void setTrack(const TQString&);
   void setYear(const TQString&);
   void setGenre(const TQString&);
   void setLength(const TQString&);
   void setSubtitles(const TQStringList&);
   void addSubtitle(const TQString&);
   void setCurrentSubtitle(int);

   //reimplement to fix track order
   int compare( TQListViewItem *i, int col, bool ascending ) const;

   void setPlaying(bool playing);
   virtual void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int align);

private:
   static TQTime stringToTime(const TQString&);
   TQString m_url;
   TQString m_year;
   TQString m_genre;
   TQStringList m_subtitles;
   int m_currentSubtitle;
   bool isCurrent;
};

#endif /* PLAYLISTITEM_H */
