
# required stuff

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

find_package( TQt )
find_package( TDE )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


#### gtk+-2.0

pkg_search_module( GTK gtk+-2.0 )

if( NOT GTK_FOUND )
    tde_message_fatal( "gtk2 is required but was not found on your system" )
endif( )

execute_process(
  COMMAND ${PKG_CONFIG_EXECUTABLE}
    gtk+-2.0 --variable=gtk_binary_version
  OUTPUT_VARIABLE GTK_BIN_VERSION
  OUTPUT_STRIP_TRAILING_WHITESPACE
)
set( INSTALL_PATH_GTK_ENGINES "${GTK_LIBDIR}/gtk-2.0/${GTK_BIN_VERSION}/engines"
     CACHE PATH "The directory in which to install the theme engine library" )
message( STATUS "  theme engine lib directory: ${INSTALL_PATH_GTK_ENGINES}" )
set( INSTALL_PATH_GTK_THEMES "${GTK_PREFIX}/share/themes"
     CACHE PATH "The directory in which to install the theme data" )
MESSAGE( STATUS "  theme engine data directory: ${INSTALL_PATH_GTK_THEMES}" )


#### libbonoboui-2.0

pkg_search_module( BONOBO libbonoboui-2.0 )

if( NOT BONOBO_FOUND )
    message( STATUS "bonoboui not found. Some features of the theme engine will not work as intended." )
else( )
    set( HAVE_BONOBO 1 )
endif( )
