/*
 * Copyright (C) 2002 by Roberto Raggi
 * roberto@kdevelop.org
 * Copyright (C) 2003 Oliver Kellogg
 * okellogg@users.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef BACKGROUNDPARSER_H
#define BACKGROUNDPARSER_H

#include <tqthread.h>
#include <tqstring.h>
#include <kdebug.h>

class ProblemReporter;

class BackgroundParser: public TQThread{
public:
    BackgroundParser( ProblemReporter* reporter,
                      const TQString& source,
                      const TQString& filename );
    virtual ~BackgroundParser();

    virtual void run();

private:
    ProblemReporter* m_reporter;
    TQString m_source;
    TQString m_fileName;
};

#endif
