/*
 * xmlcommon.h - helper functions for dealing with XML
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef JABBER_XMLCOMMON_H
#define JABBER_XMLCOMMON_H

#include <tqdom.h>

class TQDateTime;
class TQRect;
class TQSize;
class TQColor;
class TQStringList;

bool stamp2TS(const TQString &ts, TQDateTime *d);
TQString TS2stamp(const TQDateTime &d);
TQDomElement textTag(TQDomDocument *doc, const TQString &name, const TQString &content);
TQString tagContent(const TQDomElement &e);
TQDomElement findSubTag(const TQDomElement &e, const TQString &name, bool *found);
TQDomElement createIQ(TQDomDocument *doc, const TQString &type, const TQString &to, const TQString &id);
TQDomElement queryTag(const TQDomElement &e);
TQString queryNS(const TQDomElement &e);
void getErrorFromElement(const TQDomElement &e, int *code, TQString *str);

namespace XMLHelper {
	//TQDomElement findSubTag(const TQDomElement &e, const TQString &name, bool *found);
	bool hasSubTag(const TQDomElement &e, const TQString &name);

	TQDomElement emptyTag(TQDomDocument *doc, const TQString &name);
	TQString subTagText(const TQDomElement &e, const TQString &name);

	TQDomElement textTag(TQDomDocument &doc, const TQString &name, const TQString &content);
	TQDomElement textTag(TQDomDocument &doc, const TQString &name, int content);
	TQDomElement textTag(TQDomDocument &doc, const TQString &name, bool content);
	TQDomElement textTag(TQDomDocument &doc, const TQString &name, TQSize &s);
	TQDomElement textTag(TQDomDocument &doc, const TQString &name, TQRect &r);
	TQDomElement stringListToXml(TQDomDocument &doc, const TQString &name, const TQStringList &l);

	void readEntry(const TQDomElement &e, const TQString &name, TQString *v);
	void readNumEntry(const TQDomElement &e, const TQString &name, int *v);
	void readBoolEntry(const TQDomElement &e, const TQString &name, bool *v);
	void readSizeEntry(const TQDomElement &e, const TQString &name, TQSize *v);
	void readRectEntry(const TQDomElement &e, const TQString &name, TQRect *v);
	void readColorEntry(const TQDomElement &e, const TQString &name, TQColor *v);

	void xmlToStringList(const TQDomElement &e, const TQString &name, TQStringList *v);

	void setBoolAttribute(TQDomElement e, const TQString &name, bool b);
	void readBoolAttribute(TQDomElement e, const TQString &name, bool *v);

	//TQString tagContent(const TQDomElement &e); // obsolete;
}

#endif
