#ifndef _KVI_IRCCONNECTIONUSERINFO_H_
#define _KVI_IRCCONNECTIONUSERINFO_H_
//=============================================================================
//
//   File : kvi_ircconnectionuserinfo.h
//   Created on Sun 20 Jun 2004 01:45:42 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_time.h"

class KVIRC_API KviIrcConnectionUserInfo
{
	friend class KviIrcConnection;
	friend class KviServerParser;
	friend class KviConsole;
protected:
	KviIrcConnectionUserInfo();
	~KviIrcConnectionUserInfo(){};
private:
	TQString    m_szRealName;          // the actual real name sent from the server
	TQString    m_szNickName;          // the actual nick name acknowledged by the server
	TQString    m_szUserMode;          // the actual user mode
	TQString    m_szUserName;          // user name with ident char
	TQString    m_szLocalHostIp;       // the local host ip as found by resolveLocalHost() at connection startup
	TQString    m_szHostName;          // the local host name that the server reports
	TQString    m_szHostIp;            // the host name above resolved, if possible
	TQString    m_szAwayReason;
	bool       m_bAway;               // is the user away ?
	kvi_time_t m_tAway;               // time at that the user went away
	TQString    m_szNickBeforeAway;    // the nickname that the user had just before going away
	// From bugtrack:
	// On many IRC networks the host is masked or hashed, and if one also is connected through a LAN,
	// it is basically impossible to initiate DCC transfers, as 192.168.0.13 or similar will be sent as IP.
	// But IRC servers usually (at least in my experience) send the unmasked host in the 001 raw event
	// with something like ":Welcome to the Internet Relay Chat network, nick!ident@host". I think
	// it'd be a good idea to just grab the IP from that event and use it for DCC transfers by default.
	TQString    m_szUnmaskedHostName;
public:
	const TQString & realName(){ return m_szRealName; };
	const TQString & nickName(){ return m_szNickName; };
	const TQString & userMode(){ return m_szUserMode; };
	const TQString & userName(){ return m_szUserName; };
	const TQString & localHostIp(){ return m_szLocalHostIp; };
	const TQString & hostName(){ return m_szHostName; };
	const TQString & unmaskedHostName(){ return m_szUnmaskedHostName; };
	const TQString & hostIp(){ return m_szHostIp; };
	const TQString & awayReason() { return m_szAwayReason; };
	bool hasUserMode(const TQChar & m);
	bool isAway(){ return m_bAway; };
	time_t awayTime(){ return m_tAway; };
	const TQString & nickNameBeforeAway(){ return m_szNickBeforeAway; };
protected:
	void setRealName(const TQString &szRealName){ m_szRealName = szRealName; };
	void setNickName(const TQString &szNickName){ m_szNickName = szNickName; };
	void setUserMode(const TQString &szUserMode){ m_szUserMode = szUserMode; };
	void setUserName(const TQString &szUserName){ m_szUserName = szUserName; };
	void setHostName(const TQString &szHostName){ m_szHostName = szHostName; };
	void setUnmaskedHostName(const TQString &szHostName){ m_szUnmaskedHostName = szHostName; };
	void setHostIp(const TQString &szHostIp){ m_szHostIp = szHostIp; };
	void setLocalHostIp(const TQString &szLocalHostIp){ m_szLocalHostIp = szLocalHostIp; };
	bool addUserMode(const TQChar &m); // returns false if the mode was already there
	bool removeUserMode(const TQChar &m); // returns fales if the mode was not there
	void setAwayReason(const TQString& szReazon) { m_szAwayReason=szReazon; };
	void setAway();
	void setBack();
};

#endif //!_KVI_IRCCONNECTIONUSERINFO_H_
