#ifndef _KVI_FILEUTILS_H_
#define _KVI_FILEUTILS_H_

//
//   File : kvi_fileutils.h
//   Creation date : Fri Dec 25 1998 18:27:04 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"
#include "kvi_string.h"

#include <tqfile.h>
#include <tqstringlist.h>

#include <time.h>


#ifdef COMPILE_ON_WINDOWS
	#define KVI_PATH_SEPARATOR "\\"
	#define KVI_PATH_SEPARATOR_CHAR '\\'
#else
	#define KVI_PATH_SEPARATOR "/"
	#define KVI_PATH_SEPARATOR_CHAR '/'
#endif

// #warning "Add kvi_trashFile(const char * path) ? - is it needed in the whole app"
// #warning "or should it be availible only for dirbrowser module ?"
namespace KviFileUtils
{
	//extern KVILIB_API bool readLine(TQFile * f,TQString &szBuffer,bool bClearBuffer = true);
	//extern KVILIB_API bool loadFileStripCR(const TQString &szPath,TQString &szBuffer);

	// loads the file at szPath to szBuffer eventually converting from utf8
	extern KVILIB_API bool loadFile(const TQString &szPath,TQString &szBuffer,bool bUtf8 = true);
	extern KVILIB_API bool loadFile(const char* szPath,TQString &szBuffer,bool bUtf8 = true);
	// adjusts the file path to the current platform
	extern KVILIB_API void adjustFilePath(TQString &szPath);
	// returns true if szPath points to an existing directory
	extern KVILIB_API bool directoryExists(const TQString &szPath);
	extern KVILIB_API bool directoryExists(const char* path);
	// returns true if szPath points to an existing file
	extern KVILIB_API bool fileExists(const TQString &szPath);
	extern KVILIB_API bool fileExists(const char* szPath);
	// removes a file
	extern KVILIB_API bool removeFile(const TQString &szPath);
	extern KVILIB_API bool removeFile(const char* path);
	// removes a dir (must be empty)
	extern KVILIB_API bool removeDir(const TQString &szPath);
	extern KVILIB_API bool removeDir(const char* path);
	// removes a dir recursively
	extern KVILIB_API bool deleteDir(const TQString &szPath);
	// writes a complete file (utf8 version)
	extern KVILIB_API bool writeFile(const TQString &szPath,const TQString &szData,bool bAppend = false);
	extern KVILIB_API bool writeFile(const char* path,const TQString &szData,bool bAppend = false);
	// writes a complete file (local 8 bit version)
	extern KVILIB_API bool writeFileLocal8Bit(const TQString &szPath,const TQString &szData,bool bAppend = false);
	extern KVILIB_API bool writeFileLocal8Bit(const char* path,const TQString &szData,bool bAppend = false);
	// reads a complete file and puts it in the string szBuffer, if the file is smaller than uMaxSize bytes
	extern KVILIB_API bool readFile(const TQString &szPath,TQString &szBuffer,unsigned int uMaxSize = 65535);
	extern KVILIB_API bool readFile(const char* path,TQString &szBuffer,unsigned int uMaxSize = 65535);
	// extracts the filename from a complete path (strips leading path)
	extern KVILIB_API TQString extractFileName(const TQString &szFileNameWithPath);

	extern KVILIB_API TQString extractFilePath(const TQString &szFileNameWithPath);
	// cp -f
	extern KVILIB_API bool copyFile(const TQString &szSrc,const TQString &szDst);
	extern KVILIB_API bool copyFile(const char* src,const char* dst);
	// mv
	extern KVILIB_API bool renameFile(const TQString &szSrc,const TQString &szDst);
	extern KVILIB_API bool renameFile(const char* src,const char* dst);
	// mkdir
	extern KVILIB_API bool makeDir(const TQString &szPath);
	extern KVILIB_API bool makeDir(const char* path);
	// reads a text line, returns false if EOF is reached
	extern KVILIB_API bool readLine(TQFile * f,TQString &szBuffer,bool bUtf8 = true);
	extern KVILIB_API bool readLines(TQFile * f,TQStringList &buffer,int iStartLine = 0, int iCount = -1, bool bUtf8 = true);
	extern KVILIB_API bool isReadable(const TQString &szFname);
	extern KVILIB_API bool isAbsolutePath(const TQString &szPath);
};

// ALL THIS STUFF BELOW SHOULD DIE: IF YOU SEE IT, REPLACE WITH THE FUNCTIONS IN THE NAMESPACE ABOVE

// Returns true if the path begins with '/'
KVILIB_API extern bool kvi_isAbsolutePath(const char *path);
// Translates ANY string into a valid filename (with no path!)
// There is NO way to come back to the original string
// the algo is one-way only
KVILIB_API extern void kvi_encodeFileName(KviStr & path);
KVILIB_API extern void kvi_encodeFileName(TQString & path);

// Reads a single line from the file and returns false if EOF was encountered.
KVILIB_API extern bool kvi_readLine(TQFile *f,KviStr &str);
// Removes a file

#endif //_KVI_FILEUTILS_H_INCLUDED_
