//=============================================================================
//
//   File : kvi_miscutils.cpp
//   Created on Mon 08 Jan 2007 04:07:31 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2007 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#define __KVILIB__
#include "kvi_miscutils.h"

#include <tqstringlist.h>

namespace KviMiscUtils
{
	int compareVersions(const TQString &szVersion1,const TQString &szVersion2)
	{
		TQStringList sl1 = TQStringList::split(".",szVersion1);
		TQStringList sl2 = TQStringList::split(".",szVersion2);
	
		TQStringList::Iterator it1 = sl1.begin();
		TQStringList::Iterator it2 = sl2.begin();
		while((it1 != sl1.end()) && (it2 != sl2.end()))
		{
			bool bOk;
			int i1 = (*it1).toInt(&bOk);
			if(!bOk)return 1;
			int i2 = (*it2).toInt(&bOk);
			if(!bOk)return -1;
			if(i1 != i2)
			{
				// field not equal
				if(i1 > i2)return -1;
				else return 1;
			}
			it1++;
			it2++;
		}
		// both are equal until now
		if(it1 != sl1.end())return -1; // 1 has at least one field more
		if(it2 != sl2.end())return 1;  // 2 has at least one field more
		// both are equal also in length
		return 0;
	}

	bool isValidVersionString(const TQString &szVersion)
	{
		TQStringList sl = TQStringList::split(".",szVersion);
		if(sl.isEmpty())return false;
		// must all be numbers
		for(TQStringList::Iterator it = sl.begin();it != sl.end();++it)
		{
			bool bOk;
			int i = (*it).toInt(&bOk);
			if(!bOk)return false;
			if(i < 0)return false;
		}
		return true;
	}

};
